/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.GridBoxConfig;
import aurora.presentation.component.std.config.GridLayoutConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class GridLayout
extends Component
implements IViewBuilder {
    public static final String VERSION = "$Revision: 8425 $";
    public static final String ROWS = "row";
    public static final String COLUMNS = "column";
    protected static final int UNLIMITED = -1;
    protected static final String TITLE_CLASS = "layout-title";
    protected static final String DEFAULT_TABLE_CLASS = "layout-table";
    protected static final String DEFAULT_TD_CELL = "layout-td-cell";
    protected static final String DEFAULT_TD_CONTAINER = "layout-td-con";

    public GridLayout(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected int getDefaultWidth() {
        return 0;
    }

    @Override
    protected int getDefaultHeight() {
        return 0;
    }

    protected int getRows(CompositeMap view, CompositeMap model) {
        GridLayoutConfig glc = new GridLayoutConfig();
        glc.initialize(view);
        return glc.getRow(model, -1);
    }

    protected int getColumns(CompositeMap view, CompositeMap model) {
        GridLayoutConfig glc = new GridLayoutConfig();
        glc.initialize(view);
        return glc.getColumn(model, -1);
    }

    private void buildCell(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap field) throws Exception {
        String width;
        if (this.isHidden(field, model)) {
            return;
        }
        this.beforeBuildCell(session, model, view, field);
        GridLayoutConfig glc = new GridLayoutConfig();
        glc.initialize(view);
        Writer out = session.getWriter();
        int padding = glc.getPadding(model, 3);
        int colspan = field.getInt("colspan", 1);
        int rowspan = field.getInt("rowspan", 1);
        String hostId = glc.getHostId();
        IViewBuilder builder = session.getPresentationManager().getViewBuilder(field);
        out.write("<td class='");
        if (builder instanceof GridLayout) {
            out.write(DEFAULT_TD_CONTAINER);
        } else {
            out.write(DEFAULT_TD_CELL);
        }
        if (glc.isWrapperAdjust() && (width = field.getString("width")) != null) {
            out.write("' width='" + width);
        }
        if (colspan > 1) {
            out.write("' colspan='" + (colspan * 2 - 1));
        }
        if (rowspan > 1) {
            out.write("' rowspan='" + rowspan);
        }
        out.write("' style='padding:" + padding + "px");
        if ("gridBox".equals(field.getName())) {
            GridBoxConfig gbc = GridBoxConfig.getInstance(field);
            String gridboxid = TextParser.parse(gbc.getId(), model);
            if (gridboxid == null || "".equals(gridboxid)) {
                gridboxid = IDGenerator.getInstance().generate();
            }
            field.putString("id", gridboxid);
            field.putInt("padding", padding);
            out.write("' id='" + gridboxid);
        }
        out.write("'>");
        if (hostId != null) {
            field.putString("hostid", hostId);
        }
        session.buildView(model, field);
        boolean cfr_ignored_0 = builder instanceof GridLayout;
        out.write("</td>");
    }

    protected void beforeBuildCell(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap field) throws Exception {
    }

    protected void afterBuildCell(BuildSession session, CompositeMap model, CompositeMap field) throws Exception {
    }

    protected void buildHead(BuildSession session, CompositeMap model, CompositeMap view, int rows, int columns) throws Exception {
    }

    protected void buildFoot(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
    }

    protected void beforeBuildTop(BuildSession session, CompositeMap model, CompositeMap view, String id) throws Exception {
    }

    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
    }

    protected void afterBuildBottom(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
    }

    protected String getClassName(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        String cls = view.getString("classname", "");
        String className = DEFAULT_TABLE_CLASS;
        className = String.valueOf(className) + " " + cls;
        return className;
    }

    protected String getStyle(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        return view.getString("style", "");
    }

    private void buildRows(BuildSession session, CompositeMap model, CompositeMap view, Iterator it) throws Exception {
        Writer out = session.getWriter();
        while (it.hasNext()) {
            out.write("<tr>");
            CompositeMap field = (CompositeMap)it.next();
            field.putInt("rowspan", 1);
            field.putInt("colspan", 1);
            this.buildCell(session, model, view, field);
            out.write("</tr>");
        }
    }

    private void buildColumns(BuildSession session, CompositeMap model, CompositeMap view, Iterator it) throws Exception {
        Writer out = session.getWriter();
        out.write("<tr>");
        while (it.hasNext()) {
            CompositeMap field = (CompositeMap)it.next();
            field.putInt("rowspan", 1);
            field.putInt("colspan", 1);
            this.buildCell(session, model, view, field);
        }
        out.write("</tr>");
    }

    protected void buildTop(BuildSession session, CompositeMap model, CompositeMap view, Map map, int rows, int columns, String id) throws Exception {
        this.beforeBuildTop(session, model, view, id);
        GridLayoutConfig glc = new GridLayoutConfig();
        glc.initialize(view);
        Writer out = session.getWriter();
        int cellspacing = glc.getCellSpacing(model);
        int cellpadding = glc.getCellPadding(model);
        boolean showBorder = view.getBoolean("showborder", false);
        int width = this.getComponentWidth(model, view, map);
        int height = this.getComponentHeight(model, view, map);
        String className = this.getClassName(session, model, view);
        String style = this.getStyle(session, model, view);
        if (showBorder) {
            cellspacing = 1;
            className = String.valueOf(className) + " layout-border";
        }
        out.write("<table border=0 class='" + className + "' id='" + id + "'");
        if (width != 0) {
            out.write(" width=" + width);
        }
        if (height != 0) {
            out.write(" height=" + height);
        }
        if (!"".equals(style)) {
            out.write(" style='" + style + "'");
        }
        out.write(" cellpadding=" + cellpadding + " cellspacing=" + cellspacing + ">");
        this.buildHead(session, model, view, rows, columns);
        this.afterBuildTop(session, model, view, columns);
    }

    protected void buildBottom(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        this.buildFoot(session, model, view, columns);
        Writer out = session.getWriter();
        out.write("</tbody>");
        out.write("</table>");
        this.afterBuildBottom(session, model, view, columns);
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        Map map = view_context.getMap();
        String id = view.getString("id", "");
        if ("".equals(id)) {
            id = IDGenerator.getInstance().generate();
        }
        Writer out = session.getWriter();
        Iterator it = view.getChildIterator();
        int rows = this.getRows(view, model);
        int columns = this.getColumns(view, model);
        int cl = this.getChildLength(view, model);
        if (rows != 0 && columns != 0) {
            List children;
            if (rows == -1 && columns == -1) {
                rows = -1;
                columns = 1;
            } else if (rows == -1 && columns != -1) {
                children = view.getChilds();
                rows = children != null ? (int)Math.ceil((double)cl / (double)columns) : 1;
            } else if (rows != -1 && columns == -1) {
                children = view.getChilds();
                columns = children != null ? (int)Math.ceil((double)cl / (double)rows) : 1;
            }
        }
        try {
            this.buildTop(session, model, view, map, rows, columns, id);
            if (it != null && rows != 0 && columns != 0) {
                if (rows == -1) {
                    this.buildRows(session, model, view, it);
                } else if (columns == -1) {
                    this.buildColumns(session, model, view, it);
                } else {
                    int[] rowspans = new int[columns];
                    int i = 0;
                    while (i < columns) {
                        rowspans[i] = 0;
                        ++i;
                    }
                    int n = 0;
                    while (n < rows) {
                        out.write("<tr>");
                        int k = 0;
                        int j = 0;
                        while (j < columns) {
                            if (rowspans[j] > 0) {
                                ++k;
                                int n2 = j;
                                rowspans[n2] = rowspans[n2] - 1;
                            }
                            ++j;
                        }
                        while (k < columns) {
                            if (it.hasNext()) {
                                CompositeMap field = (CompositeMap)it.next();
                                if (this.isHidden(field, model)) {
                                    --k;
                                    --cl;
                                } else {
                                    int colspan = field.getInt("colspan", 1);
                                    int rowspan = field.getInt("rowspan", 1);
                                    GridBoxConfig gbc = null;
                                    if ("gridBox".equals(field.getName())) {
                                        gbc = GridBoxConfig.getInstance(field);
                                        colspan = gbc.getColumn() + 1;
                                        field.putInt("colspan", colspan);
                                        field.putBoolean("underbox", true);
                                    }
                                    if (rowspan > 1 || colspan > 1) {
                                        if (colspan > 1 && k + colspan > columns) {
                                            colspan = columns - k;
                                            field.putInt("colspan", colspan);
                                            if (gbc != null) {
                                                field.putInt(COLUMNS, colspan - 1);
                                            }
                                        }
                                        int cn = 0;
                                        while (cn < colspan) {
                                            int n3 = k + cn;
                                            rowspans[n3] = rowspans[n3] + (rowspan - 1);
                                            ++cn;
                                        }
                                        k += colspan - 1;
                                        cl += rowspan * colspan - 1;
                                    }
                                }
                                rows = (int)Math.ceil((double)cl / (double)columns);
                                this.buildCell(session, model, view, field);
                            } else {
                                out.write("<th class='layout-th'></th><td class='layout-td-cell'></td>");
                            }
                            ++k;
                        }
                        out.write("</tr>");
                        ++n;
                    }
                }
            }
            this.buildBottom(session, model, view, columns);
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

