/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.Form;
import aurora.presentation.component.std.config.FieldBoxColumnConfig;
import aurora.presentation.component.std.config.FieldBoxConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class FieldBox
extends Form {
    public static final String VERSION = "$Revision: 8397 $";
    private static final String DEFAULT_HEAD_CLASS = "fieldbox_head";
    private static final String DEFAULT_BODY_CLASS = "fieldbox_body";
    protected static final String TITLE_CLASS = "fieldbox_layout-title";
    private CompositeMap fieldBoxColumns;

    public FieldBox(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getHeadClass() {
        return DEFAULT_HEAD_CLASS;
    }

    @Override
    protected String getBodyClass() {
        return DEFAULT_BODY_CLASS;
    }

    @Override
    protected String getClassName(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        String cls = view.getString("classname", "");
        String className = "layout-table layout-fieldbox";
        String title = view.getString("title", "");
        if (!"".equals(title = session.getLocalizedPrompt(TextParser.parse(title, model)))) {
            className = String.valueOf(className) + " fieldbox_layout-title";
        }
        className = String.valueOf(className) + " " + cls;
        return className;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        FieldBoxConfig fbc = FieldBoxConfig.getInstance(view);
        Integer fieldHeight = fbc.getFieldHeight(model);
        String fontStyle = fbc.getFontStyle(model);
        int padding = fbc.getPadding(model, 3);
        this.fieldBoxColumns = view.getChild("fieldBoxColumns");
        if (fontStyle != null) {
            view.putString("style", String.valueOf(fontStyle) + ";" + fbc.getStyle());
        }
        if (this.fieldBoxColumns != null) {
            view.removeChild(this.fieldBoxColumns);
            List childs = this.fieldBoxColumns.getChilds();
            if (childs != null) {
                int length = childs.size();
                view.putInt("column", length);
                LinkedList[] list = new LinkedList[length];
                int i = 0;
                while (i < length) {
                    list[i] = new LinkedList();
                    ++i;
                }
                Iterator it = childs.iterator();
                int i2 = 0;
                int n = 0;
                while (it.hasNext()) {
                    CompositeMap column = (CompositeMap)it.next();
                    Iterator fieldList = column.getChildIterator();
                    Integer columnFieldHeight = FieldBoxColumnConfig.getInstance(column).getFieldHeight(model);
                    if (columnFieldHeight == null) {
                        columnFieldHeight = fieldHeight;
                    }
                    while (fieldList.hasNext()) {
                        CompositeMap field = (CompositeMap)fieldList.next();
                        int colspan = field.getInt("colspan", 1);
                        int rowspan = field.getInt("rowspan", 1);
                        String height = field.getString("height");
                        if ("fieldGroup".equals(field.getName())) {
                            field.putInt("padding", padding);
                        }
                        String fieldFontStyle = TextParser.parse(field.getString("fontstyle"), model);
                        if (fontStyle != null && fieldFontStyle == null) {
                            field.putString("fontstyle", fontStyle);
                        }
                        if (columnFieldHeight != null && height == null) {
                            field.putInt("height", columnFieldHeight);
                            field.putInt("fieldheight", columnFieldHeight);
                        }
                        list[i2].add(field);
                        int j = 0;
                        while (j < rowspan) {
                            int k = 0;
                            while (k < colspan) {
                                if (j != 0 || k != 0) {
                                    list[i2 + k].add(null);
                                }
                                ++k;
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
                boolean isEmpty = true;
                CompositeMap preChild = null;
                i2 = 0;
                while (i2 < length) {
                    CompositeMap item = null;
                    if (n < list[i2].size()) {
                        item = (CompositeMap)list[i2].get(n);
                        isEmpty = false;
                    }
                    if (item != null) {
                        if (preChild == null) {
                            int m = 0;
                            while (m < i2) {
                                if (n >= list[m].size()) {
                                    view.addChild(new CompositeMap("span"));
                                }
                                ++m;
                            }
                        }
                        preChild = item;
                        view.addChild(item);
                    }
                    if (isEmpty || ++i2 != length) continue;
                    i2 = 0;
                    ++n;
                    isEmpty = true;
                    preChild = null;
                }
            }
        }
        super.buildView(session, view_context);
    }

    @Override
    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        super.afterBuildTop(session, model, view, columns);
        Writer out = session.getWriter();
        FieldBoxConfig fbc = FieldBoxConfig.getInstance(view);
        if (this.fieldBoxColumns != null) {
            out.write("<tr height='0'>");
            Iterator it = this.fieldBoxColumns.getChildIterator();
            while (it.hasNext()) {
                CompositeMap column = (CompositeMap)it.next();
                FieldBoxColumnConfig fbcc = FieldBoxColumnConfig.getInstance(column);
                Integer fieldWidth = fbcc.getFieldWidth(model) == null ? fbc.getFieldWidth(model) : fbcc.getFieldWidth(model);
                int labelWidth = fbcc.getLabelWidth(model) == null ? fbc.getLabelWidth(model).intValue() : fbcc.getLabelWidth(model).intValue();
                out.write("<th width='" + labelWidth + "'></th><td");
                if (fieldWidth != null) {
                    out.write(" width='" + fieldWidth + "'");
                }
                out.write("></td>");
            }
            out.write("</tr>");
        }
        out.write("<tr height='0'><td colspan=" + columns * 2 + "></td></tr>");
    }
}

