/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.JSONFunction;
import aurora.presentation.component.std.config.EventConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Chart
extends Component {
    public static final String VERSION = "$Revision: 8397 $";
    public static String INPUT_TYPE = "inputtype";
    public static String DEFAULT_INPUT_TYPE = "input";
    private static final String PROPERTITY_SERIES_NAME = "seriesName";
    private static final String PROPERTITY_THEME = "chartTheme";
    private static final String PROPERTITY_CHART_ALIGNTICKS = "alignTicks";
    private static final String PROPERTITY_CHART_ANIMATION = "animation";
    private static final String PROPERTITY_CHART_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_CHART_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_CHART_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_CHART_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_CHART_CLASSNAME = "className";
    private static final String PROPERTITY_CHART_DEFAULTSERIESTYPE = "defaultSeriesType";
    private static final String PROPERTITY_CHART_IGNORE_HIDDEN_SERIES = "ignoreHiddenSeries";
    private static final String PROPERTITY_CHART_INVERTED = "inverted";
    private static final String PROPERTITY_CHART_MARGIN = "margin";
    private static final String PROPERTITY_CHART_MARGIN_TOP = "marginTop";
    private static final String PROPERTITY_CHART_MARGIN_RIGHT = "marginRight";
    private static final String PROPERTITY_CHART_MARGIN_LEFT = "marginLeft";
    private static final String PROPERTITY_CHART_MARGIN_BOTTOM = "marginBottom";
    private static final String PROPERTITY_CHART_PINCH_TYPE = "pinchType";
    private static final String PROPERTITY_CHART_PLOT_BACKGROUND_COLOR = "plotBackgroundColor";
    private static final String PROPERTITY_CHART_PLOT_BACKGROUND_IMAGE = "plotBackgroundImage";
    private static final String PROPERTITY_CHART_PLOT_BORDER_COLOR = "plotBorderColor";
    private static final String PROPERTITY_CHART_PLOT_BORDER_WIDTH = "plotBorderWidth";
    private static final String PROPERTITY_CHART_PLOT_SHADOW = "plotShadow";
    private static final String PROPERTITY_CHART_REFLOW = "reflow";
    private static final String PROPERTITY_CHART_RENDERTO = "renderTo";
    private static final String PROPERTITY_CHART_SELECTIONMARKERFILL = "selectionMarkerFill";
    private static final String PROPERTITY_CHART_SHADOW = "shadow";
    private static final String PROPERTITY_CHART_SHOW_AXES = "showAxes";
    private static final String PROPERTITY_CHART_SPACING_TOP = "spacingTop";
    private static final String PROPERTITY_CHART_SPACING_RIGHT = "spacingRight";
    private static final String PROPERTITY_CHART_SPACING_BOTTOM = "spacingBottom";
    private static final String PROPERTITY_CHART_SPACING_LEFT = "spacingLeft";
    private static final String PROPERTITY_CHART_STYLE = "chartStyle";
    private static final String PROPERTITY_CHART_TYPE = "type";
    private static final String PROPERTITY_CHART_ZOOMTYPE = "zoomType";
    private static final String PROPERTITY_CHART_RESETZOOMBUTTON = "resetZoomButton";
    private static final String PROPERTITY_CHART_RESETZOOMBUTTON_RELATIVETO = "relativeTo";
    private static final String PROPERTITY_CHART_RESETZOOMBUTTON_THEME = "theme";
    private static final String PROPERTITY_CHART_POLAR = "polar";
    private static final String PROPERTITY_CHART_NAME_FIELD = "namefield";
    private static final String PROPERTITY_CHART_VALUE_FIELD = "valuefield";
    private static final String PROPERTITY_CHART_GROUPBY = "groupBy";
    private static final String PROPERTITY_CREDITS = "credits";
    private static final String PROPERTITY_CREDITS_ENABLED = "enabled";
    private static final String PROPERTITY_POSITION = "position";
    private static final String PROPERTITY_POSITION_ALIGN = "align";
    private static final String PROPERTITY_POSITION_X = "x";
    private static final String PROPERTITY_POSITION_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_POSITION_Y = "y";
    private static final String PROPERTITY_CREDITS_HREF = "href";
    private static final String PROPERTITY_CREDITS_STYLE = "style";
    private static final String PROPERTITY_CREDITS_TEXT = "text";
    private static final String PROPERTITY_LABELS = "chartLabels";
    private static final String PROPERTITY_LABELS_STYLE = "style";
    private static final String PROPERTITY_LABELS_LABEL_HTML = "html";
    private static final String PROPERTITY_LABELS_LABEL_STYLE = "style";
    private static final String PROPERTITY_LABELS_ITEMS = "items";
    private static final String PROPERTITY_LOADING = "loading";
    private static final String PROPERTITY_LOADING_HIDEDURATION = "hideDuration";
    private static final String PROPERTITY_LOADING_LABELSTYLE = "labelStyle";
    private static final String PROPERTITY_LOADING_SHOWDURATION = "showDuration";
    private static final String PROPERTITY_LOADING_STYLE = "style";
    private static final String PROPERTITY_LEGEND = "legend";
    private static final String PROPERTITY_LEGEND_ALIGN = "align";
    private static final String PROPERTITY_LEGEND_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_LEGEND_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_LEGEND_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_LEGEND_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_LEGEND_ENABLED = "enabled";
    private static final String PROPERTITY_LEGEND_FLOATING = "floating";
    private static final String PROPERTITY_LEGEND_ITEMDISTANCE = "itemDistance";
    private static final String PROPERTITY_LEGEND_ITEMHIDDENSTYLE = "itemHiddenStyle";
    private static final String PROPERTITY_LEGEND_ITEMHOVERSTYLE = "itemHoverStyle";
    private static final String PROPERTITY_LEGEND_ITEMMARGINBOTTOM = "itemMarginBottom";
    private static final String PROPERTITY_LEGEND_ITEMMARGINTOP = "itemMarginTop";
    private static final String PROPERTITY_LEGEND_ITEMSTYLE = "itemStyle";
    private static final String PROPERTITY_LEGEND_ITEMWIDTH = "itemWidth";
    private static final String PROPERTITY_LEGEND_LABELFORMAT = "labelFormat";
    private static final String PROPERTITY_LEGEND_LABELFORMATTER = "labelFormatter";
    private static final String PROPERTITY_LEGEND_LAYOUT = "layout";
    private static final String PROPERTITY_LEGEND_LINEHEIGHT = "lineHeight";
    private static final String PROPERTITY_LEGEND_MARGIN = "margin";
    private static final String PROPERTITY_LEGEND_MAXHEIGHT = "maxHeight";
    private static final String PROPERTITY_LEGEND_NAVIGATION = "legendNavigation";
    private static final String PROPERTITY_LEGEND_NAVIGATION_ACTIVECOLOR = "activeColor";
    private static final String PROPERTITY_LEGEND_NAVIGATION_ANIMATION = "animation";
    private static final String PROPERTITY_LEGEND_NAVIGATION_ARROWSIZE = "arrowSize";
    private static final String PROPERTITY_LEGEND_NAVIGATION_INACTIVECOLOR = "inactiveColor";
    private static final String PROPERTITY_LEGEND_NAVIGATION_STYLE = "style";
    private static final String PROPERTITY_LEGEND_PADDING = "padding";
    private static final String PROPERTITY_LEGEND_REVERSED = "reversed";
    private static final String PROPERTITY_LEGEND_RTL = "rtl";
    private static final String PROPERTITY_LEGEND_SHADOW = "shadow";
    private static final String PROPERTITY_LEGEND_STYLE = "style";
    private static final String PROPERTITY_LEGEND_SYMBOLPADDING = "symbolPadding";
    private static final String PROPERTITY_LEGEND_SYMBOLWIDTH = "symbolWidth";
    private static final String PROPERTITY_LEGEND_TITLE = "legendTitle";
    private static final String PROPERTITY_LEGEND_USEHTML = "useHTML";
    private static final String PROPERTITY_LEGEND_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_LEGEND_WIDTH = "width";
    private static final String PROPERTITY_LEGEND_X = "x";
    private static final String PROPERTITY_LEGEND_Y = "y";
    private static final String PROPERTITY_SUBTITLE = "subtitle";
    private static final String PROPERTITY_SUBTITLE_ALIGN = "align";
    private static final String PROPERTITY_SUBTITLE_FLOATING = "floating";
    private static final String PROPERTITY_SUBTITLE_STYLE = "style";
    private static final String PROPERTITY_SUBTITLE_TEXT = "text";
    private static final String PROPERTITY_SUBTITLE_USEHTML = "useHTML";
    private static final String PROPERTITY_SUBTITLE_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_SUBTITLE_X = "x";
    private static final String PROPERTITY_SUBTITLE_Y = "y";
    private static final String PROPERTITY_TITLE = "title";
    private static final String PROPERTITY_TITLE_ALIGN = "align";
    private static final String PROPERTITY_TITLE_FLOATING = "floating";
    private static final String PROPERTITY_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_TITLE_STYLE = "style";
    private static final String PROPERTITY_TITLE_TEXT = "text";
    private static final String PROPERTITY_TITLE_USEHTML = "useHTML";
    private static final String PROPERTITY_TITLE_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_TITLE_X = "x";
    private static final String PROPERTITY_TITLE_Y = "y";
    private static final String PROPERTITY_TOOLTIP = "tooltip";
    private static final String PROPERTITY_TOOLTIP_ANIMATION = "animation";
    private static final String PROPERTITY_TOOLTIP_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_TOOLTIP_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_TOOLTIP_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_TOOLTIP_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_TOOLTIP_CROSSHAIRS = "crosshairs";
    private static final String PROPERTITY_TOOLTIP_CROSSHAIRS_WIDTH = "width";
    private static final String PROPERTITY_TOOLTIP_CROSSHAIRS_COLOR = "color";
    private static final String PROPERTITY_TOOLTIP_CROSSHAIRS_DASHSTYLE = "dashStyle";
    private static final String PROPERTITY_TOOLTIP_ENABLED = "enabled";
    private static final String PROPERTITY_TOOLTIP_FOLLOWPOINTER = "followPointer";
    private static final String PROPERTITY_TOOLTIP_FOLLOWTOUCHMOVE = "followTouchMove";
    private static final String PROPERTITY_TOOLTIP_FOOTERFORMAT = "footerFormat";
    private static final String PROPERTITY_TOOLTIP_FORMATTER = "formatter";
    private static final String PROPERTITY_TOOLTIP_HEADERFORMAT = "headerFormat";
    private static final String PROPERTITY_TOOLTIP_HIDEDELAY = "hideDelay";
    private static final String PROPERTITY_TOOLTIP_POINTFORMAT = "pointFormat";
    private static final String PROPERTITY_TOOLTIP_POSITIONER = "positioner";
    private static final String PROPERTITY_TOOLTIP_SHADOW = "shadow";
    private static final String PROPERTITY_TOOLTIP_SHARED = "shared";
    private static final String PROPERTITY_TOOLTIP_SNAP = "snap";
    private static final String PROPERTITY_TOOLTIP_STYLE = "style";
    private static final String PROPERTITY_TOOLTIP_USEHTML = "useHTML";
    private static final String PROPERTITY_TOOLTIP_VALUEDECIMALS = "valueDecimals";
    private static final String PROPERTITY_TOOLTIP_VALUEPREFIX = "valuePrefix";
    private static final String PROPERTITY_TOOLTIP_VALUESUFFIX = "valueSuffix";
    private static final String PROPERTITY_TOOLTIP_XDATEFORMAT = "xDateFormat";
    private static final String PROPERTITY_EXPORTING = "exporting";
    private static final String PROPERTITY_EXPORTING_BUTTONS = "buttons";
    private static final String PROPERTITY_EXPORTING_BUTTONS_CONTEXTBUTTON = "contextButton";
    private static final String PROPERTITY_EXPORTING_CHARTOPTIONS = "chartOptions";
    private static final String PROPERTITY_EXPORTING_ENABLED = "enabled";
    private static final String PROPERTITY_EXPORTING_FILENAME = "filename";
    private static final String PROPERTITY_EXPORTING_SCALE = "scale";
    private static final String PROPERTITY_EXPORTING_SOURCEHEIGHT = "sourceHeight";
    private static final String PROPERTITY_EXPORTING_SOURCEWIDTH = "sourceWidth";
    private static final String PROPERTITY_EXPORTING_TYPE = "type";
    private static final String PROPERTITY_EXPORTING_URL = "url";
    private static final String PROPERTITY_EXPORTING_WIDTH = "width";
    private static final String PROPERTITY_NAVIGATION = "navigation";
    private static final String PROPERTITY_BUTTON_OPTIONS = "buttonOptions";
    private static final String PROPERTITY_BUTTON_OPTIONS_ALIGN = "align";
    private static final String PROPERTITY_BUTTON_OPTIONS_ENABLED = "enabled";
    private static final String PROPERTITY_BUTTON_OPTIONS_HEIGHT = "height";
    private static final String PROPERTITY_BUTTON_OPTIONS_MENUITEMS = "menuItems";
    private static final String PROPERTITY_BUTTON_OPTIONS_ONCLICK = "onclick";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOL = "symbol";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOLFILL = "symbolFill";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOLSIZE = "symbolSize";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOLSTROKE = "symbolStroke";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOLSTROKEWIDTH = "symbolStrokeWidth";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOLX = "symbolX";
    private static final String PROPERTITY_BUTTON_OPTIONS_SYMBOLY = "symbolY";
    private static final String PROPERTITY_BUTTON_OPTIONS_TEXT = "text";
    private static final String PROPERTITY_BUTTON_OPTIONS_THEME = "theme";
    private static final String PROPERTITY_BUTTON_OPTIONS_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_BUTTON_OPTIONS_WIDTH = "width";
    private static final String PROPERTITY_BUTTON_OPTIONS_X = "x";
    private static final String PROPERTITY_BUTTON_OPTIONS_Y = "y";
    private static final String PROPERTITY_NAVIGATION_MENUITEMHOVERSTYLE = "menuItemHoverStyle";
    private static final String PROPERTITY_NAVIGATION_MENUITEMSTYLE = "menuItemStyle";
    private static final String PROPERTITY_NAVIGATION_MENUSTYLE = "menuStyle";
    private static final String PROPERTITY_AXIS_X = "xAxis";
    private static final String PROPERTITY_AXIS_Y = "yAxis";
    private static final String PROPERTITY_AXIS_Z = "zAxis";
    private static final String PROPERTITY_AXIS_ALLOWDECIMALS = "allowDecimals";
    private static final String PROPERTITY_AXIS_ALTERNATEGRIDCOLOR = "alternateGridColor";
    private static final String PROPERTITY_AXIS_CATEGORIES = "categories";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS = "dateTimeLabelFormats";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_MILLISECOND = "millisecond";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_SECOND = "second";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_MINUTE = "minute";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_HOUR = "hour";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_DAY = "day";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_WEEK = "week";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_MONTH = "month";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_YEAR = "year";
    private static final String PROPERTITY_AXIS_ENDONTICK = "endOnTick";
    private static final String PROPERTITY_AXIS_GRIDLINECOLOR = "gridLineColor";
    private static final String PROPERTITY_AXIS_GRIDLINEDASHSTYLE = "gridLineDashStyle";
    private static final String PROPERTITY_AXIS_GRIDLINEINTERPOLATION = "gridLineInterpolation";
    private static final String PROPERTITY_AXIS_GRIDLINEWIDTH = "gridLineWidth";
    private static final String PROPERTITY_AXIS_ID = "id";
    private static final String PROPERTITY_AXIS_LINECOLOR = "lineColor";
    private static final String PROPERTITY_AXIS_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_AXIS_LINKEDTO = "linkedTo";
    private static final String PROPERTITY_AXIS_MAX = "max";
    private static final String PROPERTITY_AXIS_MAXPADDING = "maxPadding";
    private static final String PROPERTITY_AXIS_MIN = "min";
    private static final String PROPERTITY_AXIS_MINTICKINTERVAL = "minTickInterval";
    private static final String PROPERTITY_AXIS_MINORGRIDLINECOLOR = "minorGridLineColor";
    private static final String PROPERTITY_AXIS_MINORGRIDLINEDASHSTYLE = "minorGridLineDashStyle";
    private static final String PROPERTITY_AXIS_MINORGRIDLINEWIDTH = "minorGridLineWidth";
    private static final String PROPERTITY_AXIS_MINORTICKCOLOR = "minorTickColor";
    private static final String PROPERTITY_AXIS_MINORTICKINTERVAL = "minorTickInterval";
    private static final String PROPERTITY_AXIS_MINORTICKLENGTH = "minorTickLength";
    private static final String PROPERTITY_AXIS_MINORTICKPOSITION = "minorTickPosition";
    private static final String PROPERTITY_AXIS_MINORTICKWIDTH = "minorTickWidth";
    private static final String PROPERTITY_AXIS_MINPADDING = "minPadding";
    private static final String PROPERTITY_AXIS_MINRANGE = "minRange";
    private static final String PROPERTITY_AXIS_OFFSET = "offset";
    private static final String PROPERTITY_AXIS_OPPOSITE = "opposite";
    private static final String PROPERTITY_AXIS_PLOTBANDS = "plotBands";
    private static final String PROPERTITY_AXIS_PLOTBANDS_COLOR = "color";
    private static final String PROPERTITY_AXIS_PLOTBANDS_FROM = "from";
    private static final String PROPERTITY_AXIS_PLOTBANDS_ID = "id";
    private static final String PROPERTITY_AXIS_PLOTBANDS_INNERRADIUS = "innerRadius";
    private static final String PROPERTITY_AXIS_PLOTBANDS_OUTERRADIUS = "outerRadius";
    private static final String PROPERTITY_AXIS_PLOTBANDS_THICKNESS = "thickness";
    private static final String PROPERTITY_AXIS_PLOTBANDS_TO = "to";
    private static final String PROPERTITY_AXIS_PLOTBANDS_ZINDEX = "zIndex";
    private static final String PROPERTITY_AXIS_PLOT_LABEL = "plotLabel";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_ALIGN = "align";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_TEXT = "text";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_RATATION = "rotation";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_STYLE = "style";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_TEXTALIGN = "textAlign";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_X = "x";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_Y = "y";
    private static final String PROPERTITY_AXIS_PLOTLINES = "plotLines";
    private static final String PROPERTITY_AXIS_PLOTLINES_COLOR = "color";
    private static final String PROPERTITY_AXIS_PLOTLINES_ID = "id";
    private static final String PROPERTITY_AXIS_PLOTLINES_VALUE = "value";
    private static final String PROPERTITY_AXIS_PLOTLINES_WIDTH = "width";
    private static final String PROPERTITY_AXIS_PLOTLINES_ZINDEX = "zIndex";
    private static final String PROPERTITY_AXIS_REVERSED = "reversed";
    private static final String PROPERTITY_AXIS_SHOWEMPTY = "showEmpty";
    private static final String PROPERTITY_AXIS_SHOWFIRSTLABEL = "showFirstLabel";
    private static final String PROPERTITY_AXIS_SHOWLASTLABEL = "showLastLabel";
    private static final String PROPERTITY_AXIS_STACKLABELS = "stackLabels";
    private static final String PROPERTITY_AXIS_STACKLABELS_ALIGN = "align";
    private static final String PROPERTITY_AXIS_STACKLABELS_TEXTALIGN = "textAlign";
    private static final String PROPERTITY_AXIS_STACKLABELS_VERTICALALIGH = "verticalAlign";
    private static final String PROPERTITY_AXIS_STACKLABELS_ENABLED = "enabled";
    private static final String PROPERTITY_AXIS_STACKLABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_AXIS_STACKLABELS_STYLE = "style";
    private static final String PROPERTITY_AXIS_STACKLABELS_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_STACKLABELS_X = "x";
    private static final String PROPERTITY_AXIS_STACKLABELS_Y = "y";
    private static final String PROPERTITY_AXIS_STARTOFWEEK = "startOfWeek";
    private static final String PROPERTITY_AXIS_STARTONTICK = "startOnTick";
    private static final String PROPERTITY_AXIS_TICKCOLOR = "tickColor";
    private static final String PROPERTITY_AXIS_TICKINTERVAL = "tickInterval";
    private static final String PROPERTITY_AXIS_TICKLENGTH = "tickLength";
    private static final String PROPERTITY_AXIS_TICKMARKPLACEMENT = "tickmarkPlacement";
    private static final String PROPERTITY_AXIS_TICKPIXELINTERVAL = "tickPixelInterval";
    private static final String PROPERTITY_AXIS_TICKPOSITION = "tickPosition";
    private static final String PROPERTITY_AXIS_TICKPOSITIER = "tickPositier";
    private static final String PROPERTITY_AXIS_TICKPOSITIONS = "tickPositions";
    private static final String PROPERTITY_AXIS_TICKWIDTH = "tickWidth";
    private static final String PROPERTITY_AXIS_TITLE = "title";
    private static final String PROPERTITY_AXIS_TITLE_ALIGN = "align";
    private static final String PROPERTITY_AXIS_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_AXIS_TITLE_OFFSET = "offset";
    private static final String PROPERTITY_AXIS_TITLE_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_TITLE_STYLE = "style";
    private static final String PROPERTITY_AXIS_TITLE_TEXT = "text";
    private static final String PROPERTITY_AXIS_TITLE_X = "x";
    private static final String PROPERTITY_AXIS_TITLE_Y = "y";
    private static final String PROPERTITY_AXIS_TYPE = "type";
    private static final String PROPERTITY_AXIS_LABELS = "labels";
    private static final String PROPERTITY_AXIS_LABELS_ALIGN = "align";
    private static final String PROPERTITY_AXIS_LABELS_DISTANCE = "distance";
    private static final String PROPERTITY_AXIS_LABELS_ENABLED = "enabled";
    private static final String PROPERTITY_AXIS_LABELS_FORMAT = "format";
    private static final String PROPERTITY_AXIS_LABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_AXIS_LABELS_MAXSTAGGERLINES = "maxStaggerLines";
    private static final String PROPERTITY_AXIS_LABELS_OVERFLOW = "overflow";
    private static final String PROPERTITY_AXIS_LABELS_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_LABELS_STAGGERLINES = "staggerLines";
    private static final String PROPERTITY_AXIS_LABELS_STEP = "step";
    private static final String PROPERTITY_AXIS_LABELS_STYLE = "style";
    private static final String PROPERTITY_AXIS_LABELS_USEHTML = "useHTML";
    private static final String PROPERTITY_AXIS_LABELS_X = "x";
    private static final String PROPERTITY_AXIS_LABELS_Y = "y";
    private static final String PROPERTITY_AXIS_NAME = "name";
    private static final String PROPERTITY_AXIS_BINDTARGET = "bindtarget";
    private static final String PROPERTITY_AXIS_DATEFORMAT = "dateFormat";
    private static final String PROPERTITY_AXIS_STARTANGLE = "startAngle";
    private static final String PROPERTITY_AXIS_ENDANGLE = "endAngle";
    private static final String PROPERTITY_PANE = "pane";
    private static final String PROPERTITY_PANE_BACKGROUNDS = "backgrounds";
    private static final String PROPERTITY_PANE_BACKGROUND = "background";
    private static final String PROPERTITY_PANE_BACKGROUND_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_PANE_BACKGROUND_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PANE_BACKGROUND_OUTERRADIUS = "outerRadius";
    private static final String PROPERTITY_PANE_BACKGROUND_INNERRADIUS = "innerRadius";
    private static final String PROPERTITY_PANE_CENTER = "center";
    private static final String PROPERTITY_PANE_ENDANGLE = "endAngle";
    private static final String PROPERTITY_PANE_STARTANGLE = "startAngle";
    private static final String PROPERTITY_PANE_SIZE = "size";
    private static final String PROPERTITY_PLOTOPTIONS = "plotOptions";
    private static final String PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT = "allowPointSelect";
    private static final String PROPERTITY_PLOTOPTIONS_ANIMATION = "animation";
    private static final String PROPERTITY_PLOTOPTIONS_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_PLOTOPTIONS_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_CENTER = "center";
    private static final String PROPERTITY_PLOTOPTIONS_COLOR = "color";
    private static final String PROPERTITY_PLOTOPTIONS_COLORBYPOINT = "colorByPoint";
    private static final String PROPERTITY_PLOTOPTIONS_COLORS = "colors";
    private static final String PROPERTITY_PLOTOPTIONS_CONNECTENDS = "connectEnds";
    private static final String PROPERTITY_PLOTOPTIONS_CONNECTNULLS = "connectNulls";
    private static final String PROPERTITY_PLOTOPTIONS_CROPTHRESHOLD = "cropThreshold";
    private static final String PROPERTITY_PLOTOPTIONS_CURSOR = "cursor";
    private static final String PROPERTITY_PLOTOPTIONS_DASHSTYLE = "dashStyle";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS = "dataLabels";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ALIGN = "align";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_BACKGROUND_COLOR = "backgroundColor";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_BORDER_COLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_BORDER_RADIUS = "borderRadius";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_BORDER_WIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_COLOR = "color";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_CONNECTORCOLOR = "connectorColor";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_CONNECTORPADDING = "connectorPadding";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_CONNECTORWIDTH = "connectorWidth";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_CROP = "crop";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_DISTANCE = "distance";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_FORMAT = "format";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_INSIDE = "inside";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_PADDING = "padding";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ROTATION = "rotation";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_SHADOW = "shadow";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_SOFTCONNECTOR = "softConnector";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_STYLE = "style";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_USEHTML = "useHTML";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_X = "x";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_Y = "y";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ZINDEX = "zIndex";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL = "dial";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_BASELENGTH = "baseLength";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_BASEWIDTH = "baseWidth";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_REARLENGTH = "rearLength";
    private static final String PROPERTITY_PLOTOPTIONS_DIAL_TOPWIDTH = "topWidth";
    private static final String PROPERTITY_PLOTOPTIONS_DISPLAYNEGATIVE = "displayNegative";
    private static final String PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING = "enableMouseTracking";
    private static final String PROPERTITY_PLOTOPTIONS_ENDANGLE = "endAngle";
    private static final String PROPERTITY_PLOTOPTIONS_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_FILLOPACITY = "fillOpacity";
    private static final String PROPERTITY_PLOTOPTIONS_GROUPPADDING = "groupPadding";
    private static final String PROPERTITY_PLOTOPTIONS_GROUPING = "grouping";
    private static final String PROPERTITY_PLOTOPTIONS_HEIGHT = "height";
    private static final String PROPERTITY_PLOTOPTIONS_ID = "id";
    private static final String PROPERTITY_PLOTOPTIONS_IGNOREHIDDENPOINT = "ignoreHiddenPoint";
    private static final String PROPERTITY_PLOTOPTIONS_INNERSIZE = "innerSize";
    private static final String PROPERTITY_PLOTOPTIONS_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_LINKEDTO = "linkedTo";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER = "marker";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_SYMBOL = "symbol";
    private static final String PROPERTITY_PLOTOPTIONS_MAXSIZE = "maxSize";
    private static final String PROPERTITY_PLOTOPTIONS_MEDIANCOLOR = "medianColor";
    private static final String PROPERTITY_PLOTOPTIONS_MEDIANWIDTH = "medianWidth";
    private static final String PROPERTITY_PLOTOPTIONS_MINPOINTLENGTH = "minPointLength";
    private static final String PROPERTITY_PLOTOPTIONS_MINSIZE = "minSize";
    private static final String PROPERTITY_PLOTOPTIONS_NECKHEIGHT = "neckHeight";
    private static final String PROPERTITY_PLOTOPTIONS_NECKWIDTH = "neckWidth";
    private static final String PROPERTITY_PLOTOPTIONS_NEGATIVECOLOR = "negativeColor";
    private static final String PROPERTITY_PLOTOPTIONS_NEGATIVEFILLCOLOR = "negativeFillColor";
    private static final String PROPERTITY_PLOTOPTIONS_PIVOT = "pivot";
    private static final String PROPERTITY_PLOTOPTIONS_PIVOT_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_PLOTOPTIONS_PIVOT_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_PIVOT_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_PIVOT_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_POINT = "point";
    private static final String PROPERTITY_PLOTOPTIONS_POINTINTERVAL = "pointInterval";
    private static final String PROPERTITY_PLOTOPTIONS_POINTPADDING = "pointPadding";
    private static final String PROPERTITY_PLOTOPTIONS_POINTPLACEMENT = "pointPlacement";
    private static final String PROPERTITY_PLOTOPTIONS_POINTRANGE = "pointRange";
    private static final String PROPERTITY_PLOTOPTIONS_POINTSTART = "pointStart";
    private static final String PROPERTITY_PLOTOPTIONS_POINTWIDTH = "pointWidth";
    private static final String PROPERTITY_PLOTOPTIONS_SELECTED = "selected";
    private static final String PROPERTITY_PLOTOPTIONS_SHADOW = "shadow";
    private static final String PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX = "showCheckbox";
    private static final String PROPERTITY_PLOTOPTIONS_SHOWINLEGEND = "showInLegend";
    private static final String PROPERTITY_PLOTOPTIONS_SIZE = "size";
    private static final String PROPERTITY_PLOTOPTIONS_SLICEDOFFSET = "slicedOffset";
    private static final String PROPERTITY_PLOTOPTIONS_STACKING = "stacking";
    private static final String PROPERTITY_PLOTOPTIONS_STARTANGLE = "startAngle";
    private static final String PROPERTITY_PLOTOPTIONS_STEMCOLOR = "stemColor";
    private static final String PROPERTITY_PLOTOPTIONS_STEMDASHSTYLE = "stemDashStyle";
    private static final String PROPERTITY_PLOTOPTIONS_STEMWIDTH = "stemWidth";
    private static final String PROPERTITY_PLOTOPTIONS_STATES = "states";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_HOVER = "hover";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_SELECT = "select";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_HOVER_BRIGHTNESS = "brightness";
    private static final String PROPERTITY_PLOTOPTIONS_STEP = "step";
    private static final String PROPERTITY_PLOTOPTIONS_STICKYTRACKING = "stickyTracking";
    private static final String PROPERTITY_PLOTOPTIONS_THRESHOLD = "threshold";
    private static final String PROPERTITY_PLOTOPTIONS_TOOLTIP = "plotTooltip";
    private static final String PROPERTITY_PLOTOPTIONS_TRACKBYAREA = "trackByArea";
    private static final String PROPERTITY_PLOTOPTIONS_TURBOTHRESHOLD = "turboThreshold";
    private static final String PROPERTITY_PLOTOPTIONS_VISIBLE = "visible";
    private static final String PROPERTITY_PLOTOPTIONS_WHISKERCOLOR = "whiskerColor";
    private static final String PROPERTITY_PLOTOPTIONS_WHISKERLENGTH = "whiskerLength";
    private static final String PROPERTITY_PLOTOPTIONS_WHISKERWIDTH = "whiskerWidth";
    private static final String PROPERTITY_PLOTOPTIONS_WIDTH = "width";
    private static final String PROPERTITY_PLOTOPTIONS_WRAP = "wrap";
    private static final String PROPERTITY_PLOTOPTIONS_ZINDEX = "zIndex";
    private static final String PROPERTITY_PLOTOPTIONS_ZTHRESHOLD = "zThreshold";
    private static final String PROPERTITY_SERIESLIST = "seriesList";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM = "seriesItem";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATAS = "seriesDatas";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA = "seriesData";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_COLOR = "color";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_DRILLDOWN = "drilldown";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_LEGENDINDEX = "legendIndex";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_NAME = "name";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_SLICED = "sliced";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_SELECTED = "selected";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_X = "x";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_Y = "y";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_SERIESDATA_DATAINDEX = "dataIndex";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_INDEX = "index";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_LEGENDINDEX = "legendIndex";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_NAME = "name";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_NEGATIVE = "negative";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_STACK = "stack";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_TYPE = "type";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_XAXIS = "xAxis";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_YAXIS = "yAxis";
    private static final String PROPERTITY_SERIESLIST_SERIESITEM_ZINDEX = "zIndex";
    private static final String PROPERTITY_COLORS = "colors";
    private CompositeMap model;
    private static String[] CHART_MORE_TYPE = new String[]{"gauge", "arearange", "columnrange", "areasplinerange", "boxplot", "errorbar", "waterfall", "bubble", "funnel", "pyramid"};

    public Chart(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        String theme = view.getString(PROPERTITY_THEME.toLowerCase());
        if (theme == null) {
            theme = "grid";
        }
        this.addJavaScript(session, context, "chart/Animate-min.js");
        this.addJavaScript(session, context, "chart/Chart-min.js");
        if (this.needMore(view, model)) {
            this.addJavaScript(session, context, "chart/Chart-more-min.js");
        }
        if (!"default".equals(theme)) {
            this.addJavaScript(session, context, "chart/themes/" + theme + ".js");
        }
        this.addJavaScript(session, context, "chart/Exporting-min.js");
    }

    private boolean containsMore(String type) {
        int i = 0;
        while (i < CHART_MORE_TYPE.length) {
            if (CHART_MORE_TYPE[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean needMore(CompositeMap view, CompositeMap model) {
        Iterator childs;
        if (view != null && (childs = view.getChildIterator()) != null) {
            while (childs.hasNext()) {
                CompositeMap child = (CompositeMap)childs.next();
                if ("chart".equals(child.getName()) || PROPERTITY_SERIESLIST_SERIESITEM.equals(child.getName()) || "field".equals(child.getName())) {
                    if (child.getBoolean(PROPERTITY_CHART_POLAR, false) || this.containsMore(TextParser.parse(child.getString("type"), model))) {
                        return true;
                    }
                    if (!"chart".equals(child.getName()) || !this.needMore(child.getChild(PROPERTITY_SERIESLIST), model)) continue;
                    return true;
                }
                if ("dataSet".equals(child.getName()) && this.needMore(child.getChild("fields"), model)) {
                    return true;
                }
                if (!this.needMore(child, model)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addEvent(String id, String eventName, String handler) {
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        String value;
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        this.model = context.getModel();
        String bindTarget = view.getString(PROPERTITY_AXIS_BINDTARGET);
        if (bindTarget != null && !"".equals(bindTarget)) {
            bindTarget = TextParser.parse(bindTarget, this.model);
            map.put("binding", new String("$('" + this.id + "').bind('" + bindTarget + "');\n"));
        }
        if ((value = view.getString(PROPERTITY_SERIES_NAME.toLowerCase())) == null) {
            value = "name";
        }
        this.addConfig(PROPERTITY_SERIES_NAME, value);
        map.put("contextPath", this.model.getObject("/request/@context_path").toString());
        this.processChartConfig(context, bindTarget);
        JSONObject config = this.getConfig();
        config.remove("height");
        config.remove("width");
        config.remove("listeners");
        map.put("config", this.getConfigString());
    }

    private void putStringCfg(CompositeMap view, String key, Map map) {
        String value = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (value != null) {
            if ("null".equals(value)) {
                map.put(key, null);
            } else if (value.matches("Aurora\\..*|\\$A\\..*|window[\\.\\[].*")) {
                map.put(key, new JSONFunction(value));
            } else {
                map.put(key, value);
            }
        }
    }

    private void putNumberCfg(CompositeMap view, String key, Map map) {
        String valuestr = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (valuestr != null) {
            if ("auto".equals(valuestr) || valuestr.indexOf("%") != -1) {
                map.put(key, valuestr);
                return;
            }
            try {
                if (valuestr.indexOf(".") != -1) {
                    Double value = view.getDouble(key.toLowerCase());
                    if (value != null) {
                        map.put(key, value);
                    }
                } else {
                    Long value = view.getLong(key.toLowerCase());
                    if (value != null) {
                        map.put(key, value);
                    }
                }
            }
            catch (NumberFormatException e) {
                map.put(key, new JSONFunction(valuestr));
            }
        }
    }

    private void putBooleanCfg(CompositeMap view, String key, Map map) {
        String valuestr = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (valuestr != null) {
            map.put(key, Boolean.valueOf(valuestr));
        }
    }

    private void putFunctionCfg(CompositeMap view, String key, Map map) {
        String value = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (value != null) {
            map.put(key, new JSONFunction(value));
        }
    }

    private void putGradientCfg(CompositeMap view, String key, Map map) {
        String value = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (value != null) {
            String[] values = value.split(",");
            if ("linearGradient".equals(key)) {
                map.put(key, new JSONFunction("{x1:" + values[0] + ",y1:" + values[1] + ",x2:" + values[2] + ",y2:" + values[3] + "}"));
            } else if ("radialGradient".equals(key)) {
                map.put(key, new JSONFunction("{cx:" + values[0] + ",cy:" + values[1] + ",r:" + values[2] + "}"));
            }
        }
    }

    private void putArrayCfg(CompositeMap view, String key, Map map) {
        String value = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (value != null) {
            map.put(key, new JSONFunction("[" + value + "]"));
        }
    }

    private void putStyleCfg(CompositeMap view, String key, Map map) {
        String value = TextParser.parse(view.getString(key.toLowerCase()), this.model);
        if (value != null) {
            JSONObject smap = new JSONObject();
            String[] sts = value.split(";");
            int i = 0;
            while (i < sts.length) {
                String style = sts[i];
                if (!"".equals(style) && style.indexOf(":") != -1) {
                    String[] vs = style.trim().split(":");
                    String k = vs[0];
                    String v = vs[1];
                    v = v.replaceAll("'", "");
                    String[] ks = k.split("-");
                    k = "";
                    int j = 0;
                    while (j < ks.length) {
                        ks[j] = ks[j].toLowerCase();
                        if (j > 0) {
                            String e = ks[j];
                            ks[j] = (char)(e.charAt(0) - 32) + e.substring(1);
                        }
                        k = String.valueOf(k) + ks[j];
                        ++j;
                    }
                    Long lv = null;
                    Double dv = null;
                    try {
                        dv = Double.valueOf(v);
                        lv = Long.valueOf(v);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (lv != null) {
                            smap.put(k, lv);
                        } else if (dv != null) {
                            smap.put(k, dv);
                        } else {
                            smap.put(k, v);
                        }
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
            map.put("style", smap);
        }
    }

    private void putGradientColorCfg(CompositeMap parent, String key, Map map) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(key);
        if (view != null) {
            this.putGradientCfg(view, "linearGradient", cfg);
            this.putGradientCfg(view, "radialGradient", cfg);
            this.putArrayCfg(view, "stops", cfg);
            if (!cfg.isEmpty()) {
                map.put(key, new JSONObject(cfg));
            }
        } else {
            this.putStringCfg(parent, key, map);
        }
    }

    private void putColorCfg(CompositeMap parent, String key, Map map) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(key);
        if (view != null) {
            this.putArrayCfg(view, "linearGradient", cfg);
            this.putGradientCfg(view, "radialGradient", cfg);
            this.putArrayCfg(view, "stops", cfg);
            if (!cfg.isEmpty()) {
                map.put(key, new JSONObject(cfg));
            }
        } else {
            this.putStringCfg(parent, key, map);
        }
    }

    private void putEvents(CompositeMap view, Map map) {
        List list;
        CompositeMap events = view.getChild("events");
        if (events != null && (list = events.getChilds()) != null) {
            JSONObject eo = new JSONObject();
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if ("".equals(eventName) || "".equals(handler)) continue;
                try {
                    eo.put(eventName, new JSONFunction(handler));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            map.put("events", eo);
        }
    }

    private void processChartConfig(ViewContext context, String bindTarget) {
        CompositeMap view = context.getView();
        HashMap<String, String> chart = new HashMap<String, String>();
        Map map = context.getMap();
        chart.put(PROPERTITY_CHART_RENDERTO, String.valueOf((String)map.get("id")) + "_c");
        this.createChartOption(view, chart);
        this.addConfig("chart", new JSONObject(chart));
        this.processColors(view);
        this.processCredits(view);
        this.processExporting(view);
        this.processLabels(view);
        this.processLegend(view);
        this.processLoading(view);
        this.processNavigation(view);
        this.processPane(view);
        this.processPlotOptions(view);
        this.processSeries(view, bindTarget);
        this.processSubTitle(view);
        this.processTitle(view);
        this.processTooltip(view);
        this.processXAxis(view);
        this.processYAxis(view);
        this.processZAxis(view);
    }

    private void createChartOption(CompositeMap parent, Map cfg) {
        this.putStringCfg(parent, "type", cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_POLAR, cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_ALIGNTICKS, cfg);
        this.putBooleanCfg(parent, "animation", cfg);
        this.putColorCfg(parent, "backgroundColor", cfg);
        this.putNumberCfg(parent, "borderRadius", cfg);
        this.putStringCfg(parent, "borderColor", cfg);
        this.putNumberCfg(parent, "borderWidth", cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_CLASSNAME, cfg);
        this.putNumberCfg(parent, "height", cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_DEFAULTSERIESTYPE, cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_IGNORE_HIDDEN_SERIES, cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_INVERTED, cfg);
        this.putArrayCfg(parent, "margin", cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_MARGIN_TOP, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_MARGIN_RIGHT, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_MARGIN_LEFT, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_MARGIN_BOTTOM, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_PINCH_TYPE, cfg);
        this.putColorCfg(parent, PROPERTITY_CHART_PLOT_BACKGROUND_COLOR, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_PLOT_BACKGROUND_IMAGE, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_PLOT_BORDER_COLOR, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_PLOT_BORDER_WIDTH, cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_PLOT_SHADOW, cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_REFLOW, cfg);
        this.processResetZoomButton(parent, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_SELECTIONMARKERFILL, cfg);
        this.putBooleanCfg(parent, "shadow", cfg);
        this.putBooleanCfg(parent, PROPERTITY_CHART_SHOW_AXES, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_SPACING_TOP, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_SPACING_RIGHT, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_SPACING_BOTTOM, cfg);
        this.putNumberCfg(parent, PROPERTITY_CHART_SPACING_LEFT, cfg);
        this.putStyleCfg(parent, PROPERTITY_CHART_STYLE, cfg);
        this.putNumberCfg(parent, "width", cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_ZOOMTYPE, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_NAME_FIELD, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_VALUE_FIELD, cfg);
        this.putStringCfg(parent, PROPERTITY_CHART_GROUPBY, cfg);
        this.putEvents(parent, cfg);
    }

    private void processColors(CompositeMap parent) {
        HashMap cfg = new HashMap();
        this.putArrayCfg(parent, "colors", cfg);
        if (!cfg.isEmpty()) {
            this.addConfig("colors", cfg.get("colors"));
        }
    }

    private void processResetZoomButton(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild(PROPERTITY_CHART_RESETZOOMBUTTON);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.createPosition(view, cfg);
            this.putStringCfg(view, PROPERTITY_CHART_RESETZOOMBUTTON_RELATIVETO, cfg);
            this.putStringCfg(view, "theme", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_CHART_RESETZOOMBUTTON, new JSONObject(cfg));
        }
    }

    private void processCredits(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_CREDITS);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putBooleanCfg(view, "enabled", cfg);
            this.createPosition(view, cfg);
            this.putStringCfg(view, PROPERTITY_CREDITS_HREF, cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "text", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_CREDITS, new JSONObject(cfg));
            }
        }
    }

    private void createPosition(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_POSITION);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, "align", cfg);
            this.putNumberCfg(view, "x", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putNumberCfg(view, "y", cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_POSITION, new JSONObject(cfg));
            }
        }
    }

    private void processExporting(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_EXPORTING);
        if (view != null) {
            HashMap<String, JSONObject> cfg = new HashMap<String, JSONObject>();
            this.createExportingButtons(view, cfg);
            CompositeMap chartOptions = view.getChild(PROPERTITY_EXPORTING_CHARTOPTIONS);
            if (chartOptions != null) {
                HashMap cfg2 = new HashMap();
                this.createChartOption(chartOptions, cfg2);
                if (!cfg.isEmpty()) {
                    cfg.put(PROPERTITY_EXPORTING_CHARTOPTIONS, new JSONObject(cfg2));
                }
            }
            this.putBooleanCfg(view, "enabled", cfg);
            this.putStringCfg(view, PROPERTITY_EXPORTING_FILENAME, cfg);
            this.putNumberCfg(view, PROPERTITY_EXPORTING_SCALE, cfg);
            this.putNumberCfg(view, PROPERTITY_EXPORTING_SOURCEHEIGHT, cfg);
            this.putNumberCfg(view, PROPERTITY_EXPORTING_SOURCEWIDTH, cfg);
            this.putStringCfg(view, "type", cfg);
            this.putStringCfg(view, PROPERTITY_EXPORTING_URL, cfg);
            this.putNumberCfg(view, "width", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_EXPORTING, new JSONObject(cfg));
            }
        }
    }

    private void createExportingButtons(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild(PROPERTITY_EXPORTING_BUTTONS);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.createButtonOptions(view, cfg, PROPERTITY_EXPORTING_BUTTONS_CONTEXTBUTTON);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_EXPORTING_BUTTONS, new JSONObject(cfg));
            }
        }
    }

    private void createButtonOptions(CompositeMap cview, Map map, String name) {
        CompositeMap view = cview.getChild(name);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, "align", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putNumberCfg(view, "height", cfg);
            this.putStringCfg(view, "symbol", cfg);
            this.putStringCfg(view, PROPERTITY_BUTTON_OPTIONS_SYMBOLFILL, cfg);
            this.putNumberCfg(view, PROPERTITY_BUTTON_OPTIONS_SYMBOLSIZE, cfg);
            this.putStringCfg(view, PROPERTITY_BUTTON_OPTIONS_SYMBOLSTROKE, cfg);
            this.putNumberCfg(view, PROPERTITY_BUTTON_OPTIONS_SYMBOLSTROKEWIDTH, cfg);
            this.putNumberCfg(view, PROPERTITY_BUTTON_OPTIONS_SYMBOLX, cfg);
            this.putNumberCfg(view, PROPERTITY_BUTTON_OPTIONS_SYMBOLY, cfg);
            this.putStringCfg(view, "text", cfg);
            this.putStringCfg(view, "theme", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putNumberCfg(view, "width", cfg);
            this.putNumberCfg(view, "y", cfg);
            if (PROPERTITY_EXPORTING_BUTTONS_CONTEXTBUTTON.equals(name)) {
                this.createMenuItems(view, cfg);
                this.putFunctionCfg(view, PROPERTITY_BUTTON_OPTIONS_ONCLICK, cfg);
                this.putNumberCfg(view, "x", cfg);
            }
            if (!cfg.isEmpty()) {
                map.put(name, new JSONObject(cfg));
            }
        }
    }

    private void createMenuItems(CompositeMap view, Map map) {
        List list;
        CompositeMap pbs = view.getChild(PROPERTITY_BUTTON_OPTIONS_MENUITEMS);
        if (pbs != null && (list = pbs.getChilds()) != null) {
            JSONArray array = new JSONArray();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                HashMap cfg = new HashMap();
                CompositeMap pb = (CompositeMap)it.next();
                this.putGradientColorCfg(pb, "backgroundColor", cfg);
                this.putNumberCfg(pb, "borderWidth", cfg);
                this.putStringCfg(pb, "outerRadius", cfg);
                this.putStringCfg(pb, "innerRadius", cfg);
                array.put(cfg);
            }
            if (array.length() > 0) {
                map.put(PROPERTITY_BUTTON_OPTIONS_MENUITEMS, array);
            }
        }
    }

    private void processLabels(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_LABELS);
        if (view == null) {
            view = parent.getChild(PROPERTITY_AXIS_LABELS);
        }
        if (view != null) {
            HashMap<String, JSONArray> cfg = new HashMap<String, JSONArray>();
            this.putStyleCfg(view, "style", cfg);
            List list = view.getChilds();
            if (list != null) {
                JSONArray array = new JSONArray();
                for (CompositeMap label : list) {
                    HashMap icfg = new HashMap();
                    this.putStringCfg(label, PROPERTITY_LABELS_LABEL_HTML, icfg);
                    this.putStyleCfg(label, "style", icfg);
                    array.put(icfg);
                }
                if (array.length() > 0) {
                    cfg.put(PROPERTITY_LABELS_ITEMS, array);
                }
            }
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_AXIS_LABELS, new JSONObject(cfg));
            }
        }
    }

    private void processLegend(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_LEGEND);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putNumberCfg(view, "borderRadius", cfg);
            this.putNumberCfg(view, "borderWidth", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putBooleanCfg(view, "floating", cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_ITEMDISTANCE, cfg);
            this.putStyleCfg(view, PROPERTITY_LEGEND_ITEMHIDDENSTYLE, cfg);
            this.putStyleCfg(view, PROPERTITY_LEGEND_ITEMHOVERSTYLE, cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_ITEMMARGINBOTTOM, cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_ITEMMARGINTOP, cfg);
            this.putStyleCfg(view, PROPERTITY_LEGEND_ITEMSTYLE, cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_ITEMWIDTH, cfg);
            this.putStringCfg(view, PROPERTITY_LEGEND_LABELFORMAT, cfg);
            this.putFunctionCfg(view, PROPERTITY_LEGEND_LABELFORMATTER, cfg);
            this.putStringCfg(view, PROPERTITY_LEGEND_LAYOUT, cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_LINEHEIGHT, cfg);
            this.putNumberCfg(view, "margin", cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_MAXHEIGHT, cfg);
            this.createLegendNavigation(view, cfg);
            this.putNumberCfg(view, "padding", cfg);
            this.putBooleanCfg(view, "reversed", cfg);
            this.putBooleanCfg(view, PROPERTITY_LEGEND_RTL, cfg);
            this.putBooleanCfg(view, "shadow", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_SYMBOLPADDING, cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_SYMBOLWIDTH, cfg);
            this.createLegendTitle(view, cfg);
            this.putBooleanCfg(view, "useHTML", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putNumberCfg(view, "width", cfg);
            this.putNumberCfg(view, "x", cfg);
            this.putNumberCfg(view, "y", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_LEGEND, new JSONObject(cfg));
            }
        }
    }

    private void createLegendNavigation(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild(PROPERTITY_LEGEND_NAVIGATION);
        if (view == null) {
            view = cview.getChild(PROPERTITY_NAVIGATION);
        }
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, PROPERTITY_LEGEND_NAVIGATION_ACTIVECOLOR, cfg);
            this.putBooleanCfg(view, "animation", cfg);
            this.putNumberCfg(view, PROPERTITY_LEGEND_NAVIGATION_ARROWSIZE, cfg);
            this.putStringCfg(view, PROPERTITY_LEGEND_NAVIGATION_INACTIVECOLOR, cfg);
            this.putStyleCfg(view, "style", cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_NAVIGATION, new JSONObject(cfg));
            }
        }
    }

    private void createLegendTitle(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild(PROPERTITY_LEGEND_TITLE);
        if (view == null) {
            view = cview.getChild("title");
        }
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "text", cfg);
            if (!cfg.isEmpty()) {
                map.put("title", new JSONObject(cfg));
            }
        }
    }

    private void processLoading(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_LOADING);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putNumberCfg(view, PROPERTITY_LOADING_HIDEDURATION, cfg);
            this.putStyleCfg(view, PROPERTITY_LOADING_LABELSTYLE, cfg);
            this.putNumberCfg(view, PROPERTITY_LOADING_SHOWDURATION, cfg);
            this.putStyleCfg(view, "style", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_LOADING, new JSONObject(cfg));
            }
        }
    }

    private void processNavigation(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_NAVIGATION);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.createButtonOptions(view, cfg, PROPERTITY_BUTTON_OPTIONS);
            this.putStyleCfg(view, PROPERTITY_NAVIGATION_MENUITEMHOVERSTYLE, cfg);
            this.putStyleCfg(view, PROPERTITY_NAVIGATION_MENUITEMSTYLE, cfg);
            this.putStyleCfg(view, PROPERTITY_NAVIGATION_MENUSTYLE, cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_NAVIGATION, new JSONObject(cfg));
            }
        }
    }

    private void processPane(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_PANE);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.createBackgrounds(view, cfg);
            this.putArrayCfg(view, "center", cfg);
            this.putNumberCfg(view, "endAngle", cfg);
            this.putNumberCfg(view, "startAngle", cfg);
            this.putNumberCfg(view, "size", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_PANE, new JSONObject(cfg));
            }
        }
    }

    private void createBackgrounds(CompositeMap view, Map map) {
        List list;
        CompositeMap pbs = view.getChild(PROPERTITY_PANE_BACKGROUNDS);
        if (pbs != null && (list = pbs.getChilds()) != null) {
            JSONArray array = new JSONArray();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                HashMap cfg = new HashMap();
                CompositeMap pb = (CompositeMap)it.next();
                if (!PROPERTITY_PANE_BACKGROUND.equals(pb.getName())) continue;
                this.putGradientColorCfg(pb, "backgroundColor", cfg);
                this.putNumberCfg(pb, "borderWidth", cfg);
                this.putStringCfg(pb, "outerRadius", cfg);
                this.putStringCfg(pb, "innerRadius", cfg);
                array.put(cfg);
            }
            if (array.length() > 0) {
                map.put(PROPERTITY_PANE_BACKGROUND, array);
            }
        }
    }

    private void processPlotOptions(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS);
        if (view != null) {
            HashMap<String, JSONObject> cfg = new HashMap<String, JSONObject>();
            List children = view.getChilds();
            if (children != null) {
                for (CompositeMap option : children) {
                    String name = option.getName().toLowerCase();
                    if ("chartcolumn".equals(name)) {
                        name = "column";
                    }
                    cfg.put(name, this.createPlotOption(option));
                }
            }
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_PLOTOPTIONS, new JSONObject(cfg));
            }
        }
    }

    private void processSeries(CompositeMap parent, String bindTarget) {
        List children;
        CompositeMap view = parent.getChild(PROPERTITY_SERIESLIST);
        if (view != null && (children = view.getChilds()) != null) {
            JSONArray array = new JSONArray();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                HashMap cfg = new HashMap();
                CompositeMap pb = (CompositeMap)it.next();
                if (!PROPERTITY_SERIESLIST_SERIESITEM.equals(pb.getName())) continue;
                this.createSeriesData(pb, cfg);
                this.putNumberCfg(pb, PROPERTITY_SERIESLIST_SERIESITEM_INDEX, cfg);
                this.putNumberCfg(pb, "legendIndex", cfg);
                this.putStringCfg(pb, "name", cfg);
                this.putBooleanCfg(pb, PROPERTITY_SERIESLIST_SERIESITEM_NEGATIVE, cfg);
                this.putStringCfg(pb, PROPERTITY_SERIESLIST_SERIESITEM_STACK, cfg);
                this.putStringCfg(pb, "type", cfg);
                this.putStringCfg(pb, "xAxis", cfg);
                this.putStringCfg(pb, "yAxis", cfg);
                this.putNumberCfg(pb, "zIndex", cfg);
                this.createPlotOption(pb, cfg);
                array.put(cfg);
            }
            if (array.length() > 0) {
                this.addConfig(bindTarget == null || "".equals(bindTarget) ? "series" : PROPERTITY_SERIESLIST, array);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createSeriesData(CompositeMap parent, Map map) {
        view = parent.getChild("seriesDatas");
        if (view != null && (children = view.getChilds()) != null) {
            array = new JSONArray();
            it = children.iterator();
            while (it.hasNext()) {
                cfg = new HashMap<K, V>();
                pb = (CompositeMap)it.next();
                if (!"seriesData".equals(pb.getName())) continue;
                this.putColorCfg(pb, "color", cfg);
                this.createPlotOptionDataLabels(pb, cfg);
                this.putStringCfg(pb, "drilldown", cfg);
                this.putEvents(pb, cfg);
                this.putNumberCfg(pb, "legendIndex", cfg);
                this.createPlotOptionMarker(pb, cfg, true);
                this.putStringCfg(pb, "name", cfg);
                this.putBooleanCfg(pb, "sliced", cfg);
                this.putBooleanCfg(pb, "selected", cfg);
                this.putNumberCfg(pb, "x", cfg);
                this.putNumberCfg(pb, "y", cfg);
                this.putNumberCfg(pb, "dataIndex", cfg);
                text = pb.getText();
                if (cfg.isEmpty()) {
                    block11: {
                        if (text == null || "".equals(text)) {
                            array.put(text);
                            continue;
                        }
                        try {
                            array.put(new Double(text));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            strs = text.split(",");
                            if (strs.length <= 1) break block11;
                            sb = new StringBuffer("[");
                            i = 0;
                            ** while (i < strs.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                sb.append(new Double(strs[i]));
                            }
                            catch (NumberFormatException ee) {
                                sb.append("\"" + strs[i] + "\"");
                            }
                            if (i != strs.length - 1) {
                                sb.append(",");
                            }
                            ++i;
                            continue;
                        }
lbl49:
                        // 1 sources

                        sb.append("]");
                        array.put(new JSONFunction(sb.toString()));
                        continue;
                    }
                    array.put(text);
                    continue;
                }
                array.put(cfg);
            }
            if (array.length() > 0) {
                map.put("data", array);
            }
        }
    }

    private JSONObject createPlotOption(CompositeMap view) {
        HashMap cfg = new HashMap();
        return this.createPlotOption(view, cfg);
    }

    private JSONObject createPlotOption(CompositeMap view, Map cfg) {
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT, cfg);
        this.putBooleanCfg(view, "animation", cfg);
        this.putStringCfg(view, "borderColor", cfg);
        this.putNumberCfg(view, "borderRadius", cfg);
        this.putNumberCfg(view, "borderWidth", cfg);
        this.putArrayCfg(view, "center", cfg);
        this.putColorCfg(view, "color", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_COLORBYPOINT, cfg);
        this.putArrayCfg(view, "colors", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_CONNECTENDS, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_CONNECTNULLS, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_CROPTHRESHOLD, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_CURSOR, cfg);
        this.putStringCfg(view, "dashStyle", cfg);
        this.createPlotOptionDial(view, cfg);
        this.createPlotOptionDataLabels(view, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_DISPLAYNEGATIVE, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING, cfg);
        this.putNumberCfg(view, "endAngle", cfg);
        this.putEvents(view, cfg);
        this.putColorCfg(view, "fillColor", cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_FILLOPACITY, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_GROUPPADDING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_GROUPING, cfg);
        this.putNumberCfg(view, "height", cfg);
        this.putStringCfg(view, "id", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_IGNOREHIDDENPOINT, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_INNERSIZE, cfg);
        this.putStringCfg(view, "lineColor", cfg);
        this.putNumberCfg(view, "lineWidth", cfg);
        this.putStringCfg(view, "linkedTo", cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_MAXSIZE, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_MEDIANCOLOR, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_MEDIANWIDTH, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_MINPOINTLENGTH, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_MINSIZE, cfg);
        this.createPlotOptionMarker(view, cfg, true);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_NECKHEIGHT, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_NECKWIDTH, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_NEGATIVECOLOR, cfg);
        this.putColorCfg(view, PROPERTITY_PLOTOPTIONS_NEGATIVEFILLCOLOR, cfg);
        this.createPlotOptionPivot(view, cfg);
        this.createPlotOptionPoint(view, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_POINTINTERVAL, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_POINTPADDING, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_POINTPLACEMENT, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_POINTRANGE, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_POINTSTART, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_POINTWIDTH, cfg);
        this.putBooleanCfg(view, "selected", cfg);
        this.putBooleanCfg(view, "shadow", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWINLEGEND, cfg);
        this.putNumberCfg(view, "size", cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_SLICEDOFFSET, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STACKING, cfg);
        this.putNumberCfg(view, "startAngle", cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STEMCOLOR, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STEMDASHSTYLE, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_STEMWIDTH, cfg);
        this.createPlotOptionStates(view, cfg, false);
        this.putNumberCfg(view, "step", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_STICKYTRACKING, cfg);
        this.createPlotOptionTooltip(view, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_THRESHOLD, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_TRACKBYAREA, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_TURBOTHRESHOLD, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_VISIBLE, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_WHISKERCOLOR, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_WHISKERLENGTH, cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_WHISKERWIDTH, cfg);
        this.putNumberCfg(view, "width", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_WRAP, cfg);
        this.putNumberCfg(view, "zIndex", cfg);
        this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_ZTHRESHOLD, cfg);
        return new JSONObject(cfg);
    }

    private void createPlotOptionDataLabels(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_DATALABELS);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "color", cfg);
            this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_DATALABELS_CONNECTORCOLOR, cfg);
            this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_DATALABELS_CONNECTORPADDING, cfg);
            this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_DATALABELS_CONNECTORWIDTH, cfg);
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putNumberCfg(view, "borderRadius", cfg);
            this.putNumberCfg(view, "borderWidth", cfg);
            this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_DATALABELS_CROP, cfg);
            this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_DATALABELS_INSIDE, cfg);
            this.putNumberCfg(view, "distance", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putStringCfg(view, "format", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putNumberCfg(view, "padding", cfg);
            this.putNumberCfg(view, "rotation", cfg);
            this.putBooleanCfg(view, "shadow", cfg);
            this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_DATALABELS_SOFTCONNECTOR, cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putBooleanCfg(view, "useHTML", cfg);
            this.putNumberCfg(view, "x", cfg);
            this.putNumberCfg(view, "y", cfg);
            this.putNumberCfg(view, "zIndex", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_DATALABELS, new JSONObject(cfg));
        }
    }

    private void createPlotOptionDial(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_DIAL);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_DIAL_BASELENGTH, cfg);
            this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_DIAL_BASEWIDTH, cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putNumberCfg(view, "borderWidth", cfg);
            this.putNumberCfg(view, "radius", cfg);
            this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_DIAL_REARLENGTH, cfg);
            this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_DIAL_TOPWIDTH, cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_DIAL, new JSONObject(cfg));
        }
    }

    private void createPlotOptionMarker(CompositeMap parent, Map map, boolean includeStates) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_MARKER);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putBooleanCfg(view, "enabled", cfg);
            this.putColorCfg(view, "fillColor", cfg);
            this.putStringCfg(view, "lineColor", cfg);
            this.putNumberCfg(view, "lineWidth", cfg);
            this.putNumberCfg(view, "radius", cfg);
            if (includeStates) {
                this.createPlotOptionStates(view, cfg, true);
            }
            this.putStringCfg(view, "symbol", cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_PLOTOPTIONS_MARKER, new JSONObject(cfg));
            }
        }
    }

    private void createPlotOptionPivot(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_PIVOT);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putNumberCfg(view, "borderWidth", cfg);
            this.putNumberCfg(view, "radius", cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_PLOTOPTIONS_PIVOT, new JSONObject(cfg));
            }
        }
    }

    private void createPlotOptionPoint(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_POINT);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putEvents(view, cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_PLOTOPTIONS_POINT, new JSONObject(cfg));
            }
        }
    }

    private void createPlotOptionStates(CompositeMap parent, Map map, boolean underMarker) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_STATES);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.createPlotOptionStatesHover(view, cfg, !underMarker);
            if (underMarker) {
                this.createPlotOptionStatesSelect(view, cfg);
            }
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_PLOTOPTIONS_STATES, new JSONObject(cfg));
            }
        }
    }

    private void createPlotOptionStatesHover(CompositeMap parent, Map map, boolean includeMaker) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_STATES_HOVER);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putBooleanCfg(view, "enabled", cfg);
            this.putNumberCfg(view, "lineWidth", cfg);
            if (includeMaker) {
                this.putNumberCfg(view, PROPERTITY_PLOTOPTIONS_STATES_HOVER_BRIGHTNESS, cfg);
                this.createPlotOptionMarker(view, cfg, false);
            } else {
                this.putStringCfg(view, "fillColor", cfg);
                this.putStringCfg(view, "lineColor", cfg);
                this.putNumberCfg(view, "radius", cfg);
            }
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_PLOTOPTIONS_STATES_HOVER, new JSONObject(cfg));
            }
        }
    }

    private void createPlotOptionStatesSelect(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_STATES_SELECT);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putBooleanCfg(view, "enabled", cfg);
            this.putStringCfg(view, "fillColor", cfg);
            this.putStringCfg(view, "lineColor", cfg);
            this.putNumberCfg(view, "lineWidth", cfg);
            this.putNumberCfg(view, "radius", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_STATES_SELECT, new JSONObject(cfg));
        }
    }

    private void createPlotOptionTooltip(CompositeMap parent, Map map) {
        CompositeMap view = map == null ? parent.getChild(PROPERTITY_TOOLTIP) : parent.getChild(PROPERTITY_PLOTOPTIONS_TOOLTIP);
        if (view == null) {
            view = parent.getChild(PROPERTITY_TOOLTIP);
        }
        if (view != null) {
            HashMap cfg = new HashMap();
            if (map == null) {
                this.putBooleanCfg(view, "animation", cfg);
                this.putStringCfg(view, "backgroundColor", cfg);
                this.putStringCfg(view, "borderColor", cfg);
                this.putNumberCfg(view, "borderRadius", cfg);
                this.putNumberCfg(view, "borderWidth", cfg);
                this.createToolTipCrosshairs(view, cfg);
                this.putBooleanCfg(view, "enabled", cfg);
                this.putFunctionCfg(view, "formatter", cfg);
                this.putFunctionCfg(view, PROPERTITY_TOOLTIP_POSITIONER, cfg);
                this.putBooleanCfg(view, "shadow", cfg);
                this.putBooleanCfg(view, PROPERTITY_TOOLTIP_SHARED, cfg);
                this.putNumberCfg(view, PROPERTITY_TOOLTIP_SNAP, cfg);
                this.putStyleCfg(view, "style", cfg);
                this.putBooleanCfg(view, "useHTML", cfg);
            }
            this.createDateTimeLabelFormats(view, cfg);
            this.putBooleanCfg(view, PROPERTITY_TOOLTIP_FOLLOWPOINTER, cfg);
            this.putBooleanCfg(view, PROPERTITY_TOOLTIP_FOLLOWTOUCHMOVE, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_FOOTERFORMAT, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_HEADERFORMAT, cfg);
            this.putNumberCfg(view, PROPERTITY_TOOLTIP_HIDEDELAY, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_POINTFORMAT, cfg);
            this.putNumberCfg(view, PROPERTITY_TOOLTIP_VALUEDECIMALS, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_VALUEPREFIX, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_VALUESUFFIX, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_XDATEFORMAT, cfg);
            if (!cfg.isEmpty()) {
                if (map != null) {
                    map.put(PROPERTITY_TOOLTIP, new JSONObject(cfg));
                } else {
                    this.addConfig(PROPERTITY_TOOLTIP, new JSONObject(cfg));
                }
            }
        }
    }

    private void processSubTitle(CompositeMap parent) {
        CompositeMap view = parent.getChild(PROPERTITY_SUBTITLE);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, "align", cfg);
            this.putBooleanCfg(view, "floating", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "text", cfg);
            this.putBooleanCfg(view, "useHTML", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putNumberCfg(view, "x", cfg);
            this.putNumberCfg(view, "y", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig(PROPERTITY_SUBTITLE, new JSONObject(cfg));
            }
        }
    }

    private void processTitle(CompositeMap parent) {
        CompositeMap view = parent.getChild("title");
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putBooleanCfg(view, "floating", cfg);
            this.putStringCfg(view, "align", cfg);
            this.putNumberCfg(view, "margin", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "text", cfg);
            this.putBooleanCfg(view, "useHTML", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putNumberCfg(view, "x", cfg);
            this.putNumberCfg(view, "y", cfg);
            if (!cfg.isEmpty()) {
                this.addConfig("title", new JSONObject(cfg));
            }
        }
    }

    private void processTooltip(CompositeMap parent) {
        this.createPlotOptionTooltip(parent, null);
    }

    private void createToolTipCrosshairs(CompositeMap view, Map map) {
        CompositeMap pbs = view.getChild(PROPERTITY_TOOLTIP_CROSSHAIRS);
        if (pbs != null) {
            List list = pbs.getChilds();
            if (list != null) {
                JSONArray array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pb = (CompositeMap)it.next();
                    this.putStringCfg(pb, "color", cfg);
                    this.putStringCfg(pb, "dashStyle", cfg);
                    this.putNumberCfg(pb, "width", cfg);
                    array.put(cfg);
                }
                if (array.length() > 0) {
                    map.put(PROPERTITY_TOOLTIP_CROSSHAIRS, array);
                }
            }
        } else {
            String crosshairs = view.getString(PROPERTITY_TOOLTIP_CROSSHAIRS);
            if (crosshairs != null) {
                if (crosshairs.indexOf(",") != -1) {
                    this.putArrayCfg(view, PROPERTITY_TOOLTIP_CROSSHAIRS, map);
                } else {
                    this.putBooleanCfg(view, PROPERTITY_TOOLTIP_CROSSHAIRS, map);
                }
            }
        }
    }

    private void processXAxis(CompositeMap parent) {
        this.processAxis(parent, "xAxis");
    }

    private void processYAxis(CompositeMap parent) {
        this.processAxis(parent, "yAxis");
    }

    private void processZAxis(CompositeMap parent) {
        this.processAxis(parent, PROPERTITY_AXIS_Z);
    }

    private void processAxis(CompositeMap parent, String name) {
        CompositeMap axis = parent.getChild(name);
        if (axis != null) {
            List list = axis.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap axi = (CompositeMap)it.next();
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_ALLOWDECIMALS, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_ALTERNATEGRIDCOLOR, cfg);
                    this.putArrayCfg(axi, PROPERTITY_AXIS_CATEGORIES, cfg);
                    this.createDateTimeLabelFormats(axi, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_ENDONTICK, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINECOLOR, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINEDASHSTYLE, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINEINTERPOLATION, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_GRIDLINEWIDTH, cfg);
                    this.putStringCfg(axi, "id", cfg);
                    this.createAxisLabels(axi, cfg);
                    this.putStringCfg(axi, "lineColor", cfg);
                    this.putNumberCfg(axi, "lineWidth", cfg);
                    this.putNumberCfg(axi, "linkedTo", cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MAX, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MAXPADDING, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MIN, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINTICKINTERVAL, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORGRIDLINECOLOR, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORGRIDLINEDASHSTYLE, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINORGRIDLINEWIDTH, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORTICKCOLOR, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINORTICKINTERVAL, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINORTICKLENGTH, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORTICKPOSITION, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINORTICKWIDTH, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINRANGE, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_MINPADDING, cfg);
                    this.putNumberCfg(axi, "offset", cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_OPPOSITE, cfg);
                    this.createPlotBands(axi, cfg);
                    this.createPlotLines(axi, cfg);
                    this.putBooleanCfg(axi, "reversed", cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWEMPTY, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWFIRSTLABEL, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWLASTLABEL, cfg);
                    if ("yAxis".equals(name)) {
                        this.createStackLabels(axi, cfg);
                    }
                    this.putNumberCfg(axi, PROPERTITY_AXIS_STARTOFWEEK, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_STARTONTICK, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_TICKCOLOR, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_TICKINTERVAL, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_TICKLENGTH, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_TICKMARKPLACEMENT, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_TICKPIXELINTERVAL, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_TICKPOSITION, cfg);
                    this.putFunctionCfg(axi, PROPERTITY_AXIS_TICKPOSITIER, cfg);
                    this.putArrayCfg(axi, PROPERTITY_AXIS_TICKPOSITIONS, cfg);
                    this.putNumberCfg(axi, PROPERTITY_AXIS_TICKWIDTH, cfg);
                    this.putStringCfg(axi, "lineColor", cfg);
                    this.processTitle(axi, cfg);
                    this.putStringCfg(axi, "type", cfg);
                    this.putEvents(axi, cfg);
                    this.putStringCfg(axi, "name", cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_BINDTARGET, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_DATEFORMAT, cfg);
                    this.putNumberCfg(axi, "startAngle", cfg);
                    this.putNumberCfg(axi, "endAngle", cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    this.addConfig(name, array);
                }
            }
        }
    }

    private void createAxisLabels(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild(PROPERTITY_AXIS_LABELS);
        if (view != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(view, "align", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putNumberCfg(view, "distance", cfg);
            this.putStringCfg(view, "format", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putNumberCfg(view, PROPERTITY_AXIS_LABELS_MAXSTAGGERLINES, cfg);
            this.putNumberCfg(view, "rotation", cfg);
            this.putStringCfg(view, PROPERTITY_AXIS_LABELS_OVERFLOW, cfg);
            this.putNumberCfg(view, PROPERTITY_AXIS_LABELS_STAGGERLINES, cfg);
            this.putNumberCfg(view, "step", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putBooleanCfg(view, "useHTML", cfg);
            this.putNumberCfg(view, "x", cfg);
            this.putNumberCfg(view, "y", cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_AXIS_LABELS, new JSONObject(cfg));
            }
        }
    }

    private void createDateTimeLabelFormats(CompositeMap view, Map map) {
        CompositeMap formats = view.getChild(PROPERTITY_AXIS_DATETIMELABELFORMATS);
        if (formats != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_MILLISECOND, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_SECOND, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_MINUTE, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_HOUR, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_DAY, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_WEEK, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_MONTH, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_YEAR, cfg);
            if (!cfg.isEmpty()) {
                map.put(PROPERTITY_AXIS_DATETIMELABELFORMATS, new JSONObject(cfg));
            }
        }
    }

    private void createStackLabels(CompositeMap view, Map map) {
        CompositeMap formats = view.getChild(PROPERTITY_AXIS_STACKLABELS);
        HashMap cfg = new HashMap();
        if (formats != null) {
            this.putStringCfg(formats, "align", cfg);
            this.putStringCfg(formats, "textAlign", cfg);
            this.putStringCfg(formats, "verticalAlign", cfg);
            this.putBooleanCfg(formats, "enabled", cfg);
            this.putFunctionCfg(formats, "formatter", cfg);
            this.putStyleCfg(formats, "style", cfg);
            this.putNumberCfg(formats, "rotation", cfg);
            this.putNumberCfg(formats, "x", cfg);
            this.putNumberCfg(formats, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_AXIS_STACKLABELS, new JSONObject(cfg));
        }
    }

    private void createPlotBands(CompositeMap view, Map map) {
        CompositeMap pbs = view.getChild(PROPERTITY_AXIS_PLOTBANDS);
        if (pbs != null) {
            List list = pbs.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pb = (CompositeMap)it.next();
                    this.putStringCfg(pb, "color", cfg);
                    this.putNumberCfg(pb, PROPERTITY_AXIS_PLOTBANDS_FROM, cfg);
                    this.putStringCfg(pb, "id", cfg);
                    this.processPlotLabel(pb, cfg);
                    this.putStringCfg(pb, "innerRadius", cfg);
                    this.putStringCfg(pb, "outerRadius", cfg);
                    this.putStringCfg(pb, PROPERTITY_AXIS_PLOTBANDS_THICKNESS, cfg);
                    this.putNumberCfg(pb, PROPERTITY_AXIS_PLOTBANDS_TO, cfg);
                    this.putNumberCfg(pb, "zIndex", cfg);
                    this.putEvents(pb, cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_PLOTBANDS, array);
                }
            }
        }
    }

    private void createPlotLines(CompositeMap view, Map map) {
        CompositeMap pls = view.getChild(PROPERTITY_AXIS_PLOTLINES);
        if (pls != null) {
            List list = pls.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pl = (CompositeMap)it.next();
                    this.putStringCfg(pl, "color", cfg);
                    this.putStringCfg(pl, "id", cfg);
                    this.putNumberCfg(pl, PROPERTITY_AXIS_PLOTLINES_VALUE, cfg);
                    this.putNumberCfg(pl, "width", cfg);
                    this.processPlotLabel(pl, cfg);
                    this.putNumberCfg(pl, "zIndex", cfg);
                    this.putEvents(pl, cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_PLOTLINES, array);
                }
            }
        }
    }

    private void processPlotLabel(CompositeMap view, Map map) {
        CompositeMap label = view.getChild(PROPERTITY_AXIS_PLOT_LABEL);
        HashMap cfg = new HashMap();
        if (label != null) {
            this.putStringCfg(label, "align", cfg);
            this.putStringCfg(label, "text", cfg);
            this.putStringCfg(label, "verticalAlign", cfg);
            this.putNumberCfg(label, "rotation", cfg);
            this.putStyleCfg(label, "style", cfg);
            this.putStringCfg(label, "textAlign", cfg);
            this.putNumberCfg(label, "x", cfg);
            this.putNumberCfg(label, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put("label", new JSONObject(cfg));
        }
    }

    private void processTitle(CompositeMap view, Map map) {
        CompositeMap title = view.getChild("title");
        HashMap cfg = new HashMap();
        if (title != null) {
            this.putStringCfg(title, "align", cfg);
            this.putNumberCfg(title, "margin", cfg);
            this.putNumberCfg(title, "offset", cfg);
            this.putStyleCfg(title, "style", cfg);
            this.putNumberCfg(title, "rotation", cfg);
            this.putStringCfg(title, "text", cfg);
            this.putNumberCfg(title, "x", cfg);
            this.putNumberCfg(title, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put("title", new JSONObject(cfg));
        }
    }
}

