/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.AccordionConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Accordion
extends Component {
    public static final String VERSION = "$Revision: 8434 $";
    private static final String DEFAULT_CLASS = "layout-accordion";
    private static final String SELECTED = "selected";
    private static final String REF = "ref";
    private Integer bodyHeight;
    private int stripHeight = 25;

    public Accordion(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected int getDefaultHeight() {
        return -1;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "accordion/Accordion-min.css");
        this.addJavaScript(session, context, "accordion/Accordion-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        this.addConfig("stripheight", new Integer(this.stripHeight));
        map.put("accordions", this.createAccordions(session, context));
        map.put("config", this.getConfigString());
    }

    private String createAccordions(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        AccordionConfig ac = AccordionConfig.getInstance(view);
        Map map = context.getMap();
        CompositeMap accordions = ac.getAccordions();
        StringBuffer sb = new StringBuffer();
        JSONArray jsons = new JSONArray();
        if (accordions != null && (childs = accordions.getChilds()) != null) {
            int numAccordions = childs.size();
            int i = 0;
            boolean isSelected = false;
            boolean singleMode = ac.isSingleMode();
            boolean showIcon = ac.isShowIcon();
            int height = (Integer)map.get("height");
            if (height > 0) {
                this.bodyHeight = new Integer((height - numAccordions * this.stripHeight) / (singleMode ? 1 : numAccordions));
            }
            Iterator it = childs.iterator();
            this.addConfig("singlemode", new Boolean(singleMode));
            this.addConfig("showicon", new Boolean(showIcon));
            while (it.hasNext()) {
                CompositeMap accordion = (CompositeMap)it.next();
                if (!(isSelected && singleMode || !"true".equals(accordion.getString(SELECTED, "")))) {
                    isSelected = true;
                    sb.append(this.createAccordion(session, context, accordion, true, showIcon));
                } else {
                    sb.append(this.createAccordion(session, context, accordion, false, showIcon));
                }
                jsons.put(new JSONObject(accordion));
                ++i;
            }
        }
        this.addConfig("items", jsons);
        return sb.toString();
    }

    private String createAccordion(BuildSession session, ViewContext context, CompositeMap accordion, boolean isSelected, boolean showIcon) throws IOException {
        String prompt;
        CompositeMap model = context.getModel();
        StringBuffer sb = new StringBuffer();
        sb.append("<DIV class='" + (isSelected ? "item-accordion selected" : "item-accordion") + "' style='height:" + this.stripHeight + "px'><DIV class='accordion-strip'>");
        if (showIcon) {
            sb.append("<div class='item-accordion-btn'></div>");
        }
        if ((prompt = TextParser.parse(session.getLocalizedPrompt(accordion.getString("prompt")), model)) != null) {
            sb.append(prompt);
        }
        sb.append("</DIV><DIV class='item-accordion-body' hideFocus tabIndex='-1' style='");
        if (this.bodyHeight != null) {
            sb.append("height:" + this.bodyHeight + "px;");
        }
        sb.append(String.valueOf(isSelected ? "" : "visibility:hidden") + "'");
        String ref = accordion.getString(REF, "");
        if ("".equals(ref)) {
            String hostid = IDGenerator.getInstance().generate();
            sb.append(" host_id='" + hostid + "'>");
            List accordionChilds = accordion.getChilds();
            if (accordionChilds != null) {
                for (CompositeMap accordionChild : accordionChilds) {
                    try {
                        sb.append(session.buildViewAsString(model, accordionChild));
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            } else if (accordion.getText() != null && !"".equals(accordion.getText())) {
                sb.append(accordion.getText());
            }
        } else {
            sb.append(">");
        }
        accordion.putString(REF, TextParser.parse(ref, model));
        sb.append("</DIV></DIV>");
        return sb.toString();
    }
}

