/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.AbstractSqlCreator;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.ServiceOption;
import aurora.database.service.SqlServiceContext;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.UpdateStatement;
import uncertain.composite.CompositeMap;

public class UpdateSqlCreator
extends AbstractSqlCreator {
    public UpdateSqlCreator(IModelFactory model_fact, IDatabaseFactory db_fact) {
        super(model_fact, db_fact);
    }

    public UpdateStatement createUpdateStatement(BusinessModel model, SqlServiceContext context) {
        UpdateStatement stmt = new UpdateStatement(model.getBaseTable(), model.getAlias());
        ServiceOption op = context.getServiceOption();
        CompositeMap param = context.getCurrentParameter();
        boolean update_passed_param = false;
        if (op != null) {
            update_passed_param = op.isUpdatePassedFieldOnly();
        }
        Field[] fields = model.getFields();
        int i = 0;
        while (i < fields.length) {
            block5: {
                Field field;
                block6: {
                    field = fields[i];
                    if (!field.isForUpdate()) break block5;
                    if (!update_passed_param) break block6;
                    String path = field.getInputPath();
                    if (!field.isForceUpdate() && param.getObject(path) == null && !param.containsKey(field.getName())) break block5;
                }
                stmt.addUpdateField(field.getPhysicalName(), field.getUpdateExpression());
            }
            ++i;
        }
        return stmt;
    }

    public void onCreateUpdateStatement(BusinessModel model, BusinessModelServiceContext context) {
        UpdateStatement statement = this.createUpdateStatement(model, SqlServiceContext.createSqlServiceContext(context.getObjectContext()));
        String type = context.getObjectContext().getString("UpdateType", "PK");
        if ("PK".equals(type)) {
            UpdateSqlCreator.addPrimaryKeyQuery(model, statement);
        }
        context.setStatement(statement);
    }

    public void onCreateUpdateSql(ISqlStatement s, BusinessModelServiceContext context) {
        this.doCreateSql("update", s, context);
    }
}

