/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BusinessModel;
import aurora.bm.DefaultAccessChecker;
import aurora.bm.IBusinessModelAccessChecker;
import aurora.bm.IBusinessModelAccessCheckerFactory;
import aurora.bm.IModelFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import uncertain.cache.CacheBuiltinExceptionFactory;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;

public class CacheBasedBmAccessCheckerFactory
extends AbstractLocatableObject
implements IBusinessModelAccessCheckerFactory,
IGlobalInstance {
    INamedCacheFactory mCacheFactory;
    IModelFactory mModelFactory;
    ICache mBmDataCache;
    String mCacheName;
    String menuCachePath;
    String menuIdKey;

    public CacheBasedBmAccessCheckerFactory(IModelFactory mf, INamedCacheFactory fact) {
        this.mCacheFactory = fact;
        this.mModelFactory = mf;
    }

    public void onInitialize() {
        if (this.menuCachePath == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "menuCachePath");
        }
        if (this.menuIdKey == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "menuIdKey");
        }
        if (this.mCacheName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "cacheName");
        }
        this.mBmDataCache = this.mCacheFactory.getNamedCache(this.mCacheName);
        if (this.mBmDataCache == null) {
            throw CacheBuiltinExceptionFactory.createNamedCacheNotFound(this, this.mCacheName);
        }
    }

    @Override
    public IBusinessModelAccessChecker getChecker(String model_name, CompositeMap session_context) throws Exception {
        BusinessModel bm = this.mModelFactory.getModelForRead(model_name);
        assert (bm != null);
        BusinessModel bm_for_check = bm.getModelForAccessCheck();
        if (!bm_for_check.getNeedAccessControl()) {
            return DefaultAccessChecker.ALWAYS_ALLOW;
        }
        CompositeMap userFunctionMap = (CompositeMap)session_context.getObject(this.menuCachePath);
        ArrayList<Object> funtionIdList = new ArrayList<Object>();
        if (userFunctionMap != null) {
            List l = userFunctionMap.getChildsNotNull();
            for (CompositeMap m : l) {
                funtionIdList.add(m.get(this.menuIdKey));
            }
        }
        return new BmAccessChecker(model_name, funtionIdList, this.mBmDataCache);
    }

    public String getCacheName() {
        return this.mCacheName;
    }

    public void setCacheName(String cacheName) {
        this.mCacheName = cacheName;
    }

    public String getMenuCachePath() {
        return this.menuCachePath;
    }

    public void setMenuCachePath(String menuCachePath) {
        this.menuCachePath = menuCachePath;
    }

    public String getMenuIdKey() {
        return this.menuIdKey;
    }

    public void setMenuIdKey(String menuIdKey) {
        this.menuIdKey = menuIdKey;
    }

    static class BmAccessChecker
    implements IBusinessModelAccessChecker {
        private ArrayList<Object> funtionIdList;
        private ICache cache;
        private String bm_name;
        private HashMap<String, Boolean> hashMap = new HashMap();

        public BmAccessChecker(String bm_name, ArrayList<Object> funtionIdList, ICache cache) {
            this.bm_name = bm_name;
            this.funtionIdList = funtionIdList;
            this.cache = cache;
        }

        @Override
        public boolean canPerformOperation(String operation) {
            Boolean can = this.hashMap.get(operation);
            if (can == null) {
                can = false;
                for (Object id : this.funtionIdList) {
                    String key = String.valueOf(id.toString()) + "." + this.bm_name;
                    CompositeMap m = (CompositeMap)this.cache.getValue(key);
                    if (m == null || !"Y".equals(m.getString(operation))) continue;
                    can = true;
                    break;
                }
                this.hashMap.put(operation, can);
            }
            return can;
        }
    }
}

