/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import aurora.service.ServiceThreadLocal;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class TaskUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ILogger logger;
    private IObjectRegistry mRegistry;
    private IDatabaseServiceFactory databaseServiceFactory;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;

    public TaskUtil(ILogger logger, IObjectRegistry registry) {
        this.logger = logger;
        this.mRegistry = registry;
        this.databaseServiceFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.databaseServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        this.procedureManager = (IProcedureManager)this.mRegistry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IServiceFactory.class, this.getClass().getName());
        }
    }

    public void executeTask(Connection connection, CompositeMap task) throws Exception {
        CompositeMap context = this.getContext(task);
        if (context == null) {
            context = new CompositeMap();
        }
        ServiceThreadLocal.setCurrentThreadContext(context);
        int task_id = task.getInt("task_id");
        if (task_id == 0) {
            throw BuiltinExceptionFactory.createAttributeMissing(null, "task_id");
        }
        String task_type = task.getString("task_type");
        String proc_file_path = task.getString("proc_file_path");
        CompositeMap proc_content = this.getProcContext(task);
        String sql = task.getString("sql");
        if ("JAVA".equals(task_type)) {
            if (proc_file_path != null && !proc_file_path.equals("")) {
                this.executeProc(proc_file_path, task_id, context, connection);
            } else {
                if (proc_content == null) {
                    throw BuiltinExceptionFactory.createOneAttributeMissing(null, "proc_file_path,proc_content");
                }
                this.executeProc(proc_content, task_id, context, connection);
            }
        } else if ("PROCEDURE".equals(task_type)) {
            if (sql == null || "".equals(sql)) {
                throw BuiltinExceptionFactory.createAttributeMissing(null, "sql");
            }
            this.execDbProc(connection, context, sql);
        } else if ("FUNCTION".equals(task_type)) {
            if (sql == null || "".equals(sql)) {
                throw BuiltinExceptionFactory.createAttributeMissing(null, "sql");
            }
            this.execDbFun(connection, context, sql);
        } else {
            throw new IllegalArgumentException("The " + task_type + " is not supported!");
        }
    }

    public CompositeMap getContext(CompositeMap taskRecord) throws Exception {
        if (taskRecord == null) {
            return null;
        }
        Object context = taskRecord.get("context");
        if (context == null) {
            return null;
        }
        String strContext = null;
        strContext = context instanceof Clob ? this.clobToString((Clob)context) : context.toString();
        return this.loadFromString(strContext);
    }

    private String clobToString(Clob clob) throws Exception {
        Reader inStreamDoc = clob.getCharacterStream();
        char[] tempDoc = new char[(int)clob.length()];
        inStreamDoc.read(tempDoc);
        inStreamDoc.close();
        return new String(tempDoc);
    }

    private CompositeMap loadFromString(String content) throws Exception {
        if (content == null) {
            return null;
        }
        CompositeMap context = null;
        if (content != null && !"".equals(content)) {
            context = new CompositeLoader().loadFromString(content, "UTF-8");
            this.clearInstance(context);
        }
        return context;
    }

    /*
     * Unable to fully structure code
     */
    private void clearInstance(CompositeMap context) {
        if (context == null) {
            return;
        }
        it = context.entrySet().iterator();
        if (it != null) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            it.next();
            it.remove();
lbl9:
            // 2 sources

            ** while (it.hasNext())
        }
lbl10:
        // 1 sources

    }

    private CompositeMap getProcContext(CompositeMap taskRecord) throws Exception {
        if (taskRecord == null) {
            return null;
        }
        Object proc_content = taskRecord.get("proc_content");
        if (proc_content == null) {
            return null;
        }
        String str_Proc_content = null;
        str_Proc_content = proc_content instanceof Clob ? this.clobToString((Clob)proc_content) : proc_content.toString();
        return this.loadFromString(str_Proc_content);
    }

    public CompositeMap queryBM(Connection connection, String bm_name, CompositeMap context, CompositeMap parameterMap) throws Exception {
        SqlServiceContext sqlContext;
        CompositeMap localContext = context;
        if (localContext == null) {
            localContext = new CompositeMap();
        }
        if ((sqlContext = SqlServiceContext.createSqlServiceContext(localContext)) == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + localContext.toXML());
        }
        sqlContext.setConnection(connection);
        BusinessModelService service = this.databaseServiceFactory.getModelService(bm_name, localContext);
        CompositeMap resultMap = service.queryAsMap(parameterMap, FetchDescriptor.fetchAll());
        return resultMap;
    }

    public void executeBM(Connection connection, String bm_name, CompositeMap context, CompositeMap parameterMap) throws Exception {
        SqlServiceContext sqlContext;
        CompositeMap localContext = context;
        if (localContext == null) {
            localContext = new CompositeMap();
        }
        if ((sqlContext = SqlServiceContext.createSqlServiceContext(localContext)) == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + localContext.toXML());
        }
        connection.setAutoCommit(false);
        sqlContext.setConnection(connection);
        try {
            BusinessModelService service = this.databaseServiceFactory.getModelService(bm_name, localContext);
            service.execute(parameterMap);
            connection.commit();
        }
        catch (Exception ex) {
            this.rollbackConnection(connection);
            throw new RuntimeException(ex);
        }
    }

    public void executeProc(String procedure_name, int taskId, CompositeMap context, Connection connection) {
        this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure_name});
        Procedure proc = this.procedureManager.loadProcedure(procedure_name);
        this.executeProc(taskId, proc, context, connection);
    }

    protected void executeProc(CompositeMap procedure_config, int taskId, CompositeMap context, Connection connection) {
        this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure_config.toXML()});
        Procedure proc = null;
        proc = this.procedureManager.createProcedure(procedure_config);
        this.executeProc(taskId, proc, context, connection);
    }

    protected void executeProc(int taskId, Procedure proc, CompositeMap context, Connection connection) {
        if (proc == null) {
            throw new IllegalArgumentException("Procedure can not be null!");
        }
        try {
            String name = "task." + taskId;
            if (context != null) {
                context.putObject("/parameter/@task_id", (Object)taskId, true);
                ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
            } else {
                ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String execDbFun(Connection connection, CompositeMap context, String function) throws Exception {
        SqlServiceContext sqlContext = SqlServiceContext.createSqlServiceContext(context);
        if (sqlContext == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + context.toXML());
        }
        sqlContext.setConnection(connection);
        String errorMessage = null;
        CallableStatement proc = null;
        try {
            try {
                connection.setAutoCommit(false);
                proc = connection.prepareCall("{call ? := " + function + "}");
                proc.registerOutParameter(1, 12);
                proc.execute();
                errorMessage = proc.getString(1);
                if (errorMessage == null || "".equals(errorMessage)) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                proc.close();
            }
            catch (Exception e) {
                this.rollbackConnection(connection);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(proc);
            throw throwable;
        }
        this.closeStatement(proc);
        return errorMessage;
    }

    private void execDbProc(Connection connection, CompositeMap context, String executePkg) throws Exception {
        SqlServiceContext sqlContext = SqlServiceContext.createSqlServiceContext(context);
        if (sqlContext == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + context.toXML());
        }
        sqlContext.setConnection(connection);
        CallableStatement proc = null;
        try {
            try {
                connection.setAutoCommit(false);
                proc = connection.prepareCall("{call " + executePkg + "}");
                proc.execute();
                connection.commit();
                proc.close();
                connection.setAutoCommit(true);
            }
            catch (Exception e) {
                this.rollbackConnection(connection);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(proc);
            throw throwable;
        }
        this.closeStatement(proc);
    }

    private void rollbackConnection(Connection dbConn) {
        if (dbConn == null) {
            return;
        }
        try {
            dbConn.rollback();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "", ex);
        }
    }

    private void closeStatement(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "", ex);
        }
    }

    public void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "", ex);
        }
    }

    public String getFullStackTrace(Throwable exception) {
        String message = this.getExceptionStackTrace(exception);
        return message;
    }

    private String getExceptionStackTrace(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        exception.printStackTrace(pw);
        pw.close();
        return baos.toString();
    }

    public int getTaskId(CompositeMap taskRecord) {
        if (taskRecord == null) {
            return -1;
        }
        return taskRecord.getInt("task_id", -1);
    }
}

