/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.application.task.TaskExecutor;
import aurora.application.task.TaskHandler;
import aurora.application.task.TaskUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.core.ILifeCycle;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class TaskExecutorManager
implements Callable<String>,
ILifeCycle {
    private ExecutorService timeOutService;
    private ExecutorService handleTaskService;
    private IObjectRegistry mRegistry;
    private ILogger logger;
    private TaskHandler taskManager;

    public TaskExecutorManager(IObjectRegistry registry, TaskHandler taskManager) {
        this.mRegistry = registry;
        this.taskManager = taskManager;
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
    }

    @Override
    public String call() throws Exception {
        try {
            this.timeOutService = Executors.newCachedThreadPool();
            int threadCount = this.taskManager.getThreadCount();
            this.handleTaskService = Executors.newFixedThreadPool(threadCount);
            while (this.taskManager.isRunnning()) {
                CompositeMap taskRecord = this.taskManager.popTaskQueue();
                try {
                    if (taskRecord == null || taskRecord.isEmpty()) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    this.logger.log(Level.CONFIG, "get a task record from queue,task is" + TaskUtil.LINE_SEPARATOR + TaskUtil.LINE_SEPARATOR + taskRecord.toXML());
                    Object task_id = taskRecord.get("task_id");
                    if (task_id == null || "null".equals(task_id)) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    TaskExecutor taskExecutor = new TaskExecutor(this.mRegistry, this.taskManager, this.timeOutService, taskRecord);
                    this.handleTaskService.submit(taskExecutor);
                }
                catch (InterruptedException task_id) {
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, "", e);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "", e);
        }
        return "finished";
    }

    @Override
    public boolean startup() {
        return true;
    }

    @Override
    public void shutdown() {
        if (this.timeOutService != null) {
            this.timeOutService.shutdownNow();
        }
        if (this.handleTaskService != null) {
            this.handleTaskService.shutdownNow();
        }
    }
}

