/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.application.task.CallableTask;
import aurora.application.task.TaskHandler;
import aurora.application.task.TaskUtil;
import aurora.service.ServiceThreadLocal;
import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class TaskExecutor
implements Callable<String> {
    private CompositeMap taskRecord;
    private ExecutorService timeOutService;
    private IObjectRegistry registry;
    private ILogger logger;
    private TaskUtil taskUtil;
    private TaskHandler taskManager;

    public TaskExecutor(IObjectRegistry registry, TaskHandler taskManager, ExecutorService timeOutService, CompositeMap taskRecord) {
        this.registry = registry;
        this.timeOutService = timeOutService;
        this.taskRecord = taskRecord;
        this.taskManager = taskManager;
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), registry);
        this.taskUtil = new TaskUtil(this.logger, registry);
    }

    @Override
    public String call() throws Exception {
        block16: {
            Connection connection = this.taskManager.getConnectionFromQueue();
            while (connection == null) {
                this.logger.log(Level.SEVERE, "Can not get database connection!");
                Thread.sleep(1000L);
                connection = this.taskManager.getConnectionFromQueue();
            }
            CompositeMap para = new CompositeMap();
            CompositeMap context = new CompositeMap();
            int taskId = this.taskUtil.getTaskId(this.taskRecord);
            para.put("task_id", (Object)taskId);
            try {
                try {
                    context = this.taskUtil.getContext(this.taskRecord);
                    ServiceThreadLocal.setCurrentThreadContext(context);
                    this.logger.log(Level.CONFIG, "begin to execute task,task_id=" + this.taskUtil.getTaskId(this.taskRecord));
                    int execute_time = this.taskRecord.getInt("retry_time", 0) + 1;
                    int current_retry_time = this.taskRecord.getInt("current_retry_time", 0);
                    int time_out = this.taskRecord.getInt("time_out");
                    StringBuilder excepiton = new StringBuilder();
                    String errorMessage = null;
                    para.put("status", "running");
                    String updateTaskBM = this.taskManager.getUpdateTaskBM();
                    try {
                        this.taskUtil.executeBM(connection, updateTaskBM, context, para);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "", e);
                    }
                    while (current_retry_time < execute_time) {
                        if (current_retry_time > 0) {
                            try {
                                para.put("current_retry_time", (Object)current_retry_time);
                                this.taskUtil.executeBM(connection, updateTaskBM, context, para);
                            }
                            catch (Throwable e) {
                                this.logger.log(Level.SEVERE, "", e);
                            }
                        }
                        try {
                            errorMessage = this.executeTask(connection, time_out);
                            if (errorMessage == null || errorMessage.isEmpty()) {
                                excepiton = null;
                                break;
                            }
                            excepiton.append(errorMessage).append(TaskUtil.LINE_SEPARATOR);
                        }
                        catch (Exception e) {
                            excepiton.append(this.taskUtil.getFullStackTrace(e)).append(TaskUtil.LINE_SEPARATOR);
                        }
                        ++current_retry_time;
                    }
                    if (excepiton != null && excepiton.length() != 0) {
                        para.put("exception", excepiton.toString());
                        this.logger.log(Level.SEVERE, excepiton.toString());
                    }
                    this.logger.log(Level.CONFIG, "finish task,task_id=" + taskId);
                    this.logger.log(Level.CONFIG, "pass parameter =" + para.toXML());
                    this.updateFinishStatus(connection, context, para);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "", e);
                    para.put("exception", this.taskUtil.getFullStackTrace(e));
                    this.updateFinishStatus(connection, context, para);
                    this.taskManager.removeRunningTask(String.valueOf(taskId));
                    this.taskManager.backToQueue(connection);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.taskManager.removeRunningTask(String.valueOf(taskId));
                this.taskManager.backToQueue(connection);
                throw throwable;
            }
            this.taskManager.removeRunningTask(String.valueOf(taskId));
            this.taskManager.backToQueue(connection);
        }
        this.taskManager.checkTaskQueue();
        ServiceThreadLocal.remove();
        return "finished";
    }

    private void updateFinishStatus(Connection connection, CompositeMap context, CompositeMap newPara) {
        try {
            this.taskUtil.executeBM(connection, this.taskManager.getFinishTaskBM(), context, newPara);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    private String executeTask(Connection connection, int timeOut) {
        int taskId = this.taskUtil.getTaskId(this.taskRecord);
        CallableTask callableTask = new CallableTask(this.registry, connection, this.taskRecord);
        StringBuilder excepiton = new StringBuilder();
        Future<String> future = this.timeOutService.submit(callableTask);
        this.taskManager.addRunningTask(String.valueOf(taskId), future);
        try {
            String result = "";
            result = timeOut > 0 ? future.get(timeOut, TimeUnit.MILLISECONDS) : future.get();
            return result;
        }
        catch (Exception e) {
            boolean successful = future.cancel(true);
            if (!successful) {
                this.logger.log(Level.WARNING, "Can not cancel the task:" + taskId);
            }
            excepiton.append(this.taskUtil.getFullStackTrace(e));
            return excepiton.toString();
        }
    }
}

