/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.features.RequestRecorderMBean;
import aurora.database.DBUtil;
import aurora.database.actions.ModelBatchUpdate;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.events.E_ServiceFinish;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.http.HttpServiceInstance;
import aurora.service.http.UserAgentTools;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.event.RuntimeContext;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.mbean.IMBeanNameProvider;
import uncertain.mbean.IMBeanRegister;
import uncertain.mbean.IMBeanRegistrable;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.trace.StackTraceManager;
import uncertain.proc.trace.TraceElement;
import uncertain.util.StackTraceUtil;

public class RequestRecorder
extends AbstractLocatableObject
implements E_ServiceFinish,
IGlobalInstance,
IMBeanRegistrable,
RequestRecorderMBean {
    public static final String KEY_CONTEXT_DUMP = "context_dump";
    static int sequence = 1;
    int checkInterval = 1000;
    long connectionIdleTime = 1200000L;
    String[] nodeToSaveArray = new String[]{"session"};
    String requestSaveBm = "sys.monitor.sys_runtime_request_record";
    boolean saveDetail = true;
    int batchSize = 100;
    int threadCount = 1;
    IObjectRegistry mObjectReg;
    OCManager mOcManager;
    DataSource mDataSource;
    DatabaseServiceFactory mDbFactory;
    ILogger mLogger;
    long requestCount = 0L;
    long processedCount = 0L;
    long processTime = 0L;
    boolean isRunning = true;
    int maxQueueSize = 0;
    Date maxQueueTime = new Date();
    Queue<CompositeMap> recordQueue = new ConcurrentLinkedQueue<CompositeMap>();
    RequestProcessor[] threads;

    public RequestRecorder(IObjectRegistry reg) {
        this.mObjectReg = reg;
    }

    public void onInitialize() throws IOException {
        if (this.requestSaveBm == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "requestSaveService");
        }
        this.mDbFactory = (DatabaseServiceFactory)this.mObjectReg.getInstanceOfType(DatabaseServiceFactory.class);
        if (this.mDbFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DatabaseServiceFactory.class);
        }
        this.mOcManager = (OCManager)this.mObjectReg.getInstanceOfType(OCManager.class);
        this.mLogger = LoggingContext.getLogger("aurora.monitor", this.mObjectReg);
        this.mLogger.info("request recorder initialize");
        this.mDataSource = this.mDbFactory.getDataSource();
        if (this.mDataSource == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DataSource.class);
        }
        this.threads = new RequestProcessor[this.threadCount];
        int i = 0;
        while (i < this.threadCount) {
            this.threads[i] = new RequestProcessor(String.valueOf(RequestProcessor.class.getName()) + "." + sequence++);
            this.threads[i].start();
            ++i;
        }
    }

    private void copyChild(CompositeMap data, String name, CompositeMap to_copy_from) {
        CompositeMap child = to_copy_from.getChild(name);
        if (child != null) {
            data.addChild((CompositeMap)child.clone());
        }
    }

    @Override
    public int onServiceFinish(IService service) throws Exception {
        Throwable thr;
        ++this.requestCount;
        ServiceContext ctx = service.getServiceContext();
        CompositeMap context = ctx.getObjectContext();
        if (context.getChild("request") == null) {
            return 0;
        }
        CompositeMap request_data = (CompositeMap)context.getChild("request").clone();
        boolean is_success = ctx.isSuccess() && !ctx.hasError();
        request_data.put("success", (Object)is_success);
        int i = 0;
        while (i < this.nodeToSaveArray.length) {
            this.copyChild(request_data, this.nodeToSaveArray[i], context);
            ++i;
        }
        HttpServletRequest request = ((HttpServiceInstance)service).getRequest();
        request_data.put("query_string", request.getQueryString());
        StackTraceManager stm = ctx.getStackTraceManager();
        if (stm != null) {
            CompositeMap trace_data;
            TraceElement trace = stm.getRootNode();
            if (trace != null && this.saveDetail && (trace_data = trace.asCompositeMap(true, true)) != null && trace_data.getChilds() != null && trace_data.getChilds().size() > 0) {
                trace_data.setName("detail");
                request_data.addChild(trace_data);
            }
            request_data.put("enter_time", new Timestamp(trace.getEnterTime()));
            request_data.put("exit_time", new Timestamp(trace.getExitTime()));
            request_data.put("duration", (Object)trace.getDuration());
        }
        if ((thr = ctx.getException()) == null) {
            thr = ctx.getLastHandledException();
        }
        if (thr != null) {
            String context_dump = context.toXML();
            request_data.put(KEY_CONTEXT_DUMP, context_dump);
            RuntimeContext.getInstance(request_data).setException(thr);
        }
        this.recordQueue.offer(request_data);
        return 0;
    }

    public void shutdown() {
        this.isRunning = false;
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i] != null && this.threads[i].isAlive()) {
                this.threads[i].interrupt();
            }
            ++i;
        }
    }

    public void onShutdown() {
        this.shutdown();
    }

    @Override
    public int getCurrentQueueSize() {
        return this.recordQueue.size();
    }

    @Override
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @Override
    public Date getMaxQueueSizeTime() {
        return this.maxQueueTime;
    }

    @Override
    public long getRequestCount() {
        return this.requestCount;
    }

    @Override
    public long getProcessedCount() {
        return this.processedCount;
    }

    @Override
    public long getTotalProcessTime() {
        return this.processTime;
    }

    @Override
    public double getAverageProcessTime() {
        return (double)this.processTime / (double)this.processedCount;
    }

    @Override
    public void registerMBean(IMBeanRegister register, IMBeanNameProvider name_provider) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String name = name_provider.getMBeanName("Application", "name=RequestRecorder");
        register.register(name, this);
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public long getConnectionIdleTime() {
        return this.connectionIdleTime;
    }

    public void setConnectionIdleTime(long connectionIdleTime) {
        this.connectionIdleTime = connectionIdleTime;
    }

    public String getRequestSaveBm() {
        return this.requestSaveBm;
    }

    public void setRequestSaveBm(String requestSaveBm) {
        this.requestSaveBm = requestSaveBm;
    }

    public boolean isSaveDetail() {
        return this.saveDetail;
    }

    public void setSaveDetail(boolean saveDetail) {
        this.saveDetail = saveDetail;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public class RequestProcessor
    extends Thread {
        public static final String KEY_INSERT = "insert";
        public static final String KEY_STATUS = "_status";
        public static final String KEY_DETAIL = "detail";
        long idleTime;
        Connection conn;
        ModelBatchUpdate batchSaveService;

        public RequestProcessor(String name) {
            super(name);
            this.idleTime = 0L;
            this.conn = null;
            this.batchSaveService = new ModelBatchUpdate(RequestRecorder.this.mDbFactory, RequestRecorder.this.mOcManager, RequestRecorder.this.mObjectReg);
            this.batchSaveService.setModel(RequestRecorder.this.requestSaveBm);
        }

        private void processRequestClientInfo(CompositeMap data) {
            String agent = data.getString("user-agent");
            if (agent != null) {
                String[] browsers = UserAgentTools.getBrowser(agent);
                data.put("client_browser_family", browsers[0]);
                data.put("client_browser", browsers[1]);
                data.put("client_browser_version", browsers[2]);
                String[] os = UserAgentTools.getOS(agent);
                data.put("client_os_family", os[0]);
                data.put("client_os", os[1]);
                data.put("client_os_version", os[2]);
                String p = UserAgentTools.getUserPlatform(agent);
                if (p != null) {
                    data.put("client_platform", p);
                }
            }
        }

        private Throwable getRootCause(Throwable exception) {
            Throwable cause = exception.getCause();
            if (cause == null) {
                return exception;
            }
            return this.getRootCause(cause);
        }

        private void processException(Throwable thr, CompositeMap data) {
            CompositeMap item = new CompositeMap("exception");
            item.put(KEY_STATUS, KEY_INSERT);
            item.put("exception_type", thr.getClass().getCanonicalName());
            item.put("exception_message", thr.getMessage());
            item.put("full_stack_trace", StackTraceUtil.toString(thr));
            item.put(RequestRecorder.KEY_CONTEXT_DUMP, data.get(RequestRecorder.KEY_CONTEXT_DUMP));
            data.remove(RequestRecorder.KEY_CONTEXT_DUMP);
            Throwable cause = this.getRootCause(thr);
            if (cause != null && cause != thr) {
                item.put("root_stack_trace", StackTraceUtil.toString(cause));
            }
            data.createChild("exceptions").addChild(item);
        }

        private void processRequestData(CompositeMap data) {
            Throwable thr;
            data.put(KEY_STATUS, KEY_INSERT);
            CompositeMap detail = data.getChild(KEY_DETAIL);
            if (detail != null) {
                int id = 1;
                Iterator it = detail.getChildIterator();
                while (it != null && it.hasNext()) {
                    CompositeMap item = (CompositeMap)it.next();
                    item.put(KEY_STATUS, KEY_INSERT);
                    item.put("sequence_num", (Object)id);
                    ++id;
                }
            }
            if ((thr = (Throwable)data.get("__exception__")) == null) {
                thr = (Throwable)data.get("__last_handled_exception__");
            }
            if (thr != null) {
                this.processException(thr, data);
            }
            this.processRequestClientInfo(data);
        }

        private void commitConnection(Connection conn, ILogger logger) {
            try {
                if (conn != null & !conn.isClosed()) {
                    conn.commit();
                }
            }
            catch (SQLException ex) {
                logger.log(Level.WARNING, "Error when commiting connection", ex);
            }
        }

        void createConnection() throws SQLException {
            this.conn = RequestRecorder.this.mDataSource.getConnection();
            this.conn.setAutoCommit(false);
        }

        void checkConnection() throws SQLException {
            if (this.conn == null) {
                this.createConnection();
            }
            if (this.conn != null && this.conn.isClosed()) {
                DBUtil.closeConnection(this.conn);
                this.createConnection();
            }
        }

        private int pollData(CompositeMap[] data_array) {
            int i = 0;
            while (i < RequestRecorder.this.batchSize) {
                CompositeMap data = RequestRecorder.this.recordQueue.poll();
                if (data == null) break;
                this.processRequestData(data);
                data_array[i] = data;
                ++i;
            }
            return i;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        if (!RequestRecorder.this.isRunning) {
                            return;
                        }
                        CompositeMap[] datas = new CompositeMap[RequestRecorder.this.batchSize];
                        int num = this.pollData(datas);
                        if (num == 0) {
                            try {
                                RequestProcessor.sleep(RequestRecorder.this.checkInterval);
                                this.idleTime += (long)RequestRecorder.this.checkInterval;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this.conn == null || this.idleTime <= RequestRecorder.this.connectionIdleTime) continue;
                            DBUtil.closeConnection(this.conn);
                            this.conn = null;
                            continue;
                        }
                        long time = System.currentTimeMillis();
                        this.idleTime = 0L;
                        int size = RequestRecorder.this.getCurrentQueueSize() + num;
                        if (size > RequestRecorder.this.maxQueueSize) {
                            RequestRecorder.this.maxQueueSize = size;
                            RequestRecorder.this.maxQueueTime = new Date();
                        }
                        try {
                            this.checkConnection();
                        }
                        catch (SQLException ex) {
                            RequestRecorder.this.mLogger.log(Level.WARNING, "Error when getting connection for request log", ex);
                            RequestRecorder.this.mLogger.log(Level.WARNING, "Total " + num + "Request info will be discarded:");
                            continue;
                        }
                        CompositeMap context = new CompositeMap("context");
                        SqlServiceContext sqlctx = SqlServiceContext.createSqlServiceContext(context);
                        sqlctx.setConnection(this.conn);
                        CompositeMap params = sqlctx.getParameter();
                        int i = 0;
                        while (true) {
                            if (i >= num) {
                                try {
                                    this.batchSaveService.doBatchUpdate(params.getChilds(), context);
                                    this.commitConnection(this.conn, RequestRecorder.this.mLogger);
                                }
                                catch (Exception ex) {
                                    RequestRecorder.this.mLogger.log(Level.WARNING, "Can't save request data", ex);
                                }
                                break;
                            }
                            params.addChild(datas[i]);
                            ++i;
                        }
                        context.clear();
                        time = System.currentTimeMillis() - time;
                        RequestRecorder.this.processTime += time;
                        RequestRecorder.this.processedCount += (long)num;
                    }
                }
                catch (Throwable thr) {
                    RequestRecorder.this.mLogger.log(Level.SEVERE, "Error in request record thread", thr);
                    if (this.conn == null) return;
                    DBUtil.closeConnection(this.conn);
                    return;
                }
            }
            finally {
                if (this.conn != null) {
                    DBUtil.closeConnection(this.conn);
                }
            }
        }
    }
}

