/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.database.DBUtil;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.datasource.DataSourceConfig;
import aurora.presentation.component.std.IDGenerator;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import uncertain.composite.CompositeMap;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class AttachmentManager
extends AbstractEntry {
    public static final String VERSION = "$Revision: 8447 $";
    public static final String PROPERTITY_ACTION_TYPE = "actiontype";
    public static final String PROPERTITY_SAVE_TYPE = "savetype";
    public static final String PROPERTITY_SAVE_PATH = "savepath";
    public static final String PROPERTITY_URL = "url";
    public static final String PROPERTITY_RANDOM_NAME = "random_name";
    private static final String SAVE_TYPE_DATABASE = "db";
    private static final String SAVE_TYPE_FILE = "file";
    public int Buffer_size = 512000;
    private static final String FND_UPLOAD_FILE_TYPE = "fnd.fnd_upload_file_type";
    private String fileType = "*.*";
    private String fileSize = "";
    private String saveType;
    private String savePath;
    private String actionType;
    private String useSubFolder = null;
    private String randomName = "true";
    private String dataSourcename = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
    private DatabaseServiceFactory databasefactory;
    IObjectRegistry registry;

    public AttachmentManager(IObjectRegistry registry) {
        this.registry = registry;
        this.databasefactory = (DatabaseServiceFactory)registry.getInstanceOfType(DatabaseServiceFactory.class);
    }

    public Connection getContextConnection(CompositeMap context) throws SQLException {
        if (context == null) {
            throw new IllegalStateException("Can not get context from ServiceThreadLocal!");
        }
        SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext(context);
        Connection conn = sqlServiceContext.getNamedConnection(null);
        if (conn == null) {
            sqlServiceContext.initConnection(this.registry, null);
            conn = sqlServiceContext.getNamedConnection(null);
        }
        return conn;
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        block4: {
            String actionType;
            CompositeMap context;
            block6: {
                block5: {
                    block3: {
                        context = runner.getContext();
                        actionType = this.getActionType();
                        if (!"upload".equalsIgnoreCase(actionType)) break block3;
                        this.doUpload(context);
                        ProcedureRunner preRunner = runner;
                        while (preRunner.getCaller() != null) {
                            preRunner = preRunner.getCaller();
                            preRunner.stop();
                        }
                        break block4;
                    }
                    if (!"update".equalsIgnoreCase(actionType)) break block5;
                    this.doUpdate(context);
                    ProcedureRunner preRunner = runner;
                    while (preRunner.getCaller() != null) {
                        preRunner = preRunner.getCaller();
                        preRunner.stop();
                    }
                    break block4;
                }
                if (!"delete".equalsIgnoreCase(actionType)) break block6;
                this.doDelete(context);
                break block4;
            }
            if (!"download".equalsIgnoreCase(actionType)) break block4;
            this.doDownload(context);
            ProcedureRunner preRunner = runner;
            while (preRunner.getCaller() != null) {
                preRunner = preRunner.getCaller();
                preRunner.stop();
            }
        }
    }

    private void doDownload(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        Object aid = params.getObject("@attachment_id");
        if (aid != null) {
            Connection conn = this.getContextConnection(context);
            PreparedStatement pst = null;
            ResultSet rs = null;
            InputStream is = null;
            OutputStream os = null;
            ReadableByteChannel rbc = null;
            WritableByteChannel wbc = null;
            try {
                pst = conn.prepareStatement("select file_name,file_size,mime_type, file_path, content from fnd_atm_attachment t where t.attachment_id = ?");
                pst.setObject(1, aid);
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                String path = rs.getString(4);
                String fileName = rs.getString(1);
                int fileSize = rs.getInt(2);
                String mimeType = rs.getString(3);
                HttpServletResponse response = serviceInstance.getResponse();
                response.setHeader("cache-control", "must-revalidate");
                response.setHeader("pragma", "public");
                response.setHeader("Content-Type", mimeType);
                response.setHeader("Content-disposition", "attachment;" + this.processFileName(serviceInstance.getRequest(), fileName));
                try {
                    Class.forName("org.apache.catalina.startup.Bootstrap");
                    if (fileSize > 0) {
                        response.setContentLength(fileSize);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (path != null) {
                    File file = new File(path);
                    if (file.exists()) {
                        os = response.getOutputStream();
                        is = new FileInputStream(path);
                        rbc = Channels.newChannel(is);
                        wbc = Channels.newChannel(os);
                        ByteBuffer buf = ByteBuffer.allocate(this.Buffer_size);
                        int size = -1;
                        while ((size = rbc.read(buf)) > 0) {
                            buf.flip();
                            wbc.write(buf);
                            buf.compact();
                            os.flush();
                        }
                    }
                } else {
                    Blob content = rs.getBlob(5);
                    if (content != null) {
                        os = response.getOutputStream();
                        is = content.getBinaryStream();
                        rbc = Channels.newChannel(is);
                        wbc = Channels.newChannel(os);
                        ByteBuffer buf = ByteBuffer.allocate(this.Buffer_size);
                        int size = -1;
                        while ((size = rbc.read(buf)) > 0) {
                            buf.flip();
                            wbc.write(buf);
                            buf.compact();
                            os.flush();
                        }
                    }
                }
                response.setHeader("Connection", "close");
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(pst);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(pst);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doDelete(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        Object aid = serviceInstance.getRequest().getAttribute("attachment_id");
        if (aid == null) {
            aid = params.getObject("/parameter/record/@attachment_id");
        }
        if (aid != null && !"".equals(aid)) {
            Connection conn = this.getContextConnection(context);
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                File file;
                pst = conn.prepareStatement("select file_path from fnd_atm_attachment t where t.attachment_id = ?");
                pst.setObject(1, aid);
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                String path = rs.getString(1);
                if (path != null && (file = new File(path)).exists()) {
                    file.delete();
                }
                pst = conn.prepareStatement("delete from fnd_atm_attachment at where at.attachment_id = ?");
                pst.setObject(1, aid);
                pst.execute();
                pst = conn.prepareStatement("delete from fnd_atm_attachment_multi atm where atm.attachment_id = ?");
                pst.setObject(1, aid);
                pst.execute();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(pst);
                throw throwable;
            }
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(pst);
        }
    }

    private void doUpdate(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        Object aid = params.getObject("@attachment_id");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        List items = up.parseRequest(serviceInstance.getRequest());
        FileItem fileItem = null;
        for (FileItem fi : items) {
            if (fi.isFormField()) continue;
            fileItem = fi;
        }
        if (aid != null && !"".equals(aid)) {
            Connection conn = this.getContextConnection(context);
            PreparedStatement pst = null;
            ResultSet rs = null;
            String path = null;
            try {
                pst = conn.prepareStatement("select file_path from fnd_atm_attachment t where t.attachment_id = ?");
                pst.setObject(1, aid);
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                path = rs.getString(1);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement(pst);
                throw throwable;
            }
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(pst);
            if (path != null) {
                File delFile = new File(path);
                if (delFile.exists()) {
                    delFile.delete();
                }
                if (fileItem != null) {
                    long size = 0L;
                    FileOutputStream fos = null;
                    InputStream ins = null;
                    try {
                        int b;
                        fos = new FileOutputStream(delFile);
                        ins = fileItem.getInputStream();
                        while ((b = ins.read()) >= 0) {
                            fos.write(b);
                            ++size;
                        }
                        pst = conn.prepareStatement("update fnd_atm_attachment a set a.file_size = ? where a.attachment_id = ?");
                        pst.setObject(1, size);
                        pst.setObject(2, aid);
                        pst.executeUpdate();
                    }
                    finally {
                        if (ins != null) {
                            ins.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        DBUtil.closeStatement(pst);
                    }
                }
            } else {
                DataSourceConfig dataSourceConfig = (DataSourceConfig)this.registry.getInstanceOfType(DataSourceConfig.class);
                Connection nativeConn = dataSourceConfig.getNativeJdbcExtractor(conn);
                long size = 0L;
                InputStream instream = fileItem.getInputStream();
                OutputStream outstream = null;
                try {
                    int le;
                    pst = nativeConn.prepareStatement("update fnd_atm_attachment t set t.content = empty_blob() where t.attachment_id= ?");
                    pst.setObject(1, aid);
                    pst.executeUpdate();
                    pst = nativeConn.prepareStatement("select content from fnd_atm_attachment t where t.attachment_id = ? for update");
                    pst.setObject(1, aid);
                    rs = pst.executeQuery();
                    if (!rs.next()) {
                        throw new IllegalArgumentException("attachment_id not set");
                    }
                    BLOB blob = ((OracleResultSet)rs).getBLOB(1);
                    rs.close();
                    if (blob == null) {
                        throw new IllegalArgumentException("Warning: can't update fnd_atm_attachment.content for recrd " + aid);
                    }
                    outstream = blob.getBinaryOutputStream(0L);
                    int chunk = blob.getChunkSize();
                    byte[] buff = new byte[chunk];
                    while ((le = instream.read(buff)) != -1) {
                        outstream.write(buff, 0, le);
                        size += (long)le;
                    }
                    pst = nativeConn.prepareStatement("update fnd_atm_attachment a set a.file_size = ? where a.attachment_id = ?");
                    pst.setObject(1, size);
                    pst.setObject(2, aid);
                    pst.executeUpdate();
                }
                finally {
                    if (outstream != null) {
                        outstream.close();
                    }
                    if (instream != null) {
                        instream.close();
                    }
                    DBUtil.closeResultSet(rs);
                    DBUtil.closeStatement(pst);
                }
            }
        }
    }

    private void doUpload(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        List items = null;
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        Connection conn = null;
        String url = null;
        try {
            items = up.parseRequest(serviceInstance.getRequest());
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    String name = fileItem.getFieldName();
                    String value = fileItem.getString("UTF-8");
                    if (PROPERTITY_URL.equalsIgnoreCase(name)) {
                        url = value;
                        continue;
                    }
                    if (PROPERTITY_ACTION_TYPE.equalsIgnoreCase(name)) {
                        this.actionType = value;
                        continue;
                    }
                    params.put(name, value);
                    if (!"attachment_id".equalsIgnoreCase(name)) continue;
                    serviceInstance.getRequest().setAttribute("attachment_id", (Object)value);
                    continue;
                }
                List<String> fts = Arrays.asList(this.getFileType().split(";"));
                List<String> fsz = Arrays.asList(this.getFileSize().split(";"));
                String name = fileItem.getName().toLowerCase();
                String ft = name.substring(name.lastIndexOf(".") + 1, name.length());
                int index = fts.indexOf("*." + ft);
                if ("*.*".equals(this.getFileType()) || index != -1) {
                    String fl = "";
                    if (fsz.size() != fts.size()) {
                        fl = fsz.get(0);
                    } else if (index != -1) {
                        fl = fsz.get(index);
                    }
                    if (!"".equals(fl) && fileItem.getSize() > (long)(1024 * Integer.valueOf(fl))) {
                        throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u8d85\u51fa\u5927\u5c0f\u9650\u5236!");
                    }
                    files.add(fileItem);
                    continue;
                }
                throw new Exception("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d!\u53ea\u5141\u8bb8 " + fts);
            }
            for (FileItem fileItem : files) {
                File file = new File(fileItem.getName());
                String file_name = file.getName();
                if ("".equals(file_name)) continue;
                params.put("file_name", file_name);
                params.put("file_size", new Long(fileItem.getSize()));
                BusinessModelService modelService = this.databasefactory.getModelService(FND_UPLOAD_FILE_TYPE, context);
                modelService.execute(null);
                Object aid = service.getModel().getObject("/parameter/@attachment_id");
                conn = this.getContextConnection(context);
                InputStream in = fileItem.getInputStream();
                String attach_id = aid.toString();
                if (SAVE_TYPE_DATABASE.equalsIgnoreCase(this.getSaveType())) {
                    this.writeBLOB(conn, in, attach_id);
                } else if (SAVE_TYPE_FILE.equalsIgnoreCase(this.getSaveType())) {
                    this.writeFile(conn, in, attach_id, file_name);
                }
                fileItem.delete();
                params.put("success", "true");
                if (url != null) continue;
                PrintWriter out = serviceInstance.getResponse().getWriter();
                out.write(aid.toString());
                out.close();
            }
            if (url != null) {
                serviceInstance.getResponse().sendRedirect(url);
            }
        }
        catch (Exception ex) {
            LoggingContext.getLogger(context, AttachmentManager.class.getCanonicalName()).log(ex.getMessage());
            throw ex;
        }
    }

    private void writeFile(Connection conn, InputStream instream, String aid, String fileName) throws Exception {
        if ("".equals(fileName)) {
            return;
        }
        if ("true".equals(this.getRandomName())) {
            fileName = IDGenerator.getInstance().generate();
        }
        String datePath = this.sdf.format(new Date());
        String path = this.getSavePath().replaceAll("\\\\", "/");
        if (path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + "/";
        }
        if ("true".equalsIgnoreCase(this.getUseSubFolder())) {
            path = String.valueOf(path) + datePath;
        }
        FileUtils.forceMkdir((File)new File(path));
        PreparedStatement pst = null;
        try {
            int b;
            long size = 0L;
            File file = new File(path, fileName);
            FileOutputStream fos = new FileOutputStream(file);
            while ((b = instream.read()) >= 0) {
                fos.write(b);
                ++size;
            }
            fos.close();
            pst = conn.prepareStatement("update fnd_atm_attachment a set a.file_path = ? where a.attachment_id = ?");
            pst.setObject(1, file.getPath());
            pst.setObject(2, aid);
            pst.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.closeStatement(pst);
            throw throwable;
        }
        DBUtil.closeStatement(pst);
    }

    private long writeBLOB(Connection conn, InputStream instream, String aid) throws Exception {
        long l;
        BLOB blob;
        OutputStream outstream;
        ResultSet rs;
        PreparedStatement pst;
        long size;
        block6: {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            DataSourceConfig dataSourceConfig = (DataSourceConfig)this.registry.getInstanceOfType(DataSourceConfig.class);
            Connection nativeConn = dataSourceConfig.getNativeJdbcExtractor(conn);
            size = 0L;
            pst = null;
            rs = null;
            outstream = null;
            pst = nativeConn.prepareStatement("update fnd_atm_attachment t set t.content = empty_blob() where t.attachment_id=?");
            pst.setObject(1, aid);
            pst.executeUpdate();
            pst = nativeConn.prepareStatement("select content from fnd_atm_attachment t where t.attachment_id = ? for update");
            pst.setObject(1, aid);
            rs = pst.executeQuery();
            if (!rs.next()) {
                throw new IllegalArgumentException("attachment_id not set");
            }
            blob = ((OracleResultSet)rs).getBLOB(1);
            rs.close();
            if (blob != null) break block6;
            System.out.println("Warning: can't update fnd_atm_attachment.content for recrd " + aid);
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(pst);
            return 0L;
        }
        try {
            int le;
            outstream = blob.getBinaryOutputStream(0L);
            int chunk = blob.getChunkSize();
            byte[] buff = new byte[chunk];
            while ((le = instream.read(buff)) != -1) {
                outstream.write(buff, 0, le);
                size += (long)le;
            }
            outstream.close();
            instream.close();
            l = size;
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(pst);
            throw throwable;
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(pst);
        return l;
    }

    public String getSaveType() {
        return this.saveType == null ? SAVE_TYPE_DATABASE : this.saveType;
    }

    public void setSaveType(String saveType) {
        this.saveType = saveType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getSavePath() {
        return this.savePath == null ? "." : this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public String getActionType() {
        return this.actionType == null ? "upload" : this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String processFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent");
        String new_filename = URLEncoder.encode(filename, "UTF8");
        String rtn = "filename=\"" + new_filename + "\"";
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).indexOf("msie") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("gb2312"), "iso-8859-1") + "\"";
            } else if (userAgent.indexOf("opera") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            } else if (userAgent.indexOf("safari") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("UTF-8"), "ISO8859-1") + "\"";
            } else if (userAgent.indexOf("applewebkit") != -1) {
                new_filename = MimeUtility.encodeText((String)filename, (String)"UTF8", (String)"B");
                rtn = "filename=\"" + new_filename + "\"";
            } else if (userAgent.indexOf("mozilla") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            }
        }
        return rtn;
    }

    public String getUseSubFolder() {
        return this.useSubFolder == null ? "true" : this.useSubFolder;
    }

    public void setUseSubFolder(String useSubFolder) {
        this.useSubFolder = useSubFolder;
    }

    public String getRandomName() {
        return this.randomName;
    }

    public void setRandomName(String randomName) {
        this.randomName = randomName;
    }

    public String getDataSourceName() {
        return this.dataSourcename;
    }

    public void setDataSourceName(String name) {
        this.dataSourcename = name;
    }
}

