/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sso;

import aurora.application.action.HttpSessionCopy;
import aurora.application.features.HttpRequestTransfer;
import aurora.service.IService;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import aurora.service.ServiceThreadLocal;
import aurora.service.http.HttpServiceInstance;
import aurora.service.http.WebContextInit;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import uncertain.composite.CompositeMap;
import uncertain.core.IContainer;
import uncertain.event.Configuration;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class SSOLogin {
    public static final String PLUGIN = SSOLogin.class.getCanonicalName();
    public static final String DEFAULT_LOGIN_PROC = "init.auto_login";
    private String autoLoginProc;
    ServletContext context;
    IObjectRegistry objectRegistry;
    ILogger logger;

    public SSOLogin(ServletContext context) {
        this.context = context;
        this.setObjectRegistry();
        this.setLogger();
    }

    public String getAutoLoginProc() {
        if (this.autoLoginProc == null || "".equals(this.autoLoginProc)) {
            this.autoLoginProc = DEFAULT_LOGIN_PROC;
        }
        return this.autoLoginProc;
    }

    public void setAutoLoginProc(String autoLoginProc) {
        this.autoLoginProc = autoLoginProc;
    }

    public IObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public void setObjectRegistry() {
        this.objectRegistry = WebContextInit.getUncertainEngine((ServletContext)this.context).getObjectRegistry();
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger() {
        this.logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.getObjectRegistry());
    }

    public void doLogin(HttpServletRequest request, HttpServletResponse response, String loginName) throws IllegalAccessException {
        IProcedureManager procedureManager = (IProcedureManager)this.getObjectRegistry().getInstanceOfType(IProcedureManager.class);
        IServiceFactory serviceFactory = (IServiceFactory)this.getObjectRegistry().getInstanceOfType(IServiceFactory.class);
        Procedure proc = procedureManager.loadProcedure(this.getAutoLoginProc());
        CompositeMap auroraContext = new CompositeMap("sso_conext");
        auroraContext.createChild("parameter").put((Object)"user_name", (Object)loginName);
        HttpServiceInstance svc = this.createHttpService(this.autoLoginProc, request, response, procedureManager, auroraContext);
        ServiceThreadLocal.setCurrentThreadContext((CompositeMap)auroraContext);
        try {
            ServiceInvoker.invokeProcedureWithTransaction((String)this.autoLoginProc, (Procedure)proc, (IServiceFactory)serviceFactory, (IService)svc, (CompositeMap)auroraContext);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "***loginName:" + loginName + "***" + e.getMessage(), (Throwable)e);
            throw new IllegalAccessException(e.getMessage());
        }
        ServiceThreadLocal.setCurrentThreadContext((CompositeMap)auroraContext);
        HttpRequestTransfer.copyRequest((HttpServiceInstance)svc);
        HttpSessionCopy.copySession((CompositeMap)auroraContext, (HttpSession)request.getSession(false));
    }

    public HttpServiceInstance createHttpService(String service_name, HttpServletRequest request, HttpServletResponse response, IProcedureManager procedureManager, CompositeMap context) {
        HttpServiceInstance svc = new HttpServiceInstance(service_name, procedureManager);
        svc.setRequest(request);
        svc.setResponse(response);
        svc.setContextMap(context);
        svc.setName(service_name);
        HttpRequestTransfer.copyRequest((HttpServiceInstance)svc);
        HttpSessionCopy.copySession((CompositeMap)svc.getContextMap(), (HttpSession)request.getSession(false));
        IContainer container = (IContainer)this.getObjectRegistry().getInstanceOfType(IContainer.class);
        Configuration config = (Configuration)container.getEventDispatcher();
        if (config != null) {
            svc.setRootConfig(config);
        }
        return svc;
    }
}

