/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

import aurora.plugin.spnego.Base64;
import aurora.plugin.spnego.SpnegoAuthScheme;
import aurora.plugin.spnego.SpnegoConfig;
import aurora.plugin.spnego.SpnegoHttpServletResponse;
import aurora.plugin.spnego.SpnegoPrincipal;
import aurora.plugin.spnego.SpnegoProvider;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class SpnegoAuthenticator {
    private static final Lock LOCK = new ReentrantLock();
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private final transient boolean allowBasic;
    private final transient boolean allowDelegation;
    private final transient boolean allowLocalhost;
    private final transient boolean allowUnsecure;
    private final transient boolean promptIfNtlm;
    private final transient String clientModuleName;
    private final transient LoginContext loginContext;
    private final transient GSSCredential serverCredentials;
    private final transient KerberosPrincipal serverPrincipal;

    public SpnegoAuthenticator(SpnegoConfig config) throws LoginException, GSSException, PrivilegedActionException {
        this.allowBasic = config.getAllowBasic();
        this.allowUnsecure = config.getAllowUnsecure();
        this.clientModuleName = config.getClientModuleName();
        this.allowLocalhost = config.getAllowLocalhost();
        this.promptIfNtlm = config.getPromptIfNtlm();
        this.allowDelegation = config.getAllowDelegation();
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(config.getUsername(), config.getPassword());
        this.loginContext = new LoginContext(config.getServerModuleName(), handler);
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(this.serverCredentials.getName().toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpnegoPrincipal authenticate(HttpServletRequest req, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        boolean basicSupported = this.allowBasic && (this.allowUnsecure || req.isSecure());
        String serverRealm = this.serverPrincipal.getRealm();
        if (this.allowLocalhost && this.isLocalhost(req)) {
            return this.doLocalhost();
        }
        SpnegoAuthScheme scheme = SpnegoProvider.negotiate(req, resp, basicSupported, this.promptIfNtlm, serverRealm);
        if (scheme == null) {
            return null;
        }
        if (scheme.isNegotiateScheme()) {
            return this.doSpnegoAuth(scheme, resp);
        }
        if (!scheme.isBasicScheme()) throw new UnsupportedOperationException("scheme=" + scheme);
        if (!basicSupported) throw new UnsupportedOperationException("Basic Auth not allowed or SSL required.");
        return this.doBasicAuth(scheme, resp);
    }

    public void dispose() {
        if (this.serverCredentials != null) {
            try {
                this.serverCredentials.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
    }

    private SpnegoPrincipal doBasicAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws IOException {
        byte[] data = scheme.getToken();
        if (data.length == 0) {
            return null;
        }
        String[] basicData = new String(data).split(":", 2);
        if (basicData.length != 2) {
            throw new IllegalArgumentException("Username/Password may have contained an invalid character. basicData.length=" + basicData.length);
        }
        String username = basicData[0].substring(basicData[0].indexOf(92) + 1);
        String password = basicData[1];
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        SpnegoPrincipal principal = null;
        try {
            if (username == null || username.isEmpty()) {
                throw new LoginException("Username is required.");
            }
            LoginContext cntxt = new LoginContext(this.clientModuleName, handler);
            cntxt.login();
            cntxt.logout();
            principal = new SpnegoPrincipal(String.valueOf(username) + '@' + this.serverPrincipal.getRealm(), 1);
        }
        catch (LoginException le) {
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.serverPrincipal.getRealm() + '\"');
            resp.setStatus(401, true);
        }
        return principal;
    }

    private SpnegoPrincipal doLocalhost() {
        String username = System.getProperty("user.name");
        if (username == null || username.isEmpty()) {
            return new SpnegoPrincipal(String.valueOf(this.serverPrincipal.getName()) + '@' + this.serverPrincipal.getRealm(), this.serverPrincipal.getNameType());
        }
        return new SpnegoPrincipal(String.valueOf(username) + '@' + this.serverPrincipal.getRealm(), 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SpnegoPrincipal doSpnegoAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        byte[] gss = scheme.getToken();
        if (gss.length == 0) {
            return null;
        }
        GSSContext context = null;
        GSSCredential delegCred = null;
        try {
            byte[] token = null;
            LOCK.lock();
            try {
                context = MANAGER.createContext(this.serverCredentials);
                token = context.acceptSecContext(gss, 0, gss.length);
            }
            finally {
                LOCK.unlock();
            }
            if (token == null) {
                return null;
            }
            resp.setHeader("WWW-Authenticate", "Negotiate " + Base64.encode(token));
            if (!context.isEstablished()) {
                resp.setStatus(401, true);
                return null;
            }
            String principal = context.getSrcName().toString();
            if (!this.allowDelegation || !context.getCredDelegState()) return new SpnegoPrincipal(principal, 1, delegCred);
            delegCred = context.getDelegCred();
            return new SpnegoPrincipal(principal, 1, delegCred);
        }
        finally {
            if (context != null) {
                LOCK.lock();
                try {
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
    }

    private boolean isLocalhost(HttpServletRequest req) {
        return req.getLocalAddr().equals(req.getRemoteAddr());
    }
}

