/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model.properties;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.properties.ComponentInnerProperties;
import aurora.plugin.source.gen.screen.model.properties.ComponentProperties;
import aurora.plugin.source.gen.screen.model.properties.DefaultPropertyDescriptor;
import aurora.plugin.source.gen.screen.model.properties.IPropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class PropertyFactory
implements ComponentInnerProperties,
ComponentProperties {
    private static final Map<String, Integer> styleMap = new HashMap<String, Integer>();
    private static final Map<String, DefaultPropertyDescriptor[]> propertyMap = new HashMap<String, DefaultPropertyDescriptor[]>();

    static {
        styleMap.put("simple", 2);
        styleMap.put("reference", 4);
        styleMap.put("containment", 8);
        styleMap.put("list", 16);
        styleMap.put("array", 32);
        styleMap.put("editable", 64);
        styleMap.put("save", 128);
        styleMap.put("inner", 256);
        styleMap.put("_boolean", 512);
        styleMap.put("_int", 1024);
        styleMap.put("_float", 2048);
        styleMap.put("_cdata", 4096);
        styleMap.put("_string", 8192);
        CompositeMap map = PropertyFactory.loadXML();
        PropertyFactory.parseComponent(map);
    }

    public IPropertyDescriptor[] createPropertyDescriptors(AuroraComponent component) {
        return this.createPropertyDescriptors(component.getComponentType());
    }

    private IPropertyDescriptor[] createPropertyDescriptors(String componentType) {
        DefaultPropertyDescriptor[] defaultPropertyDescriptors = propertyMap.get(componentType.toLowerCase());
        return defaultPropertyDescriptors == null ? new IPropertyDescriptor[]{} : defaultPropertyDescriptors;
    }

    private static void parseComponent(CompositeMap map) {
        List childsNotNull = map.getChildsNotNull();
        for (Object object : childsNotNull) {
            String[] split;
            String types;
            if (!(object instanceof CompositeMap) || "".equals(types = ((CompositeMap)object).getString((Object)"type", ""))) continue;
            DefaultPropertyDescriptor[] parseProperty = PropertyFactory.parseProperty((CompositeMap)object);
            String[] stringArray = split = types.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                propertyMap.put(type.toLowerCase(), parseProperty);
                ++n2;
            }
        }
    }

    private static DefaultPropertyDescriptor[] parseProperty(CompositeMap map) {
        List childsNotNull = map.getChildsNotNull();
        ArrayList<DefaultPropertyDescriptor> result = new ArrayList<DefaultPropertyDescriptor>();
        for (Object o : childsNotNull) {
            if (!(o instanceof CompositeMap)) continue;
            String id = ((CompositeMap)o).getString((Object)"id", "");
            String style = ((CompositeMap)o).getString((Object)"style", "");
            String dv = ((CompositeMap)o).getString((Object)"defaultValue", "");
            int s = PropertyFactory.getStyle(style);
            if ("".equals(id) || s == 0) continue;
            DefaultPropertyDescriptor e = new DefaultPropertyDescriptor(id, s);
            e.setDefaultValue(dv);
            result.add(e);
        }
        return result.toArray(new DefaultPropertyDescriptor[result.size()]);
    }

    private static int getStyle(String styles) {
        String[] split = styles.split(",");
        int i = 0;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Integer integer = styleMap.get(s);
            if (integer != null) {
                i |= integer.intValue();
            }
            ++n2;
        }
        return i;
    }

    private static CompositeMap loadXML() {
        InputStream is = null;
        try {
            CompositeMap rootMap;
            is = PropertyFactory.class.getResourceAsStream("components.xml");
            CompositeLoader parser = new CompositeLoader();
            CompositeMap compositeMap = rootMap = parser.loadFromStream(is);
            return compositeMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new CompositeMap();
    }
}

