/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model.asm;

import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Grid;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.Renderer;
import aurora.plugin.source.gen.screen.model.asm.AbstractModelCreator;
import aurora.plugin.source.gen.screen.model.asm.PageGenerator;
import java.util.List;
import uncertain.composite.CompositeMap;

public class GridCreator
extends AbstractModelCreator {
    public GridCreator(DatabaseServiceFactory svcFactory, CompositeMap context) {
        super(svcFactory, context);
    }

    @Override
    public void decorateComponent(AuroraComponent com, CompositeMap gridPart) throws Exception {
        Grid grid = (Grid)com;
        try {
            CompositeMap gridMap = this.getGridMap(gridPart.get((Object)"part_id"));
            grid.getDataset().setModel(this.getEntityModelPath(gridMap.get((Object)"entity_id")));
            grid.setSize(gridMap.getInt((Object)"width", grid.getSize().x), gridMap.getInt((Object)"height", grid.getSize().y));
            CompositeMap columnMap = this.getGridColumns(gridPart.get((Object)"part_id"));
            List columndList = columnMap.getChildsNotNull();
            for (CompositeMap m : columndList) {
                GridColumn gc = new GridColumn();
                String editor = GridCreator.getNormalComponentType(m.getString((Object)"editor"));
                if (this.isViewPage() && ("comboBox".equals(editor) || "lov".equals(editor))) {
                    gc.setEditor("comboBox");
                } else if (!this.isViewPage()) {
                    gc.setEditor(editor);
                }
                if ("datePicker".equals(editor) || "dateTimePicker".equals(editor)) {
                    Renderer r = this.getRenderer(editor);
                    gc.setRenderer(r);
                }
                gc.setSize(m.getInt((Object)"width"), gc.getSize().y);
                gc.setPrompt(m.getString((Object)"prompt"));
                gc.setName(m.getString((Object)"name"));
                grid.addChild(gc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        grid.setNavbarType("complex");
    }

    @Override
    public AuroraComponent create(CompositeMap gridPart) throws Exception {
        Grid grid = new Grid();
        this.decorateComponent(grid, gridPart);
        return grid;
    }

    private CompositeMap getGridMap(Object gridId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"custom_grid_id", gridId);
        return PageGenerator.queryFirst(this.getDatabaseServiceFactory(), this.getContext(), "page.custom_grid_for_query", para);
    }

    private CompositeMap getGridColumns(Object gridId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"custom_grid_id", gridId);
        return PageGenerator.query(this.getDatabaseServiceFactory(), this.getContext(), "page.custom_grid_column_for_query", para);
    }
}

