/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.plugin.sharepoint.Delete;
import aurora.plugin.sharepoint.Download;
import aurora.plugin.sharepoint.SharePointConfig;
import aurora.plugin.sharepoint.SharePointFile;
import aurora.plugin.sharepoint.Upload;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class SharePointAttachmentManager
extends AbstractEntry {
    public static final String PROPERTITY_ACTION_TYPE = "actiontype";
    public static final String PROPERTITY_SAVE_TYPE = "savetype";
    public static final String PROPERTITY_URL = "url";
    public int Buffer_size = 512000;
    private static final String FND_UPLOAD_FILE_TYPE = "fnd.fnd_upload_file_type";
    private static final String ATM_URL_QUERY = "fnd.fnd_atm_attachment_query";
    private int maxSize = 0;
    private String fileType = null;
    private String actionType;
    private String useSubFolder = null;
    private String dataSourcename = null;
    private IObjectRegistry registry;
    private SharePointConfig spConfig;
    private DatabaseServiceFactory databasefactory;
    private ILogger logger;

    public SharePointAttachmentManager(IObjectRegistry registry) {
        this.registry = registry;
        this.databasefactory = (DatabaseServiceFactory)registry.getInstanceOfType(DatabaseServiceFactory.class);
        this.spConfig = (SharePointConfig)((Object)registry.getInstanceOfType(SharePointConfig.class));
        if (this.spConfig == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, SharePointConfig.class);
        }
    }

    public Connection getContextConnection(CompositeMap context) throws SQLException {
        if (context == null) {
            throw new IllegalStateException("Can not get context from ServiceThreadLocal!");
        }
        SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext((CompositeMap)context);
        Connection conn = sqlServiceContext.getNamedConnection(null);
        if (conn == null) {
            sqlServiceContext.initConnection(this.registry, null);
            conn = sqlServiceContext.getNamedConnection(null);
        }
        return conn;
    }

    public void run(ProcedureRunner runner) throws Exception {
        block4: {
            String actionType;
            CompositeMap context;
            block6: {
                block5: {
                    block3: {
                        context = runner.getContext();
                        this.logger = LoggingContext.getLogger((CompositeMap)context, (String)((Object)((Object)this)).getClass().getCanonicalName());
                        actionType = this.getActionType();
                        if (!"upload".equalsIgnoreCase(actionType)) break block3;
                        this.doUpload(context);
                        ProcedureRunner preRunner = runner;
                        while (preRunner.getCaller() != null) {
                            preRunner = preRunner.getCaller();
                            preRunner.stop();
                        }
                        break block4;
                    }
                    if (!"update".equalsIgnoreCase(actionType)) break block5;
                    this.doUpdate(context);
                    ProcedureRunner preRunner = runner;
                    while (preRunner.getCaller() != null) {
                        preRunner = preRunner.getCaller();
                        preRunner.stop();
                    }
                    break block4;
                }
                if (!"delete".equalsIgnoreCase(actionType)) break block6;
                this.doDelete(context);
                break block4;
            }
            if (!"download".equalsIgnoreCase(actionType)) break block4;
            this.doDownload(context);
            ProcedureRunner preRunner = runner;
            while (preRunner.getCaller() != null) {
                preRunner = preRunner.getCaller();
                preRunner.stop();
            }
        }
    }

    private void doDownload(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        CompositeMap params = service.getParameter();
        Object attachment_id = params.getObject("@attachment_id");
        if (attachment_id != null) {
            Connection conn = this.getContextConnection(context);
            Statement st = conn.createStatement();
            ResultSet rs = null;
            Closeable is = null;
            ServletOutputStream os = null;
            try {
                rs = st.executeQuery("select file_name,file_size,mime_type, file_path, content from fnd_atm_attachment t where t.attachment_id = " + attachment_id);
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                String fileFullPath = rs.getString(4);
                String fileName = rs.getString(1);
                int fileSize = rs.getInt(2);
                String mimeType = rs.getString(3);
                HttpServletResponse response = serviceInstance.getResponse();
                response.setHeader("cache-control", "must-revalidate");
                response.setHeader("pragma", "public");
                response.setHeader("Content-Type", mimeType);
                response.setHeader("Content-disposition", "attachment;" + this.processFileName(serviceInstance.getRequest(), fileName));
                try {
                    Class.forName("org.apache.catalina.startup.Bootstrap");
                    if (fileSize > 0) {
                        response.setContentLength(fileSize);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                Download download = new Download(this.spConfig, fileFullPath);
                byte[] fileBytes = download.execute();
                os = response.getOutputStream();
                os.write(fileBytes);
                os.flush();
                response.setHeader("Connection", "close");
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement((Statement)st);
                SharePointConfig.close(is);
                SharePointConfig.close(os);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)rs);
            DBUtil.closeStatement((Statement)st);
            SharePointConfig.close(is);
            SharePointConfig.close((Closeable)os);
        }
    }

    private void doDelete(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        CompositeMap params = service.getParameter();
        Object attachment_id = serviceInstance.getRequest().getAttribute("attachment_id");
        if (attachment_id == null) {
            attachment_id = params.getObject("/parameter/record/@attachment_id");
        }
        if (attachment_id != null && !"".equals(attachment_id)) {
            Connection conn = this.getContextConnection(context);
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                rs = st.executeQuery("select file_name,file_path from fnd_atm_attachment t where t.attachment_id = " + attachment_id);
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                String fileFullPath = rs.getString(2);
                SharePointFile spFile = new SharePointFile(this.spConfig, fileFullPath);
                Delete delete = new Delete(this.spConfig, spFile);
                delete.execute();
                st.execute("delete from fnd_atm_attachment at where at.attachment_id = " + attachment_id);
                st.execute("delete from fnd_atm_attachment_multi atm where atm.attachment_id = " + attachment_id);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement((Statement)st);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)rs);
            DBUtil.closeStatement((Statement)st);
        }
    }

    private void doUpdate(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        CompositeMap params = service.getParameter();
        Object attachment_id = params.getObject("@attachment_id");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        List items = up.parseRequest(serviceInstance.getRequest());
        FileItem fileItem = null;
        for (FileItem fi : items) {
            if (fi.isFormField()) continue;
            fileItem = fi;
        }
        if (attachment_id != null && !"".equals(attachment_id)) {
            Connection conn = this.getContextConnection(context);
            Statement st = conn.createStatement();
            ResultSet rs = null;
            String path = null;
            try {
                rs = st.executeQuery("select file_path from fnd_atm_attachment t where t.attachment_id = " + attachment_id);
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                path = rs.getString(1);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement((Statement)st);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)rs);
            DBUtil.closeStatement((Statement)st);
            File delFile = new File(path);
            if (delFile.exists()) {
                delFile.delete();
            }
            if (fileItem != null) {
                long size = 0L;
                FileOutputStream fos = null;
                InputStream ins = null;
                Statement stmt = null;
                try {
                    int b;
                    fos = new FileOutputStream(delFile);
                    ins = fileItem.getInputStream();
                    while ((b = ins.read()) >= 0) {
                        fos.write(b);
                        ++size;
                    }
                    stmt = conn.createStatement();
                    stmt.executeUpdate("update fnd_atm_attachment a set a.file_size = " + size + " where a.attachment_id = " + attachment_id);
                }
                catch (Throwable throwable) {
                    if (ins != null) {
                        ins.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    DBUtil.closeStatement(stmt);
                    throw throwable;
                }
                if (ins != null) {
                    ins.close();
                }
                if (fos != null) {
                    fos.close();
                }
                DBUtil.closeStatement((Statement)stmt);
            }
        }
    }

    private String fixDestUrl(String source) {
        String result = source;
        if (!result.endsWith("/")) {
            result = String.valueOf(result) + "/";
        }
        if (!result.startsWith("http")) {
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
            result = String.valueOf(this.spConfig.getAppLocation()) + result;
        }
        return result;
    }

    private void doUpload(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        CompositeMap params = service.getParameter();
        String user_name = (String)params.getObject("@user_name");
        String destUrl = (String)params.getObject("@destUrl");
        this.logger.config("user_name:" + user_name);
        this.logger.config("source destUrl:" + destUrl);
        destUrl = this.fixDestUrl(destUrl);
        this.logger.config("result destUrl:" + destUrl);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        int ms = this.getFileSize();
        if (ms > 0) {
            up.setSizeMax((long)ms);
        }
        List items = null;
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        Connection conn = null;
        String url = null;
        try {
            items = up.parseRequest(serviceInstance.getRequest());
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    String name = fileItem.getFieldName();
                    String value = fileItem.getString("UTF-8");
                    if (PROPERTITY_URL.equalsIgnoreCase(name)) {
                        url = value;
                        continue;
                    }
                    if (PROPERTITY_ACTION_TYPE.equalsIgnoreCase(name)) {
                        this.actionType = value;
                        continue;
                    }
                    params.put((Object)name, (Object)value);
                    if (!"attachment_id".equalsIgnoreCase(name)) continue;
                    serviceInstance.getRequest().setAttribute("attachment_id", (Object)value);
                    continue;
                }
                String fts = this.getFileType();
                if (fts != null) {
                    String name = fileItem.getName().toLowerCase();
                    String ft = name.substring(name.lastIndexOf(".") + 1, name.length());
                    if (fts.indexOf(ft) != -1) {
                        files.add(fileItem);
                        continue;
                    }
                    throw new Exception("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d!\u53ea\u5141\u8bb8 " + fts);
                }
                files.add(fileItem);
            }
            Map<String, String> file_paths = null;
            for (FileItem fileItem : files) {
                File file = new File(fileItem.getName());
                String file_name = file.getName();
                if ("".equals(file_name)) continue;
                params.put((Object)"file_name", (Object)file_name);
                params.put((Object)"file_size", (Object)new Long(fileItem.getSize()));
                if (file_paths == null) {
                    file_paths = this.getExistsAttachments(context);
                }
                BusinessModelService modelService = this.databasefactory.getModelService(FND_UPLOAD_FILE_TYPE, context);
                modelService.execute(null);
                Object aid = service.getModel().getObject("/parameter/@attachment_id");
                conn = this.getContextConnection(context);
                InputStream in = fileItem.getInputStream();
                String attach_id = aid.toString();
                String sourceSystem = this.spConfig.getSourceSystem();
                byte[] fileContent = this.spConfig.inputStreamToBytes(in);
                String fileFullPath = String.valueOf(destUrl) + file_name;
                String attachment_id = file_paths.get(fileFullPath);
                if (attachment_id != null) {
                    this.deleteAttachement(conn, attachment_id);
                }
                SharePointFile spFile = new SharePointFile(this.spConfig, fileFullPath);
                this.uploadToSharePoint(conn, attach_id, spFile, fileContent, sourceSystem, user_name);
                fileItem.delete();
                params.put((Object)"success", (Object)"true");
                if (url != null) continue;
                PrintWriter out = serviceInstance.getResponse().getWriter();
                out.write(aid.toString());
                out.close();
            }
            if (url != null) {
                serviceInstance.getResponse().sendRedirect(url);
            }
        }
        catch (Exception ex) {
            LoggingContext.getLogger((CompositeMap)context, (String)SharePointAttachmentManager.class.getCanonicalName()).log(ex.getMessage());
            throw ex;
        }
    }

    private Map<String, String> getExistsAttachments(CompositeMap context) throws Exception {
        HashMap<String, String> file_paths = new HashMap<String, String>();
        CompositeMap fakeContext = (CompositeMap)context.clone();
        String table_name = (String)fakeContext.getObject("/parameter/@source_type");
        String table_pk_value = (String)fakeContext.getObject("/parameter/@pkvalue");
        fakeContext.putObject("/parameter/@table_name", (Object)table_name, true);
        fakeContext.putObject("/parameter/@table_pk_value", (Object)table_pk_value, true);
        fakeContext.putString((Object)"table_name", table_name);
        fakeContext.putString((Object)"table_pk_value", table_pk_value);
        CompositeMap result = this.queryBM(ATM_URL_QUERY, fakeContext, fakeContext);
        if (result == null) {
            return file_paths;
        }
        List childs = result.getChilds();
        if (childs == null) {
            return file_paths;
        }
        String appLocation = this.spConfig.getAppLocation();
        for (CompositeMap record : childs) {
            String fileFullPath = record.getString((Object)"file_path");
            String attachment_id = record.getString((Object)"attachment_id");
            if (fileFullPath == null || !fileFullPath.startsWith(appLocation)) continue;
            SharePointFile spf = new SharePointFile(this.spConfig, fileFullPath);
            String folder = spf.getFolderPath();
            if (folder != null) {
                this.spConfig.addFolder(folder);
            }
            file_paths.put(fileFullPath, attachment_id);
        }
        return file_paths;
    }

    private void deleteAttachement(Connection conn, String attachment_id) throws Exception {
        if (attachment_id != null && !"".equals(attachment_id)) {
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                st.execute("delete from fnd_atm_attachment at where at.attachment_id = " + attachment_id);
                st.execute("delete from fnd_atm_attachment_multi atm where atm.attachment_id = " + attachment_id);
            }
            finally {
                DBUtil.closeResultSet(rs);
                DBUtil.closeStatement((Statement)st);
            }
        }
    }

    private CompositeMap queryBM(String bm_name, CompositeMap context, CompositeMap queryMap) throws Exception {
        if (context == null) {
            context = new CompositeMap("context");
        }
        BusinessModelService service = this.databasefactory.getModelService(bm_name, context);
        CompositeMap resultMap = service.queryAsMap((Map)queryMap, FetchDescriptor.fetchAll());
        return resultMap;
    }

    private void uploadToSharePoint(Connection conn, String aid, SharePointFile spFile, byte[] fileContent, String sourceSystem, String sourceSystemUser) throws Exception {
        Upload upload = new Upload(this.spConfig, spFile, fileContent, sourceSystem, sourceSystemUser);
        upload.execute();
        Statement stmt = null;
        try {
            String url = spFile.getFileFullPath();
            stmt = conn.createStatement();
            stmt.executeUpdate("update fnd_atm_attachment a set a.file_path = '" + url + "' where a.attachment_id = " + aid);
        }
        catch (Throwable throwable) {
            DBUtil.closeStatement(stmt);
            throw throwable;
        }
        DBUtil.closeStatement((Statement)stmt);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public int getFileSize() {
        return this.maxSize;
    }

    public void setFileSize(int fileSize) {
        this.maxSize = fileSize;
    }

    public String getActionType() {
        return this.actionType == null ? "upload" : this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    private String processFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent");
        String new_filename = URLEncoder.encode(filename, "UTF8");
        String rtn = "filename=\"" + new_filename + "\"";
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).indexOf("msie") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("gb2312"), "iso-8859-1") + "\"";
            } else if (userAgent.indexOf("opera") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            } else if (userAgent.indexOf("safari") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("UTF-8"), "ISO8859-1") + "\"";
            } else if (userAgent.indexOf("applewebkit") != -1) {
                new_filename = MimeUtility.encodeText((String)filename, (String)"UTF8", (String)"B");
                rtn = "filename=\"" + new_filename + "\"";
            } else if (userAgent.indexOf("mozilla") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            }
        }
        return rtn;
    }

    public String getUseSubFolder() {
        return this.useSubFolder == null ? "true" : this.useSubFolder;
    }

    public void setUseSubFolder(String useSubFolder) {
        this.useSubFolder = useSubFolder;
    }

    public String getDataSourceName() {
        return this.dataSourcename;
    }

    public void setDataSourceName(String name) {
        this.dataSourcename = name;
    }
}

