/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.plugin.sharepoint.SharePointConfig;
import aurora.plugin.sharepoint.SharePointFile;
import aurora.plugin.sharepoint.SharepointAuthenticator;
import aurora.plugin.sharepoint.UpdateListItems;
import aurora.plugin.sharepoint.WebServiceUtil;
import com.microsoft.schemas.sharepoint.ListsSoap;
import com.microsoft.schemas.sharepoint.UpdateListItems;
import com.microsoft.schemas.sharepoint.UpdateListItemsResponse;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.List;
import javax.xml.ws.BindingProvider;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;

public class Delete {
    public static String DELETE_FILE_SUCCESS = "0x00000000";
    private SharePointConfig spConfig;
    private SharePointFile spFile;
    private ILogger logger;
    String list_wsdl_url;
    String user_name;
    String pass_word;
    String list_asmx_url;

    public Delete(SharePointConfig spConfig, SharePointFile spFile) {
        this.spConfig = spConfig;
        this.spFile = spFile;
        this.logger = spConfig.getLogger(this.getClass().getCanonicalName());
        this.list_wsdl_url = spConfig.getListsWsdlFullPath();
        this.user_name = spConfig.getUserName();
        this.pass_word = spConfig.getPassword();
        this.list_asmx_url = spConfig.getListsOperationFullPath();
    }

    public void execute() throws Exception {
        if (this.spConfig.isUseJax()) {
            CookieManager cm = new CookieManager();
            CookieHandler.setDefault(cm);
            Authenticator.setDefault(new SharepointAuthenticator(this.spConfig));
            this.deleteListItemByJAX(this.spFile);
        } else {
            this.deleteListItem(this.spFile);
        }
    }

    private void deleteListItemByJAX(SharePointFile spFile) throws Exception {
        String listName = spFile.getListName();
        this.logger.info("listName:" + listName);
        ListsSoap port = this.spConfig.getListsSoap();
        BindingProvider bp = (BindingProvider)port;
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", this.user_name);
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", this.pass_word);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.list_asmx_url);
        String delete = "<Batch OnError=\"Continue\" ListVersion=\"1\" >\n\t<Method ID=\"1\" Cmd=\"Delete\">\n      <Field Name=\"ID\">1</Field>\n\t  <Field Name=\"FileRef\" target=\"blank\">%1s</Field>\n\t</Method>\t\t\t   \n</Batch>";
        String fileFullPath = spFile.getFileFullPath();
        this.logger.info("fileRef:" + fileFullPath);
        String deleteFormatted = String.format(delete, fileFullPath);
        this.logger.info("deleteFormatted:" + deleteFormatted);
        UpdateListItems.Updates u = new UpdateListItems.Updates();
        u.getContent().add(SharePointConfig.createSharePointCAMLNode(deleteFormatted));
        UpdateListItemsResponse.UpdateListItemsResult result = port.updateListItems(listName, u);
        this.printResponse(result);
    }

    private void deleteListItem(SharePointFile spFile) throws Exception {
        String listName = spFile.getListName();
        String fileFullPath = spFile.getFileFullPath();
        WebServiceUtil webServiceUtil = new WebServiceUtil(this.user_name, this.pass_word);
        CompositeMap requestBody = UpdateListItems.deleteFile(listName, fileFullPath);
        this.logger.config("request:" + requestBody.toXML());
        CompositeMap response_node = webServiceUtil.request(this.list_asmx_url, UpdateListItems.SOAP_ACTION, requestBody);
        this.logger.config("response:" + response_node.toXML());
        CompositeMap results = (CompositeMap)response_node.getObject("UpdateListItemsResult/Results");
        if (results == null) {
            return;
        }
        List resultList = results.getChilds();
        if (resultList == null) {
            return;
        }
        int length = resultList.size();
        if (length <= 0) {
            return;
        }
        CompositeMap lastResult = (CompositeMap)resultList.get(length - 1);
        CompositeMap errorCode_node = lastResult.getChild("ErrorCode");
        String errorCode = errorCode_node.getText();
        this.logger.info("errorCode:" + errorCode_node);
        if (DELETE_FILE_SUCCESS.equals(errorCode)) {
            return;
        }
        CompositeMap errorText_node = lastResult.getChild("ErrorText");
        String errorMessage = errorText_node.getText();
        throw new RuntimeException(errorMessage);
    }

    private void printResponse(UpdateListItemsResponse.UpdateListItemsResult result) throws Exception {
        List<Object> resultList = result.getContent();
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        Object content = resultList.get(0);
        this.logger.info("Delete:" + this.spConfig.parseResult(content));
    }
}

