/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script.upload;

import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import uncertain.composite.CompositeMap;

public class UploadFileToServer {
    private CompositeMap context;
    private HttpServletRequest request;

    public UploadFileToServer(CompositeMap context) {
        this.context = context;
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        this.request = serviceInstance.getRequest();
        assert (this.request != null);
    }

    public void doUpload() {
        try {
            DiskFileItemFactory diskFactory = new DiskFileItemFactory();
            diskFactory.setSizeThreshold(4096);
            String string = this.context.getString((Object)"tempPath", "");
            if (!"".equals(string)) {
                diskFactory.setRepository(new File(string));
            }
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)diskFactory);
            int max = this.context.getInt((Object)"maxSize", 10);
            upload.setSizeMax((long)(max * 1024 * 1024));
            List fileItems = upload.parseRequest(this.request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    System.out.println("\u5904\u7406\u8868\u5355\u5185\u5bb9 ...");
                    this.processFormField(item);
                    continue;
                }
                System.out.println("\u5904\u7406\u4e0a\u4f20\u7684\u6587\u4ef6 ...");
                this.processUploadFile(item);
            }
        }
        catch (Exception e) {
            System.out.println("\u4f7f\u7528 fileupload \u5305\u65f6\u53d1\u751f\u5f02\u5e38 ...");
            e.printStackTrace();
        }
    }

    private void processFormField(FileItem item) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)this.context);
        CompositeMap parameter = service.getParameter();
        String name = item.getFieldName();
        String value = item.getString("UTF-8");
        parameter.put((Object)name, (Object)value);
    }

    private void processUploadFile(FileItem item) throws Exception {
        String filename = item.getName();
        System.out.println("\u5b8c\u6574\u7684\u6587\u4ef6\u540d\uff1a" + filename);
        int index = filename.lastIndexOf("\\");
        filename = filename.substring(index + 1, filename.length());
        long fileSize = item.getSize();
        if ("".equals(filename) && fileSize == 0L) {
            System.out.println("\u6587\u4ef6\u540d\u4e3a\u7a7a ...");
            return;
        }
        String path = this.context.getString((Object)"filePath", "");
        File uploadFile = new File(String.valueOf(path) + "/" + filename);
        if (!new File(path).exists()) {
            FileUtils.forceMkdir((File)new File(path));
        }
        if (!uploadFile.exists()) {
            uploadFile.createNewFile();
        }
        item.write(uploadFile);
        CompositeMap files = this.context.getChild("uploadFiles");
        if (files == null) {
            files = this.context.createChild("uploadFiles");
        }
        CompositeMap createChild = files.createChild("file");
        createChild.put((Object)"filePath", (Object)uploadFile.getPath());
        createChild.put((Object)"fileName", (Object)filename);
        createChild.put((Object)"fileSize", (Object)fileSize);
        System.out.println(String.valueOf(filename) + " \u6587\u4ef6\u4fdd\u5b58\u5b8c\u6bd5 ...");
        System.out.println("\u6587\u4ef6\u5927\u5c0f\u4e3a \uff1a" + fileSize + "\r\n");
    }

    public static void doDelFile(String filePath) {
        try {
            FileUtils.forceDelete((File)new File(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

