/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script.scriptobject;

import aurora.application.action.HttpSessionCopy;
import aurora.application.action.HttpSessionOperate;
import aurora.javascript.Callable;
import aurora.javascript.Context;
import aurora.javascript.Function;
import aurora.javascript.Scriptable;
import aurora.javascript.ScriptableObject;
import aurora.plugin.script.scriptobject.CompositeMapObject;
import aurora.plugin.script.scriptobject.ScriptUtil;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import uncertain.composite.CompositeMap;

public class SessionObject
extends ScriptableObject {
    private static final long serialVersionUID = -7934572854688154878L;
    public static final String CLASS_NAME = "Session";
    private CompositeMap context;
    private CompositeMap sessionMap;
    private CompositeMapObject sessionObject;
    private HttpSessionOperate hso;
    private HttpServletRequest request;

    public SessionObject() {
    }

    public SessionObject(CompositeMap ctx) {
        this.hso = new HttpSessionOperate();
        this.context = ctx;
        this.sessionMap = this.context.getChild("session");
    }

    public static SessionObject jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        return new SessionObject((CompositeMap)args[0]);
    }

    private void init() {
        if (this.request == null) {
            HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)this.context);
            this.request = svc.getRequest();
        }
    }

    public CompositeMap getContext() {
        return this.context;
    }

    public void setContext(CompositeMap context) {
        this.context = context;
    }

    public void jsFunction_write(String target, String source) {
        this.init();
        this.hso.setTarget(target);
        this.hso.setSource(source);
        this.hso.writeSession(this.request, this.context);
    }

    public void jsFunction_writeValue(String target, Object value) {
        this.init();
        HttpSession session = this.request.getSession();
        session.setAttribute(target, value);
        this.context.putObject("/session/@" + target, value);
    }

    public void jsFunction_create() {
        this.init();
        this.request.getSession(true);
    }

    public void jsFunction_clear() {
        this.init();
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public void jsFunction_copy() {
        this.init();
        HttpSession ses = this.request.getSession(false);
        HttpSessionCopy.copySession((CompositeMap)this.context, (HttpSession)ses);
    }

    public void initSession() {
        if (this.context == null) {
            return;
        }
        if (this.sessionMap == null) {
            this.sessionMap = this.context.createChild("session");
        }
        if (this.sessionObject == null) {
            this.sessionObject = (CompositeMapObject)ScriptUtil.newObject((Scriptable)this, "CompositeMap");
            this.sessionObject.setData(this.sessionMap);
        }
    }

    public Object jsFunction_get(String key) {
        this.initSession();
        return this.sessionObject.composite_get(key);
    }

    public void jsFunction_put(String key, Object value) {
        this.initSession();
        this.sessionObject.composite_put(key, value);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean has(String name, Scriptable start) {
        this.initSession();
        if (this.sessionMap != null && this.sessionMap.containsKey((Object)name)) {
            return true;
        }
        return super.has(name, start);
    }

    public Object get(String name, Scriptable start) {
        Object o;
        this.initSession();
        Object object = o = this.sessionObject == null ? null : this.sessionObject.get(name, start);
        if (ScriptUtil.isValid(o)) {
            return o;
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        this.initSession();
        if (this.sessionMap != null && !(value instanceof Callable)) {
            this.jsFunction_writeValue(name, value);
        }
        if (!this.isSealed()) {
            super.put(name, start, value);
        }
    }

    public String jsFunction_toXML() {
        return this.sessionObject.jsFunction_toXML();
    }

    public Object[] getIds() {
        if (this.sessionObject == null) {
            return new Object[0];
        }
        return this.sessionObject.getIds();
    }
}

