/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.IDocFileListener;
import aurora.plugin.sap.sync.idoc.IDocProcessManager;
import aurora.plugin.sap.sync.idoc.IDocServerManager;
import aurora.plugin.sap.sync.idoc.ListenerMonitor;
import uncertain.core.ILifeCycle;

public class IDocServer
implements ILifeCycle {
    private IDocServerManager serverManager;
    private String serverName;
    private IDocProcessManager iDocProcessManager;
    private IDocFileListener iDocFileListener;
    private ListenerMonitor monitor;

    public IDocServer(IDocServerManager serverManager, String serverName) {
        this.serverManager = serverManager;
        this.serverName = serverName;
    }

    public boolean startup() {
        this.iDocProcessManager = new IDocProcessManager(this.serverManager);
        this.iDocProcessManager.startup();
        this.iDocFileListener = new IDocFileListener(this.serverManager, this.serverName, this.iDocProcessManager);
        this.monitor = new ListenerMonitor(this.serverManager, this.iDocFileListener);
        this.monitor.setDaemon(true);
        this.monitor.start();
        return true;
    }

    public void shutdown() {
        this.shutdownMonitor();
        this.shutdownListener();
        this.shutdownProcessManager();
    }

    private void shutdownProcessManager() {
        if (this.iDocProcessManager != null) {
            this.iDocProcessManager.shutdown();
        }
    }

    private void shutdownListener() {
        if (this.iDocFileListener != null) {
            this.iDocFileListener.shutdown();
        }
    }

    private void shutdownMonitor() {
        if (this.monitor != null) {
            this.monitor.interrupt();
        }
    }

    public String getServerName() {
        return this.serverName;
    }
}

