/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.BackupToInterfaceProcessor;
import aurora.plugin.sap.sync.idoc.FeedbackProcessor;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocServerManager;
import aurora.plugin.sap.sync.idoc.SyncProcessor;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import uncertain.core.ILifeCycle;
import uncertain.logging.ILogger;

public class IDocProcessManager
implements ILifeCycle {
    private IDocServerManager serverManager;
    private ILogger logger;
    private ExecutorService idocServerThreadMananger;
    public LinkedList<IDocFile> syncFileList = new LinkedList();
    public LinkedList<IDocFile> feedbackFileList = new LinkedList();
    public LinkedList<IDocFile> backupFileList = new LinkedList();
    public LinkedList<IDocFile> deleteFileList = new LinkedList();
    private boolean keepIdocFile = true;
    private boolean interfaceEnabledFlag = true;

    public IDocProcessManager(IDocServerManager serverManager) {
        this.serverManager = serverManager;
        this.logger = serverManager.getLogger();
        this.keepIdocFile = serverManager.isKeepIdocFile();
        this.interfaceEnabledFlag = serverManager.isInterfaceEnabledFlag();
    }

    public boolean startup() {
        int threadCount = this.getThreadCount();
        this.idocServerThreadMananger = Executors.newFixedThreadPool(threadCount);
        SyncProcessor sync = new SyncProcessor(this.serverManager, this);
        this.idocServerThreadMananger.execute(sync);
        FeedbackProcessor feedback = new FeedbackProcessor(this.serverManager, this);
        this.idocServerThreadMananger.execute(feedback);
        if (this.interfaceEnabledFlag) {
            BackupToInterfaceProcessor backup = new BackupToInterfaceProcessor(this.serverManager, this);
            this.idocServerThreadMananger.execute(backup);
        }
        if (!this.keepIdocFile) {
            DeleteIDocFileProcessor delete = new DeleteIDocFileProcessor();
            this.idocServerThreadMananger.execute(delete);
        }
        return true;
    }

    public void shutdown() {
        List<Runnable> threadList = this.idocServerThreadMananger.shutdownNow();
        for (Runnable thread : threadList) {
            if (thread instanceof ILifeCycle) {
                ((ILifeCycle)thread).shutdown();
                continue;
            }
            this.logger.log(Level.SEVERE, "thread " + thread.toString() + " can not shutdown!");
        }
    }

    public synchronized void syncDone(IDocFile idocFile, boolean successful) {
        if (successful) {
            if (this.interfaceEnabledFlag) {
                this.addBackupFile(idocFile);
            } else {
                this.freeResource(idocFile);
            }
        } else {
            idocFile.clear();
        }
        this.addFeedbackFile(idocFile);
    }

    public synchronized void backupDone(IDocFile idocFile, boolean successful) {
        if (successful) {
            this.freeResource(idocFile);
        } else {
            idocFile.clear();
        }
    }

    public synchronized void freeResource(IDocFile idocFile) {
        idocFile.clear();
        if (!this.keepIdocFile) {
            this.addDeleteFile(idocFile);
        }
    }

    private int getThreadCount() {
        int threadCount = 2;
        if (this.interfaceEnabledFlag) {
            ++threadCount;
        }
        if (!this.keepIdocFile) {
            ++threadCount;
        }
        return threadCount;
    }

    public synchronized boolean isSyncFileEmpty() {
        int size = this.syncFileList.size();
        return size == 0;
    }

    public synchronized void addSyncFileAll(List<IDocFile> idocFileList) {
        this.syncFileList.addAll(idocFileList);
    }

    public synchronized void addSyncFile(IDocFile idocFile) {
        this.syncFileList.addLast(idocFile);
    }

    public synchronized IDocFile pollSyncFile() {
        IDocFile idocFile = this.syncFileList.poll();
        return idocFile;
    }

    public synchronized void addFeedbackFile(IDocFile idocFile) {
        this.feedbackFileList.addLast(idocFile);
    }

    public synchronized IDocFile pollFeedbackFile() {
        IDocFile idocFile = this.feedbackFileList.poll();
        return idocFile;
    }

    private synchronized void addBackupFile(IDocFile idocFile) {
        this.backupFileList.addLast(idocFile);
    }

    public synchronized IDocFile pollBackupFile() {
        IDocFile idocFile = this.backupFileList.poll();
        return idocFile;
    }

    private synchronized void addDeleteFile(IDocFile idocFile) {
        this.deleteFileList.addLast(idocFile);
    }

    private synchronized IDocFile pollDeleteFile() {
        IDocFile idocFile = this.deleteFileList.poll();
        return idocFile;
    }

    class DeleteIDocFileProcessor
    implements Runnable {
        DeleteIDocFileProcessor() {
        }

        @Override
        public void run() {
            while (IDocProcessManager.this.serverManager.isRunning()) {
                if (IDocProcessManager.this.serverManager.isKeepIdocFile()) continue;
                IDocFile idocFile = IDocProcessManager.this.pollDeleteFile();
                if (idocFile == null) {
                    this.sleepOneSecond();
                    continue;
                }
                File deleteFile = new File(idocFile.getFileFullPath());
                if (!deleteFile.exists()) continue;
                IDocProcessManager.this.logger.log("delete file " + idocFile.getFileFullPath() + " " + deleteFile.delete());
            }
        }

        private void sleepOneSecond() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

