/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export.word;

import aurora.plugin.export.word.Replace;
import aurora.plugin.export.word.SectList;
import aurora.plugin.export.word.WordTemplateProvider;
import aurora.plugin.export.word.WordUtils;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ObjectFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class WordExport
extends AbstractEntry {
    private static final String DEFAULT_WORD_NAME = "untitle.docx";
    protected Replace[] replaces;
    protected SectList[] sectLists;
    private String template = null;
    private String name = "untitle.docx";
    private String type = "word";
    private String savePath = null;
    private UncertainEngine uncertainEngine;
    private WordTemplateProvider provider;

    public WordExport(IObjectRegistry registry) {
        this.provider = (WordTemplateProvider)registry.getInstanceOfType(WordTemplateProvider.class);
        this.uncertainEngine = (UncertainEngine)registry.getInstanceOfType(UncertainEngine.class);
    }

    public void run(ProcedureRunner runner) throws Exception {
        block27: {
            ServletOutputStream res_out;
            String name;
            WordprocessingMLPackage wordMLPackage;
            CompositeMap context;
            block25: {
                File destPdf;
                block26: {
                    Object data;
                    context = runner.getContext();
                    ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
                    CompositeMap model = service.getModel();
                    String templateName = this.getTemplate();
                    if (templateName != null) {
                        templateName = TextParser.parse((String)templateName, (CompositeMap)model);
                    }
                    if (templateName == null) {
                        throw new IllegalArgumentException("template can not be null!");
                    }
                    File templateFile = new File(this.uncertainEngine.getConfigDirectory(), templateName);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("model", model);
                    if (this.replaces != null) {
                        Replace[] replaceArray = this.replaces;
                        int n = this.replaces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Replace replace = replaceArray[n2];
                            String path = replace.getPath();
                            if (path != null) {
                                data = model.getObject(path);
                                dataMap.put(replace.getName(), data);
                            }
                            ++n2;
                        }
                    }
                    if (this.sectLists != null) {
                        StringBuffer sb = new StringBuffer();
                        ObjectFactory factory = Context.getWmlObjectFactory();
                        data = this.sectLists;
                        int path = this.sectLists.length;
                        int n = 0;
                        while (n < path) {
                            SectList list = data[n];
                            CompositeMap data2 = (CompositeMap)model.getObject(list.getModel());
                            List children = data2.getChilds();
                            for (CompositeMap item : children) {
                                sb.append(this.createSection(factory, list, item));
                            }
                            dataMap.put(list.getId(), sb.toString());
                            ++n;
                        }
                    }
                    Configuration configuration = this.provider.getFreeMarkerConfiguration();
                    StringWriter out = null;
                    String xml = "";
                    try {
                        Template t = configuration.getTemplate(templateName);
                        out = new StringWriter();
                        t.process(dataMap, (Writer)out);
                        out.flush();
                        xml = out.toString();
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    WordUtils.putObject("KEY_EXPORT_TYPE", this.getType());
                    wordMLPackage = WordUtils.createWord(xml, templateFile);
                    name = TextParser.parse((String)this.getName(), (CompositeMap)model);
                    String savePath = this.getSavePath();
                    if (savePath == null) break block25;
                    destPdf = new File(TextParser.parse((String)savePath, (CompositeMap)model), name);
                    if (!"word".equals(this.getType())) break block26;
                    wordMLPackage.save(destPdf);
                    break block27;
                }
                if (!"pdf".equals(this.getType())) break block27;
                FOSettings foSettings = Docx4J.createFOSettings();
                foSettings.setWmlPackage((OpcPackage)wordMLPackage);
                FileOutputStream os = new FileOutputStream(destPdf);
                Docx4J.toFO((FOSettings)foSettings, (OutputStream)os, (int)0);
                break block27;
            }
            HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
            HttpServletResponse response = serviceInstance.getResponse();
            response.setHeader("cache-control", "must-revalidate");
            response.setHeader("pragma", "public");
            response.setHeader("Content-disposition", "attachment;" + this.processFileName(serviceInstance.getRequest(), name));
            response.setCharacterEncoding("utf-8");
            if ("word".equals(this.getType())) {
                response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                res_out = null;
                try {
                    res_out = response.getOutputStream();
                    wordMLPackage.save((OutputStream)res_out);
                }
                finally {
                    if (res_out != null) {
                        res_out.close();
                    }
                }
            }
            if ("pdf".equals(this.getType())) {
                response.setContentType("application/pdf");
                res_out = null;
                try {
                    res_out = response.getOutputStream();
                    FOSettings foSettings = Docx4J.createFOSettings();
                    foSettings.setWmlPackage((OpcPackage)wordMLPackage);
                    Docx4J.toFO((FOSettings)foSettings, (OutputStream)res_out, (int)0);
                }
                finally {
                    if (res_out != null) {
                        res_out.close();
                    }
                }
            }
            ProcedureRunner preRunner = runner;
            while (preRunner.getCaller() != null) {
                preRunner = preRunner.getCaller();
                preRunner.stop();
            }
        }
    }

    private String processFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent");
        String new_filename = URLEncoder.encode(filename, "UTF8");
        String rtn = "filename=\"" + new_filename + "\"";
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).indexOf("msie") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("gb2312"), "iso-8859-1") + "\"";
            } else if (userAgent.indexOf("opera") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            } else if (userAgent.indexOf("safari") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("UTF-8"), "ISO8859-1") + "\"";
            } else if (userAgent.indexOf("applewebkit") != -1) {
                new_filename = MimeUtility.encodeText((String)filename, (String)"UTF8", (String)"B");
                rtn = "filename=\"" + new_filename + "\"";
            } else if (userAgent.indexOf("mozilla") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            }
        }
        return rtn;
    }

    private String createSection(ObjectFactory factory, SectList list, CompositeMap item) throws JAXBException {
        String indFirstLine;
        String indLeft;
        Boolean toc;
        String type = item.getString((Object)list.getType());
        if ("table".equals(type)) {
            return item.getString((Object)list.getTextField());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<p");
        String align = item.getString((Object)list.getAlignField());
        if (align != null) {
            sb.append(" align=\"").append(align).append("\"");
        }
        if ((toc = Boolean.valueOf(item.getBoolean((Object)list.getTocField(), false))).booleanValue()) {
            sb.append(" toc=\"").append(toc).append("\"");
        }
        if ((indLeft = item.getString((Object)list.getIndLeftField())) != null) {
            sb.append(" indLeft=\"").append(indLeft).append("\"");
        }
        if ((indFirstLine = item.getString((Object)list.getIndFirstLineField())) != null) {
            sb.append(" indFirstLine=\"").append(indFirstLine).append("\"");
        }
        String ilvl = item.getString((Object)list.getIlvlField());
        String numId = list.getNumId();
        if (ilvl != null) {
            sb.append(" numId=\"" + numId + "\" ilvl=\"").append(ilvl).append("\"");
        }
        sb.append(">");
        sb.append(item.getString((Object)list.getTextField()));
        sb.append("</p>");
        return "0".equals(ilvl) ? "<p/>" + sb.toString() : sb.toString();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String t) {
        this.template = t;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public Replace[] getReplaces() {
        return this.replaces;
    }

    public void setReplaces(Replace[] rps) {
        this.replaces = rps;
    }

    public SectList[] getSectLists() {
        return this.sectLists;
    }

    public void setSectLists(SectList[] lists) {
        this.sectLists = lists;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }
}

