/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.CellStyleWrap;
import aurora.plugin.excelreport.ExcelFactory;
import aurora.plugin.excelreport.SheetWrap;
import aurora.plugin.export.task.IReportTask;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.IllegalAddException;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.XMLOutputter;
import uncertain.core.UncertainEngine;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ExcelReport
extends AbstractEntry {
    String configPath;
    String fileName;
    String format;
    String template;
    UncertainEngine uncertainEngine;
    public static final String KEY_EXCEL_REPORT = "excel-report";
    public static final String KEY_EXCEL2003_SUFFIX = ".xls";
    public static final String KEY_EXCEL2007_SUFFIX = ".xlsx";
    public static final String KEY_EXCEL2003_MIME = "application/vnd.ms-excel";
    public static final String KEY_EXCEL2007_MIME = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    OutputStream os;
    public CellStyleWrap[] styles;
    public SheetWrap[] sheets;
    CompositeMap configObj;
    boolean enableTaskBoolean;
    String enableTask = "true";
    ILogger logger;

    public ExcelReport(UncertainEngine uncertainEngine) {
        this.uncertainEngine = uncertainEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.enableTaskBoolean = Boolean.parseBoolean(TextParser.parse((String)this.enableTask, (CompositeMap)context));
        this.logger = LoggingContext.getLogger((CompositeMap)context, (String)"aurora.plugin.excelreport");
        ExcelReport excelReport = this.createExcelReport(context);
        if (excelReport == null) {
            return;
        }
        String filename = TextParser.parse((String)excelReport.getFileName(), (CompositeMap)context);
        this.setFileName(filename);
        if (filename == null) throw new IllegalAddException("fileName attribute is undefined");
        if (filename.endsWith(KEY_EXCEL2007_SUFFIX)) {
            excelReport.setFormat(KEY_EXCEL2007_SUFFIX);
        } else {
            if (!filename.endsWith(KEY_EXCEL2003_SUFFIX)) throw new IllegalAddException(String.valueOf(filename) + " illegal suffix");
            excelReport.setFormat(KEY_EXCEL2003_SUFFIX);
        }
        try {
            try {
                File excelFile;
                String fileAbsolutePath;
                IObjectRegistry or = this.uncertainEngine.getObjectRegistry();
                IReportTask excelTask = null;
                if (this.enableTaskBoolean) {
                    excelTask = (IReportTask)or.getInstanceOfType(IReportTask.class);
                }
                if (excelTask != null) {
                    fileAbsolutePath = String.valueOf(excelTask.getReportDir()) + "/" + "excel" + System.currentTimeMillis() + excelReport.getFormat();
                    excelFile = new File(fileAbsolutePath);
                } else {
                    excelFile = File.createTempFile("excelreport", excelReport.getFormat());
                    fileAbsolutePath = excelFile.getAbsolutePath();
                }
                context.putObject("/parameter/@file_path", (Object)fileAbsolutePath, true);
                context.putObject("/parameter/@file_name", (Object)excelReport.getFileName(), true);
                this.os = new FileOutputStream(excelFile);
                excelReport.setOutputStream(this.os);
                new ExcelFactory().createExcel(context, excelReport);
                if (this.enableTaskBoolean) return;
                ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context);
                HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
                this.setResponseHeader(((HttpServiceInstance)svc).getRequest(), response, excelReport);
                this.transferOutputStream((OutputStream)response.getOutputStream(), new FileInputStream(excelFile));
                return;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, null, (Throwable)e);
                throw e;
            }
        }
        finally {
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, null, (Throwable)e);
                }
            }
            if (!this.enableTaskBoolean) {
                this.stopRunner(runner);
            }
        }
    }

    ExcelReport createExcelReport(CompositeMap context) throws IOException, SAXException {
        ExcelReport excelReport = null;
        if (this.getSheets() == null && this.getConfigPath() != null) {
            CompositeMap config = (CompositeMap)context.getObject(this.getConfigPath());
            if (config != null) {
                String configStr = XMLOutputter.defaultInstance().toXML(config, false);
                try {
                    this.setConfigObj(CompositeLoader.createInstanceForOCM().loadFromString(configStr, "UTF-8"));
                }
                catch (IOException e) {
                    throw e;
                }
                catch (SAXException e) {
                    throw e;
                }
            }
            OCManager mOCManager = this.uncertainEngine.getOcManager();
            excelReport = (ExcelReport)((Object)mOCManager.createObject(this.getConfigObj()));
        } else {
            excelReport = this;
        }
        return excelReport;
    }

    void stopRunner(ProcedureRunner runner) {
        runner.stop();
        while (runner.getCaller() != null) {
            runner.getCaller().stop();
            runner = runner.getCaller();
        }
    }

    void transferOutputStream(OutputStream os, InputStream is) throws IOException {
        ReadableByteChannel rbc = Channels.newChannel(is);
        WritableByteChannel wbc = Channels.newChannel(os);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try {
            while (rbc.read(buffer) != -1) {
                buffer.flip();
                wbc.write(buffer);
                buffer.compact();
            }
        }
        finally {
            wbc.close();
            rbc.close();
            is.close();
        }
    }

    void setResponseHeader(HttpServletRequest request, HttpServletResponse response, ExcelReport excelReport) throws UnsupportedEncodingException {
        if (KEY_EXCEL2007_SUFFIX.equals(this.format)) {
            response.setContentType(KEY_EXCEL2007_MIME);
        } else {
            response.setContentType(KEY_EXCEL2003_MIME);
        }
        String userAgent = request.getHeader("User-Agent");
        String filename = excelReport.getFileName();
        if (userAgent != null) {
            filename = (userAgent = userAgent.toLowerCase()).indexOf("msie") != -1 ? new String(filename.getBytes("GBK"), "ISO-8859-1") : new String(filename.getBytes("UTF-8"), "ISO-8859-1");
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        response.setHeader("cache-control", "must-revalidate");
        response.setHeader("pragma", "public");
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public CellStyleWrap[] getStyles() {
        return this.styles;
    }

    public void setStyles(CellStyleWrap[] styles) {
        this.styles = styles;
    }

    public SheetWrap[] getSheets() {
        return this.sheets;
    }

    public void setSheets(SheetWrap[] sheets) {
        this.sheets = sheets;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public CompositeMap getConfigObj() {
        return this.configObj;
    }

    public void setConfigObj(CompositeMap configObj) {
        this.configObj = configObj;
    }

    public String getEnableTask() {
        return this.enableTask;
    }

    public void setEnableTask(String enableTask) {
        this.enableTask = enableTask;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

