/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.CellStyleWrap;
import aurora.plugin.excelreport.ExcelReport;
import aurora.plugin.excelreport.SheetWrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.UncertainEngine;

public class ExcelFactory {
    Map<String, CellStyle> styles;
    public final String KEY_CONTENT = "content";
    public final String KEY_FORMULA = "formula";
    private CreationHelper createHelper;
    private String templatePath;
    private String format;
    UncertainEngine uncertainEngine;
    Workbook wb = null;
    CompositeMap context;

    public Workbook getWorkbook() {
        return this.wb;
    }

    public CompositeMap getContext() {
        return this.context;
    }

    public void createExcel(CompositeMap context, ExcelReport excelReport) throws Exception {
        if (excelReport.getSheets() == null) {
            return;
        }
        this.context = context;
        this.uncertainEngine = excelReport.uncertainEngine;
        this.format = excelReport.getFormat();
        this.setTemplatePath(excelReport.getTemplate());
        this.wb = ".xlsx".equalsIgnoreCase(this.format) ? (this.getTemplatePath() != null ? new XSSFWorkbook(this.getTemplateInputStream()) : new XSSFWorkbook()) : (this.getTemplatePath() != null ? new HSSFWorkbook(this.getTemplateInputStream()) : new HSSFWorkbook());
        this.createHelper = this.wb.getCreationHelper();
        if (excelReport.getStyles() != null) {
            this.styles = this.createStyles(this.wb, excelReport);
        }
        int count = 0;
        SheetWrap[] sheetWrapArray = excelReport.getSheets();
        int n = sheetWrapArray.length;
        int n2 = 0;
        while (n2 < n) {
            SheetWrap sheetObj = sheetWrapArray[n2];
            sheetObj.createSheet(this, count++);
            ++n2;
        }
        if (this.getTemplatePath() != null) {
            if (this.wb instanceof HSSFWorkbook) {
                HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)this.wb);
            } else if (this.wb instanceof XSSFWorkbook) {
                XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)((XSSFWorkbook)this.wb));
            }
        }
        this.wb.write(excelReport.getOutputStream());
    }

    private Map<String, CellStyle> createStyles(Workbook wb, ExcelReport excelReport) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyleWrap[] cellStyleWrapArray = excelReport.getStyles();
        int n = cellStyleWrapArray.length;
        int n2 = 0;
        while (n2 < n) {
            CellStyleWrap cellStyleObj = cellStyleWrapArray[n2];
            CellStyle style = cellStyleObj.createStyle(wb);
            styles.put(cellStyleObj.getName(), style);
            ++n2;
        }
        return styles;
    }

    public static Row createRow(Sheet sheet, int rownum) {
        Row row = sheet.getRow(rownum - 1);
        if (row == null) {
            row = sheet.createRow(rownum - 1);
        }
        return row;
    }

    public static Cell createCell(Row row, int colIndex) {
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            cell = row.createCell(colIndex);
        }
        return cell;
    }

    public static boolean isNotNull(Object value) {
        return value != null && !"".equals(value);
    }

    public CellStyle getStyle(String styleName) {
        if (this.styles != null) {
            CellStyle style = this.styles.get(styleName);
            return style;
        }
        return null;
    }

    public CreationHelper getCreateHelper() {
        return this.createHelper;
    }

    public void setCellValue(Cell cell, Object value) {
        this.setCellValue(cell, value, null);
    }

    public void setCellValue(Cell cell, Object value, String dataType) {
        if (value == null) {
            return;
        }
        if (ExcelFactory.isNotNull(dataType)) {
            if ("String".equals(dataType)) {
                cell.setCellValue(this.getCreateHelper().createRichTextString(value.toString()));
            }
            if ("Number".equals(dataType)) {
                cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
            } else {
                cell.setCellValue(this.getCreateHelper().createRichTextString(value.toString()));
            }
        } else {
            if (value instanceof String) {
                cell.setCellValue(this.getCreateHelper().createRichTextString((String)value));
                return;
            }
            if (value instanceof Number) {
                cell.setCellValue(Double.parseDouble(value.toString()));
                return;
            }
            if (value instanceof Date) {
                cell.setCellValue((Date)value);
                return;
            }
            cell.setCellValue(value.toString());
            return;
        }
    }

    InputStream getTemplateInputStream() {
        File file = new File(this.templatePath);
        if (this.templatePath.lastIndexOf(this.format) > 0) {
            try {
                FileInputStream is = new FileInputStream(file);
                return is;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("templatePath and fileName are  inconsistent");
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        if (templatePath == null) {
            return;
        }
        String path = TextParser.parse((String)templatePath, (CompositeMap)this.context);
        File file = new File(path);
        if (!file.exists()) {
            ServletContext sc = (ServletContext)this.uncertainEngine.getObjectRegistry().getInstanceOfType(ServletContext.class);
            path = sc.getRealPath(path);
            file = new File(path);
            if (file.exists()) {
                this.templatePath = file.getAbsolutePath();
            }
        } else {
            this.templatePath = file.getAbsolutePath();
        }
    }

    public static void mergedRegion(Sheet sheet, CellRangeAddress range) {
        ExcelFactory.mergedRegion(sheet, range.getFirstRow(), range.getLastRow(), range.getFirstColumn(), range.getLastColumn());
    }

    public static void mergedRegion(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        if (firstRow > lastRow || firstColumn > lastColumn) {
            return;
        }
        int i = 0;
        while (i + firstRow <= lastRow) {
            int rowIndex = i + firstRow;
            Row row = sheet.getRow(rowIndex);
            if (row != null) {
                int j = 0;
                while (j + firstColumn <= lastColumn) {
                    Cell cell;
                    int colIndex = j + firstColumn;
                    if ((i != 0 || j != 0) && (cell = row.getCell(colIndex)) != null) {
                        cell.setCellType(3);
                    }
                    ++j;
                }
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("$");
        buffer.append(CellReference.convertNumToColString((int)firstColumn));
        buffer.append("$");
        buffer.append(firstRow + 1);
        buffer.append(":");
        buffer.append("$");
        buffer.append(CellReference.convertNumToColString((int)lastColumn));
        buffer.append("$");
        buffer.append(lastRow + 1);
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)buffer.toString()));
    }
}

