/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99;

import aurora.plugin.bill99.Configuration;
import aurora.plugin.bill99.pos.CerEncode;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SendReceivePKipair {
    private String configFile;

    public SendReceivePKipair(String configFile) {
        this.configFile = configFile;
    }

    public String signMsg(String signMsg) {
        String base64 = "";
        try {
            String signFile = this.getValue("send_sign_pfx_file");
            String key = this.getValue("send_sign_pfx_file_key");
            String psd = this.getValue("send_sign_pfx_file_password");
            KeyStore ks = KeyStore.getInstance("PKCS12");
            String fStr = SendReceivePKipair.class.getClassLoader().getResource(signFile).getPath().replaceAll("%20", " ");
            FileInputStream ksfis = new FileInputStream(fStr);
            BufferedInputStream ksbufin = new BufferedInputStream(ksfis);
            char[] keyPwd = psd.toCharArray();
            ks.load(ksbufin, keyPwd);
            PrivateKey priK = (PrivateKey)ks.getKey(key, keyPwd);
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(priK);
            signature.update(signMsg.getBytes("UTF-8"));
            BASE64Encoder encoder = new BASE64Encoder();
            base64 = encoder.encode(signature.sign());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return base64;
    }

    private String getValue(String key) {
        String value = Configuration.getValue(this.configFile, key);
        return value == null ? "" : value;
    }

    public boolean enCodeByCer(String val, String msg) {
        boolean flag = false;
        try {
            String verifyFile = this.getValue("receive_verify_cer_file");
            String fStr = CerEncode.class.getClassLoader().getResource(verifyFile).getPath();
            FileInputStream inStream = new FileInputStream(fStr);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
            PublicKey pk = cert.getPublicKey();
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(pk);
            signature.update(val.getBytes());
            BASE64Decoder decoder = new BASE64Decoder();
            flag = signature.verify(decoder.decodeBuffer(msg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}

