/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bgtcheck;

import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.ResultSetLoader;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.SqlServiceContext;
import aurora.plugin.bgtcheck.PrepareParameter;
import aurora.service.ServiceThreadLocal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.ocm.IObjectRegistry;

public class DatabaseTool {
    protected IObjectRegistry mRegistry;
    protected ILogger logger;

    public DatabaseTool(IObjectRegistry registry, ILogger logger) {
        this.mRegistry = registry;
        this.logger = logger;
    }

    public static Connection getContextConnection(IObjectRegistry registry) throws SQLException {
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        if (context == null) {
            throw new IllegalStateException("Can not get context from ServiceThreadLocal!");
        }
        SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext((CompositeMap)context);
        Connection conn = sqlServiceContext.getNamedConnection(null);
        if (conn == null) {
            sqlServiceContext.initConnection(registry, null);
            conn = sqlServiceContext.getNamedConnection(null);
        }
        return conn;
    }

    public CompositeMap sqlQueryWithParas(IObjectRegistry registry, String prepareSQL, PrepareParameter[] prepareParameters) throws Exception {
        ResultSet resultSet = null;
        CompositeMap result = new CompositeMap("result");
        PreparedStatement st = null;
        try {
            Connection conn = DatabaseTool.getContextConnection(registry);
            st = conn.prepareStatement(prepareSQL);
            if (prepareParameters != null) {
                int i = 0;
                while (i < prepareParameters.length) {
                    PrepareParameter parameter = prepareParameters[i];
                    parameter.getDataType().setParameter(st, i + 1, parameter.getValue());
                    ++i;
                }
            }
            resultSet = st.executeQuery();
            ResultSetLoader mRsLoader = new ResultSetLoader();
            mRsLoader.setFieldNameCase((byte)2);
            FetchDescriptor desc = FetchDescriptor.fetchAll();
            CompositeMapCreator compositeCreator = new CompositeMapCreator(result);
            mRsLoader.loadByResultSet(resultSet, desc, (IResultSetConsumer)compositeCreator);
        }
        catch (Throwable throwable) {
            DBUtil.closeStatement(st);
            throw throwable;
        }
        DBUtil.closeStatement((Statement)st);
        return result;
    }

    public boolean sqlExecuteWithParas(IObjectRegistry registry, String prepareSQL, PrepareParameter[] prepareParameters) throws SQLException {
        PreparedStatement st = null;
        boolean success = false;
        try {
            Connection conn = DatabaseTool.getContextConnection(registry);
            st = conn.prepareStatement(prepareSQL);
            if (prepareParameters != null) {
                int i = 0;
                while (i < prepareParameters.length) {
                    PrepareParameter parameter = prepareParameters[i];
                    parameter.getDataType().setParameter(st, i + 1, parameter.getValue());
                    ++i;
                }
            }
            success = st.execute();
        }
        catch (Throwable throwable) {
            DBUtil.closeStatement(st);
            throw throwable;
        }
        DBUtil.closeStatement((Statement)st);
        return success;
    }
}

