/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.amq;

import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import aurora.plugin.jms.JMSStub;
import aurora.plugin.jms.MessageDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class AMQClientInstance
extends AbstractLocatableObject
implements ILifeCycle,
JMSStub {
    public static final String PLUGIN = "aurora.plugin.amq";
    private IMessageHandler[] mMessageHandlers;
    private IConsumer[] consumers;
    private String url;
    private IObjectRegistry registry;
    private Logger logger;
    private Map<String, IMessageHandler> handlersMap = new HashMap<String, IMessageHandler>();
    private IMessageDispatcher messageDispatcher;
    private ActiveMQConnectionFactory factory;
    private Map<String, IConsumer> consumerMap;
    private int status = 0;
    private boolean shutdown = false;
    private Thread moniteStartThread;
    private Thread initConsumersThread;

    public AMQClientInstance(IObjectRegistry registry) {
        this.registry = registry;
        this.messageDispatcher = new MessageDispatcher(registry);
    }

    public boolean startup() {
        if (this.status == 1 || this.status == 2) {
            return true;
        }
        this.status = 1;
        this.logger = Logger.getLogger(PLUGIN);
        if (this.url == null) {
            BuiltinExceptionFactory.createOneAttributeMissing((ILocatable)this, (String)"url");
        }
        this.factory = new ActiveMQConnectionFactory(this.url);
        this.registry.registerInstance(ConnectionFactory.class, (Object)this.factory);
        this.consumerMap = new HashMap<String, IConsumer>();
        if (this.consumers != null) {
            int i = 0;
            while (i < this.consumers.length) {
                this.consumerMap.put(this.consumers[i].getTopic(), this.consumers[i]);
                ++i;
            }
        }
        this.initConsumersThread = new Thread(){

            @Override
            public void run() {
                if (AMQClientInstance.this.consumers != null) {
                    int i = 0;
                    while (i < AMQClientInstance.this.consumers.length) {
                        try {
                            AMQClientInstance.this.consumers[i].init((IMessageStub)AMQClientInstance.this);
                        }
                        catch (Exception e) {
                            AMQClientInstance.this.logger.log(Level.SEVERE, "init jms consumers failed!", e);
                        }
                        ++i;
                    }
                }
                AMQClientInstance.this.status = 2;
                LoggingContext.getLogger((String)AMQClientInstance.PLUGIN, (IObjectRegistry)AMQClientInstance.this.registry).log(Level.INFO, "start jms client successful!");
            }
        };
        this.initConsumersThread.start();
        this.moniteStart();
        this.registry.registerInstance(IMessageStub.class, (Object)this);
        return true;
    }

    public void onShutdown() throws Exception {
        this.shutdown = true;
        if (this.moniteStartThread != null) {
            this.moniteStartThread.interrupt();
        }
        if (this.initConsumersThread != null) {
            this.initConsumersThread.interrupt();
        }
        if (this.consumers != null) {
            int i = 0;
            while (i < this.consumers.length) {
                this.consumers[i].onShutdown();
                ++i;
            }
        }
    }

    private void moniteStart() {
        final ILogger logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.registry);
        this.moniteStartThread = new Thread(){

            @Override
            public void run() {
                while (!AMQClientInstance.this.shutdown && AMQClientInstance.this.status != 2) {
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    logger.log(Level.INFO, "Trying to Connect to " + AMQClientInstance.this.url);
                }
            }
        };
        this.moniteStartThread.start();
    }

    public IMessageHandler getMessageHandler(String name) {
        return this.handlersMap.get(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IMessageHandler[] getMessageHandlers() {
        return this.mMessageHandlers;
    }

    public void setMessageHandlers(IMessageHandler[] messageHandlers) {
        this.mMessageHandlers = messageHandlers;
        int i = 0;
        while (i < messageHandlers.length) {
            this.handlersMap.put(messageHandlers[i].getName(), messageHandlers[i]);
            ++i;
        }
    }

    public IConsumer[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IConsumer[] consumers) {
        this.consumers = consumers;
    }

    public ActiveMQConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    public IConsumer getConsumer(String topic) {
        return this.consumerMap.get(topic);
    }

    public void shutdown() {
        try {
            this.onShutdown();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "shutdown jms instance failed!", e);
        }
    }

    public IMessageDispatcher getDispatcher() {
        return this.messageDispatcher;
    }

    @Override
    public Connection createConnection() throws JMSException {
        if (this.factory == null) {
            throw new IllegalStateException("ConnectionFactory is not initialiaze!");
        }
        return this.factory.createConnection();
    }

    public boolean isStarted() {
        return this.status == 2;
    }
}

