/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.alipay;

import aurora.plugin.alipay.AlipayConfig;
import aurora.plugin.alipay.AlipayUtil;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Payment
extends AbstractEntry {
    private String out_trade_no;
    private String subject;
    private String body;
    private String total_fee;
    private String paymethod;
    private String defaultbank;
    private String credit_card_pay;
    private String credit_card_default_display;
    private String extra_common_param;
    private String return_url;
    private String notify_url;

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("UTF-8");
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        CompositeMap model = service.getModel();
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("payment_type", "1");
        sParaTemp.put("out_trade_no", this.getValue(context, this.getOut_trade_no()));
        sParaTemp.put("subject", this.getValue(context, this.getSubject()));
        sParaTemp.put("body", this.getValue(context, this.getBody()));
        sParaTemp.put("total_fee", this.getValue(context, this.getTotal_fee()));
        sParaTemp.put("paymethod", this.getValue(context, this.getPaymethod()));
        sParaTemp.put("defaultbank", this.getValue(context, this.getDefaultbank()));
        sParaTemp.put("credit_card_pay", this.getValue(context, this.getCredit_card_pay()));
        sParaTemp.put("credit_card_default_display", this.getValue(context, this.getCredit_card_default_display()));
        sParaTemp.put("extra_common_param", this.getValue(context, this.getExtra_common_param()));
        sParaTemp.put("return_url", this.getValue(context, this.getReturn_url()));
        sParaTemp.put("notify_url", this.getValue(context, this.getNotify_url()));
        sParaTemp.put("service", "create_direct_pay_by_user");
        sParaTemp.put("partner", AlipayConfig.partner);
        sParaTemp.put("seller_email", AlipayConfig.seller_email);
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        if ("CREDITCARD".equals(this.getValue(context, this.getPaymethod()))) {
            sParaTemp.put("credit_card_pay", AlipayConfig.credit_card_pay);
            sParaTemp.put("credit_card_default_display", AlipayConfig.credit_card_default_display);
        }
        String anti_phishing_key = AlipayUtil.query_timestamp();
        String exter_invoke_ip = AlipayUtil.getIp();
        sParaTemp.put("anti_phishing_key", anti_phishing_key);
        sParaTemp.put("exter_invoke_ip", exter_invoke_ip);
        Map<String, String> sPara = AlipayUtil.buildRequestPara(sParaTemp);
        model.put((Object)"gateway", (Object)AlipayConfig.alipay_gateway);
        ArrayList keys = new ArrayList(sPara.keySet());
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            model.put((Object)name, (Object)value);
            ++i;
        }
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return null;
    }

    public String getOut_trade_no() {
        return this.out_trade_no;
    }

    public void setOut_trade_no(String outTradeNo) {
        this.out_trade_no = outTradeNo;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getTotal_fee() {
        return this.total_fee;
    }

    public void setTotal_fee(String totalFee) {
        this.total_fee = totalFee;
    }

    public String getPaymethod() {
        return this.paymethod;
    }

    public void setPaymethod(String paymethod) {
        this.paymethod = paymethod;
    }

    public String getDefaultbank() {
        return this.defaultbank;
    }

    public void setDefaultbank(String defaultbank) {
        this.defaultbank = defaultbank;
    }

    public String getCredit_card_pay() {
        return this.credit_card_pay;
    }

    public void setCredit_card_pay(String creditCardPay) {
        this.credit_card_pay = creditCardPay;
    }

    public String getCredit_card_default_display() {
        return this.credit_card_default_display;
    }

    public void setCredit_card_default_display(String creditCardDefaultDisplay) {
        this.credit_card_default_display = creditCardDefaultDisplay;
    }

    public String getExtra_common_param() {
        return this.extra_common_param;
    }

    public void setExtra_common_param(String extraCommonParam) {
        this.extra_common_param = extraCommonParam;
    }

    public String getReturn_url() {
        return this.return_url;
    }

    public void setReturn_url(String returnUrl) {
        this.return_url = returnUrl;
    }

    public String getNotify_url() {
        return this.notify_url;
    }

    public void setNotify_url(String notifyUrl) {
        this.notify_url = notifyUrl;
    }
}

