/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.alipay;

import aurora.plugin.alipay.AlipayConfig;
import aurora.plugin.alipay.AlipayCore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AlipayUtil {
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
    private static final String HTTPS_VERIFY_URL = "https://www.alipay.com/cooperate/gateway.do?service=notify_verify&";
    private static final String HTTP_VERIFY_URL = "http://notify.alipay.com/trade/notify_query.do?";

    public static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipayCore.buildMysign(sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", AlipayConfig.sign_type);
        return sPara;
    }

    public static boolean verify(Map<String, String> params) {
        String mysign = AlipayUtil.getMysign(params);
        String responseTxt = "true";
        if (params.get("notify_id") != null) {
            responseTxt = AlipayUtil.verifyResponse(params.get("notify_id"));
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return mysign.equals(sign) && responseTxt.equals("true");
    }

    public static String query_timestamp() throws MalformedURLException, DocumentException, IOException {
        String strUrl = "https://mapi.alipay.com/gateway.do?service=query_timestamp&partner=" + AlipayConfig.partner;
        StringBuffer result = new StringBuffer();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new URL(strUrl).openStream());
        List nodeList = doc.selectNodes("//alipay/*");
        for (Node node : nodeList) {
            if (!node.getName().equals("is_success") || !node.getText().equals("T")) continue;
            List nodeList1 = doc.selectNodes("//response/timestamp/*");
            for (Node node1 : nodeList1) {
                result.append(node1.getText());
            }
        }
        return result.toString();
    }

    public static String getIp() {
        String ip = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            ip = "Bad IP Address!" + e;
            System.out.println("Bad IP Address!" + e);
        }
        return ip;
    }

    private static String getMysign(Map<String, String> Params) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(Params);
        String mysign = AlipayCore.buildMysign(sParaNew);
        return mysign;
    }

    private static String verifyResponse(String notify_id) {
        String transport = AlipayConfig.transport;
        String partner = AlipayConfig.partner;
        String veryfy_url = "";
        veryfy_url = transport.equalsIgnoreCase("https") ? HTTPS_VERIFY_URL : HTTP_VERIFY_URL;
        veryfy_url = String.valueOf(veryfy_url) + "partner=" + partner + "&notify_id=" + notify_id;
        return AlipayUtil.checkUrl(veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }

    public static String getCurrentDate() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String date_now = fmt.format(new Date());
        return date_now;
    }

    public static String getBatchNO(String id) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String date_now = fmt.format(new Date());
        return String.valueOf(date_now) + id;
    }
}

