/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.editor.AttributeValue;

public class CompositeMapEditor {
    CompositeMap mData;
    Element mElement;
    ISchemaManager mSchemaManager;
    List mAttribs;

    public CompositeMapEditor(ISchemaManager schemaManager, CompositeMap data) {
        this.mData = data;
        this.mSchemaManager = schemaManager;
        this.mElement = this.mSchemaManager.getElement(this.mData.getQName());
        if (this.mElement != null) {
            this.mAttribs = this.mElement.getAllAttributes();
        }
    }

    public AttributeValue[] getAttributeList() {
        HashSet<Object> attrName = new HashSet<Object>();
        int total = this.mData.entrySet().size() + (this.mAttribs == null ? 0 : this.mAttribs.size());
        AttributeValue[] values = new AttributeValue[total];
        int i = 0;
        if (this.mElement != null) {
            Collections.sort(this.mAttribs);
            for (Attribute attrib : this.mAttribs) {
                AttributeValue av = new AttributeValue(this.mData, attrib, this.mData.get(attrib.getLocalName()));
                values[i++] = av;
                attrName.add(attrib.getLocalName());
            }
        }
        for (Map.Entry entry : this.mData.entrySet()) {
            String key;
            String string = key = entry.getKey() == null ? null : entry.getKey().toString();
            if (key == null) continue;
            Object value = entry.getValue();
            if (attrName.contains(key)) continue;
            Attribute attrib = Attribute.createInstance(key);
            AttributeValue av = new AttributeValue(this.mData, attrib, value);
            values[i++] = av;
            attrName.add(attrib);
        }
        AttributeValue[] returnValues = new AttributeValue[i];
        System.arraycopy(values, 0, returnValues, 0, i);
        return returnValues;
    }
}

