/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import uncertain.logging.ILoggingTopicRegistry;
import uncertain.logging.LoggingTopic;

public class TopicManager
implements ILoggingTopicRegistry {
    Map mTopicLevelMap = new HashMap();

    public void setTopicLevel(String topic, Level level) {
        this.mTopicLevelMap.put(topic, level);
    }

    public void setTopicLevel(LoggingTopic topic) {
        this.setTopicLevel(topic.getName(), topic.getLevelObject());
    }

    public void setTopicLevel(LoggingTopic[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.setTopicLevel(array[i]);
        }
    }

    public Level getTopicLevel(String topic) {
        Level l = (Level)this.mTopicLevelMap.get(topic);
        if (l == null) {
            return Level.OFF;
        }
        return l;
    }

    public boolean isLoggingEnabled(String topic) {
        return this.getTopicLevel(topic).intValue() < Level.OFF.intValue();
    }

    @Override
    public LoggingTopic[] getLoggingTopics() {
        Collection lst = this.mTopicLevelMap.values();
        LoggingTopic[] array = new LoggingTopic[lst.size()];
        System.arraycopy(lst.toArray(), 0, array, 0, array.length);
        return array;
    }

    @Override
    public void registerLoggingTopic(LoggingTopic topic) {
        this.setTopicLevel(topic);
    }

    @Override
    public void registerLoggingTopic(String topic) {
        LoggingTopic t = new LoggingTopic();
        t.setName(topic);
        t.setLevelObject(Level.WARNING);
        this.registerLoggingTopic(t);
    }
}

