/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite.transform;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.transform.CompositeTransformer;

public class Transformer {
    static Map transformer_instance = new HashMap();

    public static CompositeMap createTransformConfig(String cls_name) {
        CompositeMap config = new CompositeMap(10);
        config.setName("transform");
        config.put("class", cls_name);
        return config;
    }

    public static CompositeMap doTransform(CompositeMap source, CompositeMap config) {
        if (source == null || config == null) {
            return source;
        }
        String cls_name = config.getString("class");
        try {
            CompositeTransformer t = (CompositeTransformer)transformer_instance.get(cls_name);
            if ((t == null || t instanceof Serializable) && !((t = (CompositeTransformer)Class.forName(cls_name).newInstance()) instanceof Serializable)) {
                transformer_instance.put(cls_name, t);
            }
            return t.transform(source, config);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return source;
        }
    }

    public static CompositeMap doBatchTransform(CompositeMap source, Collection config_list) {
        if (source == null || config_list == null) {
            return source;
        }
        for (CompositeMap conf : config_list) {
            source = Transformer.doTransform(source, conf);
        }
        return source;
    }
}

