/*
 * Decompiled with CFR 0.152.
 */
package aurora.security;

import aurora.application.ISessionInfoProvider;
import aurora.security.IResourceAccessChecker;
import uncertain.cache.CacheBuiltinExceptionFactory;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.IGlobalInstance;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class CacheBasedResourceAccessChecker
extends AbstractLocatableObject
implements IResourceAccessChecker,
IGlobalInstance {
    IObjectRegistry mRegistry;
    INamedCacheFactory mCacheFactory;
    ISessionInfoProvider mSessionInfoProvider;
    ICache mResourceCache;
    ICache mAccessCache;
    String resourceCacheName;
    String accessCacheName;
    String accessCacheKeyPrefix;
    String loginFlag;
    String accessCheckFlag;

    public CacheBasedResourceAccessChecker(IObjectRegistry mRegistry) {
        this.mRegistry = mRegistry;
    }

    public void onInitialize() {
        this.mCacheFactory = (INamedCacheFactory)this.mRegistry.getInstanceOfType(INamedCacheFactory.class);
        if (this.mCacheFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, INamedCacheFactory.class, this.getClass().getName());
        }
        this.mSessionInfoProvider = (ISessionInfoProvider)this.mRegistry.getInstanceOfType(ISessionInfoProvider.class);
        if (this.mSessionInfoProvider == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, ISessionInfoProvider.class, this.getClass().getName());
        }
        if (this.accessCacheName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "accessCacheName");
        }
        if (this.resourceCacheName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "resourceCacheName");
        }
        this.mResourceCache = this.mCacheFactory.getNamedCache(this.resourceCacheName);
        if (this.mResourceCache == null) {
            throw CacheBuiltinExceptionFactory.createNamedCacheNotFound(this, this.resourceCacheName);
        }
        this.mAccessCache = this.mCacheFactory.getNamedCache(this.accessCacheName);
        if (this.mAccessCache == null) {
            throw CacheBuiltinExceptionFactory.createNamedCacheNotFound(this, this.accessCacheName);
        }
    }

    @Override
    public String checkAccess(String resource, CompositeMap session_context) {
        String key;
        Object v;
        if (this.mResourceCache == null) {
            throw new RuntimeException("resourceCache initialise failed, please check the log.");
        }
        CompositeMap resource_map = (CompositeMap)this.mResourceCache.getValue(resource);
        if (resource_map == null) {
            return "unregistered";
        }
        Boolean need_login = resource_map.getBoolean(this.loginFlag);
        if (need_login == null) {
            throw new RuntimeException(this.loginFlag + " not defined in " + resource_map.toXML());
        }
        Boolean need_access_check = resource_map.getBoolean(this.accessCheckFlag);
        if (need_access_check == null) {
            throw new RuntimeException(this.accessCheckFlag + " not defined in " + resource_map.toXML());
        }
        boolean is_logged_in = this.mSessionInfoProvider.isLoggedin(session_context);
        if (!is_logged_in && need_login.booleanValue()) {
            return "login_required";
        }
        if (need_access_check.booleanValue() && (v = this.mAccessCache.getValue(key = this.accessCacheKeyPrefix == null ? resource : TextParser.parse(this.accessCacheKeyPrefix, session_context) + resource)) == null) {
            return "unauthorized";
        }
        return "success";
    }

    public String getResourceCacheName() {
        return this.resourceCacheName;
    }

    public void setResourceCacheName(String resourceCacheName) {
        this.resourceCacheName = resourceCacheName;
    }

    public String getAccessCacheName() {
        return this.accessCacheName;
    }

    public void setAccessCacheName(String accessCacheName) {
        this.accessCacheName = accessCacheName;
    }

    public String getAccessCacheKeyPrefix() {
        return this.accessCacheKeyPrefix;
    }

    public void setAccessCacheKeyPrefix(String accessCacheKeyPrefix) {
        this.accessCacheKeyPrefix = accessCacheKeyPrefix;
    }

    public String getLoginFlag() {
        return this.loginFlag;
    }

    public void setLoginFlag(String loginFlag) {
        this.loginFlag = loginFlag;
    }

    public String getAccessCheckFlag() {
        return this.accessCheckFlag;
    }

    public void setAccessCheckFlag(String accessCheckFlag) {
        this.accessCheckFlag = accessCheckFlag;
    }

    public ICache getResourceCache() {
        return this.mResourceCache;
    }
}

