/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.InputFieldConfig;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class NumberFieldConfig
extends InputFieldConfig {
    public static final String VERSION = "$Revision: 7968 $";
    public static final String TAG_NAME = "numberField";
    public static final String PROPERTITY_ALLOWDECIMALS = "allowdecimals";
    public static final String PROPERTITY_DECIMALPRECISION = "decimalprecision";
    public static final String PROPERTITY_ALLOWNEGATIVE = "allownegative";
    public static final String PROPERTITY_ALLOWFORMAT = "allowformat";
    public static final String PROPERTITY_ALLOWPAD = "allowpad";
    public static final String PROPERTITY_MIN = "min";
    public static final String PROPERTITY_MAX = "max";

    public static NumberFieldConfig getInstance() {
        NumberFieldConfig model = new NumberFieldConfig();
        model.initialize(NumberFieldConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static NumberFieldConfig getInstance(CompositeMap context) {
        NumberFieldConfig model = new NumberFieldConfig();
        model.initialize(NumberFieldConfig.createContext(context, TAG_NAME));
        return model;
    }

    public boolean isAllowFormat() {
        return this.getBoolean(PROPERTITY_ALLOWFORMAT, false);
    }

    public void setAllowFormat(boolean format) {
        this.putBoolean(PROPERTITY_ALLOWFORMAT, format);
    }

    public boolean isAllowPad() {
        return this.getBoolean(PROPERTITY_ALLOWPAD, true);
    }

    public void setAllowPad(boolean pad) {
        this.putBoolean(PROPERTITY_ALLOWPAD, pad);
    }

    public boolean isAllowDecimals() {
        return this.getBoolean(PROPERTITY_ALLOWDECIMALS, true);
    }

    public void setAllowDecimals(boolean allowed) {
        this.putBoolean(PROPERTITY_ALLOWDECIMALS, allowed);
    }

    public boolean isAllowNegative() {
        return this.getBoolean(PROPERTITY_ALLOWNEGATIVE, true);
    }

    public void setAllowNegative(boolean allowed) {
        this.putBoolean(PROPERTITY_ALLOWNEGATIVE, allowed);
    }

    public int getDecimalPrecision(CompositeMap model) {
        String pre = this.getString(PROPERTITY_DECIMALPRECISION, "2");
        pre = TextParser.parse(pre, model);
        return Integer.valueOf(pre);
    }

    public void setDecimalPrecision(int precision) {
        this.putInt(PROPERTITY_DECIMALPRECISION, precision);
    }

    public String getMin() {
        return this.getString(PROPERTITY_MIN);
    }

    public void setMin(String min) {
        this.putString(PROPERTITY_MIN, min);
    }

    public String getMax() {
        return this.getString(PROPERTITY_MAX);
    }

    public void setMax(String max) {
        this.putString(PROPERTITY_MAX, max);
    }
}

