/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class GridLayouConfig
extends ComponentConfig {
    public static final String VERSION = "$Revision: 7671 $";
    public static final String PROPERTITY_CELLPADDING = "cellpadding";
    public static final String PROPERTITY_CELLSPACING = "cellspacing";
    public static final String PROPERTITY_VALIDALIGN = "validalign";
    public static final String PROPERTITY_PADDING = "padding";
    public static final String PROPERTITY_ROW = "row";
    public static final String PROPERTITY_COLUMN = "column";
    public static final String PROPERTITY_WRAPPER_ADJUST = "wrapperadjust";
    public static final String PROPERTITY_ROWSPAN = "rowspan";
    public static final String PROPERTITY_COLSPAN = "colspan";

    public int getCellPadding(CompositeMap model) {
        String str = TextParser.parse(this.getString(PROPERTITY_CELLPADDING), model);
        if (null == str || "".equals(str)) {
            return 0;
        }
        return Integer.valueOf(str);
    }

    public void setCellPadding(int padding) {
        this.putInt(PROPERTITY_CELLPADDING, padding);
    }

    public int getCellSpacing(CompositeMap model) {
        String str = TextParser.parse(this.getString(PROPERTITY_CELLSPACING), model);
        if (null == str || "".equals(str)) {
            return 0;
        }
        return Integer.valueOf(str);
    }

    public void setCellSpacing(int v) {
        this.putInt(PROPERTITY_CELLSPACING, v);
    }

    public int getPadding(CompositeMap model, int defaultValue) {
        String str = TextParser.parse(this.getString(PROPERTITY_PADDING), model);
        if (null == str || "".equals(str)) {
            return defaultValue;
        }
        return Integer.valueOf(str);
    }

    public void setPadding(int v) {
        this.putInt(PROPERTITY_PADDING, v);
    }

    public boolean isWrapperAdjust() {
        return this.getBoolean(PROPERTITY_WRAPPER_ADJUST, false);
    }

    public void setWrapperAdjust(boolean v) {
        this.putBoolean(PROPERTITY_WRAPPER_ADJUST, v);
    }

    public int getRow(CompositeMap model, int defaultValue) {
        String str = TextParser.parse(this.getString(PROPERTITY_ROW), model);
        if (null == str || "".equals(str)) {
            return defaultValue;
        }
        return Integer.valueOf(str);
    }

    public void setRow(int row) {
        this.putInt(PROPERTITY_ROW, row);
    }

    public int getColumn(CompositeMap model, int defaultValue) {
        String str = TextParser.parse(this.getString(PROPERTITY_COLUMN), model);
        if (null == str || "".equals(str)) {
            return defaultValue;
        }
        return Integer.valueOf(str);
    }

    public void setColumn(int column) {
        this.putInt(PROPERTITY_COLUMN, column);
    }
}

