/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Switch
implements IViewBuilder {
    public static final String VERSION = "$Revision: 7797 $";
    private static final String TEST_FIELD = "test";
    private static final String KEY_VALUE = "value";

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        CompositeMap model = view_context.getModel();
        CompositeMap view = view_context.getView();
        if (model == null) {
            return;
        }
        String testField = view.getString(TEST_FIELD);
        if (testField == null) {
            throw new ViewCreationException("selector: No test field specified");
        }
        Object obj = model.getObject(testField);
        Iterator it = view.getChildIterator();
        if (it == null) {
            throw new ViewCreationException("selector:No case found");
        }
        List child_views = null;
        while (it.hasNext()) {
            CompositeMap child = (CompositeMap)it.next();
            Object test_value = child.get(KEY_VALUE);
            if ("null".equals(test_value) && obj == null) {
                child_views = child.getChilds();
                break;
            }
            if (test_value == null) {
                child_views = child.getChilds();
                break;
            }
            String vl = test_value.toString();
            if ("*".equals(vl)) {
                child_views = child.getChilds();
                break;
            }
            vl = TextParser.parse(vl, model);
            if (obj == null || !vl.equals(obj.toString())) continue;
            child_views = child.getChilds();
            break;
        }
        if (child_views != null) {
            try {
                session.buildViews(model, child_views);
            }
            catch (Exception e) {
                throw new ViewCreationException(e);
            }
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

