/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.features.cstm.CustomSourceCode;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.component.std.config.QueryFormConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.schema.Array;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;

public class QueryForm
extends Component
implements IViewBuilder {
    public static final String VERSION = "$Revision: 7794 $";
    private static final String DEFAULT_TABLE_CLASS = "layout-table";
    private static final String DEFAULT_WRAP_CLASS = "form_body_wrap";
    private static final String DEFAULT_HEAD_CLASS = "form_head";
    private static final String FORM_TOOL_BAR = "formToolBar";
    private static final String FORM_BODY = "formBody";
    private static final String DEFAULT_QUERY_PROMPT = "HAP_QUERY";
    private static final String DEFAULT_MORE_PROMPT = "HAP_MORE";
    private static final String DEFAUTL_BUTTON_THEME = "item-rbtn-gray";
    IObjectRegistry mObjectRegistry;
    private ISchemaManager schemaManager;
    private String ds;
    private CompositeMap formToolBar;
    private CompositeMap formBody;

    @Override
    protected int getDefaultWidth() {
        return 0;
    }

    @Override
    protected int getDefaultHeight() {
        return 0;
    }

    public QueryForm(IObjectRegistry reg) {
        super(reg);
        this.mObjectRegistry = reg;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        this.schemaManager = (ISchemaManager)this.mObjectRegistry.getInstanceOfType(ISchemaManager.class);
        if (this.schemaManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(new CompositeMap().asLocatable(), ISchemaManager.class, CustomSourceCode.class.getCanonicalName());
        }
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        Map map = view_context.getMap();
        QueryFormConfig qfc = QueryFormConfig.getInstance(view);
        this.id = view.getString("id", "");
        if ("".equals(this.id)) {
            this.id = IDGenerator.getInstance().generate();
        }
        this.ds = view.getString("bindtarget");
        String result_ds = qfc.getResultTarget();
        String style = qfc.getStyle("");
        boolean open = qfc.isExpand();
        int width = this.getComponentWidth(model, view, map);
        int height = this.getComponentHeight(model, view, map);
        String className = "layout-table query-form layout-title" + view.getString("classname", "");
        String title = session.getLocalizedPrompt(qfc.getTitle());
        String queryhook = qfc.getQueryHook();
        String queryfield = qfc.getDefaultQueryField();
        Writer out = session.getWriter();
        try {
            this.processFormToolBar(view, session, model);
            boolean hasBody = this.processFormBody(this.id, view, session, model, height);
            out.write("<table cellspacing='0' cellpadding='0' class='" + className + "' id='" + this.id + "'");
            if (width != 0) {
                style = "width:" + width + "px;" + style;
            }
            if (!"".equals(style)) {
                out.write(" style='" + style + "'");
            }
            out.write("><thead>");
            if (!"".equals(title)) {
                out.write("<tr><th class='form_head'>" + title + "</th></tr>");
            }
            out.write("<tr><th class='query_form_head'>");
            session.buildView(model, this.formToolBar);
            out.write("</th></tr></thead>");
            if (hasBody) {
                out.write("<tbody ");
                if (!open) {
                    out.write(" style='display:none'");
                }
                out.write("><tr><td><div class='form_body_wrap'>");
                session.buildView(model, this.formBody);
                out.write("</div></td></tr></tbody>");
            } else {
                open = false;
            }
            out.write("</table>");
            out.write("<script>");
            out.write("new $A.QueryForm({id:'" + this.id + "',isopen:" + open + ",resulttarget:'" + result_ds + "',");
            out.write(null == queryhook ? "queryfield:'" + queryfield + "'" : "queryhook:" + queryhook);
            out.write("});");
            if (null != this.ds) {
                out.write("$('" + this.id + "').bind('" + this.ds + "');");
            }
            out.write("</script>");
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }

    private void processFormToolBar(CompositeMap view, BuildSession session, CompositeMap model) throws Exception {
        this.formToolBar = view.getChild(FORM_TOOL_BAR);
        CompositeMap searchField = null;
        QueryFormConfig qfc = QueryFormConfig.getInstance(view);
        String hint = qfc.getDefaultQueryHint();
        String queryPrompt = qfc.getDefaultQueryPromt();
        String queryId = this.id + "_query";
        String style = "";
        String searchFunction = "function(){$('" + this.id + "').doSearch()}";
        boolean createSearchButton = qfc.isCreateSearchButton();
        if (null == this.formToolBar || null == this.formToolBar.getChildIterator()) {
            if (null == this.formToolBar) {
                this.formToolBar = new CompositeMap("hBox");
                this.formToolBar.setNameSpaceURI("http://www.aurora-framework.org/application");
            } else {
                this.formToolBar.setName("hBox");
                style = this.formToolBar.getString("style", "");
            }
            searchField = new CompositeMap("textField");
            searchField.setNameSpaceURI("http://www.aurora-framework.org/application");
            searchField.putString("style", "width:100%");
            searchField.putString("id", queryId);
            CompositeMap events = searchField.getChild("events");
            if (null == events) {
                events = new CompositeMap("events");
                events.setNameSpaceURI("http://www.aurora-framework.org/application");
                searchField.addChild(events);
            }
            CompositeMap event = new CompositeMap("event");
            event.setNameSpaceURI("http://www.aurora-framework.org/application");
            event.putString("name", "enterdown");
            event.putString("handler", searchFunction);
            events.addChild(event);
            if (null != hint) {
                searchField.putString("emptytext", session.getLocalizedPrompt(hint));
            }
            if (null != queryPrompt) {
                searchField.putString("prompt", session.getLocalizedPrompt(queryPrompt));
            }
            CompositeMap btn = new CompositeMap("toolbarButton");
            btn.setNameSpaceURI("http://www.aurora-framework.org/application");
            btn.putString("classname", DEFAUTL_BUTTON_THEME);
            btn.putString("text", session.getLocalizedPrompt(DEFAULT_QUERY_PROMPT));
            btn.putInt("width", 80);
            btn.putString("click", searchFunction);
            this.formToolBar.putString("style", "width:100%;" + style);
            this.formToolBar.addChild(searchField);
            this.formToolBar.addChild(btn);
        } else {
            this.formToolBar.setName("hBox");
            this.bindDataset(this.id, this.formToolBar);
            style = this.formToolBar.getString("style", "");
            if (createSearchButton) {
                CompositeMap btn = new CompositeMap("toolbarButton");
                btn.setNameSpaceURI("http://www.aurora-framework.org/application");
                btn.putString("classname", DEFAUTL_BUTTON_THEME);
                btn.putString("text", session.getLocalizedPrompt(DEFAULT_QUERY_PROMPT));
                btn.putInt("width", 80);
                btn.putString("click", searchFunction);
                this.formToolBar.putString("style", "width:100%;" + style);
                this.formToolBar.addChild(btn);
            }
        }
        this.formToolBar.putBoolean("wrapperadjust", true);
        this.formToolBar.putString("style", "width:100%;" + style);
    }

    private boolean processFormBody(String id, CompositeMap view, BuildSession session, CompositeMap model, int height) throws Exception {
        this.formBody = view.getChild(FORM_BODY);
        if (null != this.formBody && null != this.formBody.getChildIterator()) {
            this.bindDataset(id, this.formBody);
            this.formBody.setName("box");
            if (height != 0) {
                this.formBody.put("height", (Object)(height - 26));
            }
            CompositeMap btn = new CompositeMap("toolbarButton");
            btn.setNameSpaceURI("http://www.aurora-framework.org/application");
            btn.putString("classname", DEFAUTL_BUTTON_THEME);
            btn.putString("style", "float:right");
            btn.putString("text", session.getLocalizedPrompt(DEFAULT_MORE_PROMPT));
            btn.putInt("width", 80);
            btn.putString("click", "function(){$('" + id + "').trigger()}");
            this.formToolBar.addChild(btn);
            return true;
        }
        return false;
    }

    private void bindDataset(String id, CompositeMap parent) {
        Iterator it;
        if (null != this.ds && null != parent && null != (it = parent.getChildIterator())) {
            QualifiedName bindTarget = new QualifiedName("bindTarget");
            while (it.hasNext()) {
                CompositeMap child = (CompositeMap)it.next();
                Element ele = this.schemaManager.getElement(child);
                if (ele != null) {
                    for (Attribute attr : ele.getAllAttributes()) {
                        if (!bindTarget.equals(attr.getQName())) continue;
                        child.putString("bindtarget", this.ds);
                        break;
                    }
                }
                this.bindDataset(id, child);
                this.addEnterDownHanlder(id, child);
            }
        }
    }

    private void addEnterDownHanlder(String id, CompositeMap item) {
        Element ele = this.schemaManager.getElement(item);
        Iterator arrays = ele.getAllArrays().iterator();
        boolean hasEvents = false;
        while (arrays.hasNext()) {
            Array arr = (Array)arrays.next();
            if (!"a:events".equals(arr.getName())) continue;
            hasEvents = true;
            break;
        }
        if (hasEvents) {
            CompositeMap events = item.getChild("events");
            if (events == null) {
                events = new CompositeMap("events");
                events.setNameSpace(null, "http://www.aurora-framework.org/application");
                item.addChild(events);
            }
            List list = events.getChilds();
            boolean hasEnterDown = false;
            if (list != null) {
                for (CompositeMap event : list) {
                    EventConfig eventConfig = EventConfig.getInstance(event);
                    String eventName = eventConfig.getEventName();
                    if (!"enterdown".equals(eventName)) continue;
                    hasEnterDown = true;
                    break;
                }
            }
            if (!hasEnterDown) {
                EventConfig evt = EventConfig.getInstance();
                evt.setEventName("enterdown");
                evt.setHandler("function(){$('" + id + "').doSearch()}");
                events.addChild(evt.getObjectContext());
            }
        }
    }
}

