/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.TextField;
import aurora.presentation.component.std.config.DatePickerConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.ocm.IObjectRegistry;

public class DatePicker
extends TextField {
    private static final String VERSION = "$Revision: 7794 $";
    public static final String BODY = "body";

    public DatePicker(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        DatePickerConfig dpc = DatePickerConfig.getInstance(context.getView());
        int viewSize = dpc.getViewSize();
        if (viewSize > 4) {
            viewSize = 4;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < viewSize; ++i) {
            sb.append("<TD valign='top' id='" + this.id + "_df" + i + "'></TD>");
        }
        map.put(BODY, sb.toString());
        this.addConfig("viewsize", new Integer(viewSize));
        Integer width = (Integer)map.get("width");
        map.put("inputwidth", new Integer(width - 23));
        if (null != dpc.getDayRenderer()) {
            this.addConfig("dayrenderer", dpc.getDayRenderer());
        }
        this.addConfig("enablemonthbtn", dpc.getEnableMonthBtn());
        this.addConfig("enableyearbtn", dpc.getEnableYearBtn());
        this.addConfig("enablebesidedays", dpc.getEnableBesideDays());
        this.addConfig("format", dpc.getFormat());
        map.put("config", this.getConfigString());
    }
}

