/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.ApplicationViewConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.component.std.GridLayout;
import aurora.presentation.component.std.config.BoxConfig;
import java.io.Writer;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class Box
extends GridLayout {
    public static final String VERSION = "$Revision: 7795 $";
    private static final String DEFAULT_TH_CLASS = "layout-th";
    UncertainEngine ue;

    public Box(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected void beforeBuildCell(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap field) throws Exception {
        BoxConfig bc = new BoxConfig();
        ApplicationViewConfig view_config = this.mApplicationConfig.getApplicationViewConfig();
        bc.initialize(view);
        Writer out = session.getWriter();
        String vlabel = field.getString("prompt");
        String label = vlabel == null ? this.getFieldPrompt(session, field, field.getString("bindtarget", "")) : vlabel;
        String id = field.getString("id", "");
        label = session.getLocalizedPrompt(label);
        int labelWidth = bc.getLabelWidth(model);
        int rowspan = field.getInt("rowspan", 1);
        String labelSeparator = bc.getLabelSeparator() == null ? view_config.getDefaultLabelSeparator() : bc.getLabelSeparator();
        StringBuffer str = new StringBuffer();
        if (!"".equals(label)) {
            str.append("<th class='layout-th' ");
            if (rowspan > 1) {
                str.append(" rowspan='" + rowspan + "'");
            }
            String ps = field.getString("promptstyle");
            boolean hidden = field.getBoolean("hidden", false);
            if (!"".equals(ps)) {
                str.append(" style='" + ps + "' ");
            }
            str.append("width=" + labelWidth + "><div");
            if (!"".equals(id)) {
                str.append(" id='" + id + "_prompt'");
            }
            if (hidden) {
                str.append(" style='visibility:hidden'");
            }
            str.append(">");
            str.append(label + labelSeparator + "</div></th>");
        } else {
            str.append("<th class='layout-th'");
            if (rowspan > 1) {
                str.append(" rowspan='" + rowspan + "'");
            }
            str.append("></th>");
        }
        out.write(str.toString());
    }
}

