/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ISingleton;

public class DefaultViewBuilder
implements IViewBuilder,
ISingleton {
    private static String getParsedContent(BuildSession session, String text, CompositeMap model) throws IOException {
        return session.parseString(text, model);
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        String close_tag = "</" + view.getName() + ">";
        Writer out = session.getWriter();
        out.write(60);
        out.write(view.getName());
        if (view.size() > 0) {
            for (Map.Entry entry : view.entrySet()) {
                Object key = entry.getKey();
                if (key == null) continue;
                out.write(32);
                out.write(key.toString());
                out.write("=\"");
                Object value = entry.getValue();
                if (value != null) {
                    out.write(DefaultViewBuilder.getParsedContent(session, value.toString(), model));
                }
                out.write(34);
            }
        }
        out.write(62);
        List childs = view.getChilds();
        if (childs != null) {
            try {
                session.buildViews(model, childs);
            }
            catch (Exception ex) {
                throw new ViewCreationException(ex);
            }
            out.write(close_tag);
        } else {
            String text = view.getText();
            if (text != null) {
                out.write(DefaultViewBuilder.getParsedContent(session, text, model));
                out.write(close_tag);
            } else {
                out.write(close_tag);
            }
        }
        out.flush();
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

