/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource.nativejdbc;

import aurora.datasource.nativejdbc.INativeJdbcExtractor;
import java.lang.reflect.Method;
import java.sql.Connection;

public class WebSphereNativeJdbcExtractor
implements INativeJdbcExtractor {
    private static final String JDBC_ADAPTER_CONNECTION_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
    private static final String JDBC_ADAPTER_UTIL_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcUtil";
    private static final String CONNECTION_PROXY_NAME_4 = "com.ibm.ejs.cm.proxy.ConnectionProxy";
    private Class webSphere5ConnectionClass;
    private Class webSphere4ConnectionClass;
    private Method webSphere5NativeConnectionMethod;
    private Method webSphere4PhysicalConnectionMethod;

    public WebSphereNativeJdbcExtractor() {
        try {
            this.webSphere5ConnectionClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_CONNECTION_NAME_5);
            Class<?> jdbcAdapterUtilClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_UTIL_NAME_5);
            this.webSphere5NativeConnectionMethod = jdbcAdapterUtilClass.getMethod("getNativeConnection", this.webSphere5ConnectionClass);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not find WebSphere 5 connection pool classes", ex);
        }
        try {
            this.webSphere4ConnectionClass = this.getClass().getClassLoader().loadClass(CONNECTION_PROXY_NAME_4);
            this.webSphere4PhysicalConnectionMethod = this.webSphere4ConnectionClass.getMethod("getPhysicalConnection", null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not find WebSphere 4 connection pool classes", ex);
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    @Override
    public Connection getNativeConnection(Connection con) {
        if (this.webSphere5ConnectionClass != null && this.webSphere5ConnectionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.webSphere5NativeConnectionMethod.invoke(null, con);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not invoke WebSphere5's getNativeConnection method", ex);
            }
        }
        if (this.webSphere4ConnectionClass != null && this.webSphere4ConnectionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.webSphere4PhysicalConnectionMethod.invoke((Object)con, (Object[])null);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not invoke WebSphere4's getPhysicalConnection method", ex);
            }
        }
        throw new RuntimeException("Connection [" + con + "] is not a WebSphere 5/4 connection, returning as-is.");
    }
}

