/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.local.oracle.sql;

import aurora.database.local.oracle.sql.OracleInsertStatement;
import aurora.database.local.oracle.sql.ReturningIntoStatement;
import aurora.database.profile.ISqlBuilderRegistry;
import aurora.database.sql.FieldWithSource;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.builder.AbstractSqlBuilder;
import aurora.database.sql.builder.DefaultInsertBuilder;

public class OracleSqlBuilder
extends AbstractSqlBuilder {
    DefaultInsertBuilder mInsertBuilder = new DefaultInsertBuilder();

    public String createSql(ReturningIntoStatement stmt) {
        StringBuffer sql = new StringBuffer();
        StringBuffer fields = new StringBuffer();
        StringBuffer into_target = new StringBuffer();
        int i = 0;
        for (FieldWithSource field : stmt.getFields()) {
            if (i > 0) {
                fields.append(",");
                into_target.append(",");
            }
            fields.append(field.getFieldName());
            into_target.append(this.mRegistry.getSql(field.getUpdateSource()));
            ++i;
        }
        if (i == 0) {
            throw new IllegalArgumentException("ReturningIntoStatement doesn't contain any field");
        }
        sql.append(" RETURNING ");
        sql.append(fields.toString());
        sql.append(" INTO ");
        sql.append(into_target.toString());
        return sql.toString();
    }

    public String createSql(OracleInsertStatement stmt) {
        StringBuffer sql = new StringBuffer(this.mInsertBuilder.createSql(stmt));
        ReturningIntoStatement rt_into = stmt.getReturningInto();
        if (rt_into != null && rt_into.getFields().size() > 0) {
            sql.append(" ");
            sql.append(this.createSql(rt_into)).append("; END;");
            sql.insert(0, "BEGIN ");
        }
        return sql.toString();
    }

    @Override
    public String createSql(ISqlStatement sqlStatement) {
        if (sqlStatement instanceof ReturningIntoStatement) {
            return this.createSql((ReturningIntoStatement)sqlStatement);
        }
        if (sqlStatement instanceof OracleInsertStatement) {
            return this.createSql((OracleInsertStatement)sqlStatement);
        }
        return null;
    }

    @Override
    public void setRegistry(ISqlBuilderRegistry registry) {
        super.setRegistry(registry);
        this.mInsertBuilder.setRegistry(registry);
    }

    void registerOracleSql() {
        this.mRegistry.registerSqlBuilder(ReturningIntoStatement.class, this);
        this.mRegistry.registerSqlBuilder(OracleInsertStatement.class, this);
    }
}

