/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.util.ILoggingConifg;
import aurora.application.util.LoggingConfig;
import aurora.service.ServiceInstance;
import java.util.logging.Handler;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.DirectoryConfig;
import uncertain.core.IGlobalInstance;
import uncertain.core.ILifeCycle;
import uncertain.core.UncertainEngine;
import uncertain.event.IContextListener;
import uncertain.event.RuntimeContext;
import uncertain.exception.ProgrammingException;
import uncertain.logging.BasicFileHandler;
import uncertain.logging.DefaultPerObjectLoggingConfig;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.ILoggerProviderGroup;
import uncertain.logging.IPerObjectLoggingConfig;
import uncertain.logging.LoggerProvider;
import uncertain.logging.LoggerProviderGroup;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;

public class ServiceLogging
extends LoggerProvider
implements IGlobalInstance,
IContextListener,
IConfigurable,
ILifeCycle {
    private static final String SERVICE_LOGGING_FILE = "SERVICE_LOGGING_FILE";
    UncertainEngine mEngine;
    IObjectRegistry mRegistry;
    DirectoryConfig mDirConfig;
    OCManager mOcManager;
    String mPattern;
    CompositeMap mConfig;
    boolean mAppend;
    boolean mEnablePerServiceConfig = false;
    IPerObjectLoggingConfig mPerObjectLoggingConfig;

    public ServiceLogging(UncertainEngine engine) {
        this.mEngine = engine;
        this.mRegistry = engine.getObjectRegistry();
        this.mOcManager = engine.getOcManager();
        this.mDirConfig = engine.getDirectoryConfig();
    }

    public String getLogFilePath(String prefix, CompositeMap context) {
        if (this.mPattern != null) {
            prefix = prefix + TextParser.parse(this.mPattern, context);
        }
        return prefix;
    }

    public String getLogFilePath(ServiceInstance svc) {
        return this.getLogFilePath(svc.getName(), svc.getContextMap());
    }

    BasicFileHandler createNewHandler(String name) {
        BasicFileHandler handler = new BasicFileHandler();
        this.mOcManager.populateObject(this.mConfig, handler);
        handler.setLogFilePrefix(name);
        handler.setLogPath(this.getLogPath());
        return handler;
    }

    BasicFileHandler getLogHandler(String name) {
        return this.createNewHandler(name);
    }

    private LoggerProvider createDefaultLoggerProvider() {
        LoggerProvider provider = new LoggerProvider(this.getTopicManager());
        provider.setDefaultLogLevel(this.getDefaultLogLevel());
        return provider;
    }

    @Override
    public void onContextCreate(RuntimeContext context) {
        ServiceInstance svc = ServiceInstance.getInstance(context.getObjectContext());
        if (svc == null) {
            throw new IllegalStateException("No ServiceInstance set in context");
        }
        ILoggerProvider provider = null;
        boolean is_trace = false;
        if (this.mEnablePerServiceConfig) {
            String name = svc.getName();
            is_trace = this.mPerObjectLoggingConfig.getTraceFlag(name);
            provider = this.mPerObjectLoggingConfig.getLoggerProvider(name);
            if (provider == null) {
                provider = this.createDefaultLoggerProvider();
            }
            if (!(provider instanceof LoggerProvider)) {
                throw new ProgrammingException("Must return LoggerProvider instance");
            }
        } else {
            is_trace = svc.isTraceOn();
            provider = this.createDefaultLoggerProvider();
        }
        if (!is_trace) {
            return;
        }
        String file_name = this.getLogFilePath(svc);
        BasicFileHandler handler = this.getLogHandler(file_name);
        ((LoggerProvider)provider).addHandles(new Handler[]{handler});
        context.setInstanceOfType(BasicFileHandler.class, handler);
        ILoggerProvider lp = (ILoggerProvider)context.getInstanceOfType(ILoggerProvider.class);
        if (lp == null) {
            context.setInstanceOfType(ILoggerProvider.class, provider);
        } else if (lp instanceof ILoggerProviderGroup) {
            ((ILoggerProviderGroup)((Object)lp)).addLoggerProvider(provider);
        } else {
            LoggerProviderGroup group = new LoggerProviderGroup();
            group.addLoggerProvider(provider);
            group.addLoggerProvider(lp);
            context.setInstanceOfType(ILoggerProvider.class, group);
        }
        context.put(SERVICE_LOGGING_FILE, handler.getCurrentLogFile().getPath());
    }

    @Override
    public void onContextDestroy(RuntimeContext context) {
        BasicFileHandler handler = (BasicFileHandler)context.getInstanceOfType(BasicFileHandler.class);
        if (handler != null) {
            handler.flush();
            handler.close();
        }
    }

    public String getPattern() {
        return this.mPattern;
    }

    public void setPattern(String pattern) {
        this.mPattern = pattern;
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        this.mConfig = config;
    }

    @Override
    public void endConfigure() {
    }

    public void onInitialize() {
        this.mRegistry.registerInstance(ServiceLogging.class, this);
        if (this.mEnablePerServiceConfig) {
            ILoggingConifg loggingConfig;
            this.mPerObjectLoggingConfig = (IPerObjectLoggingConfig)this.mRegistry.getInstanceOfType(IPerObjectLoggingConfig.class);
            if (this.mPerObjectLoggingConfig == null) {
                this.mPerObjectLoggingConfig = new DefaultPerObjectLoggingConfig();
                this.mRegistry.registerInstance(IPerObjectLoggingConfig.class, this.mPerObjectLoggingConfig);
            }
            if ((loggingConfig = (ILoggingConifg)this.mRegistry.getInstanceOfType(ILoggingConifg.class)) == null) {
                loggingConfig = new LoggingConfig(this.mRegistry);
                this.mRegistry.registerInstance(ILoggingConifg.class, loggingConfig);
            }
        }
    }

    public void onShutdown() {
    }

    public boolean getAppend() {
        return this.mAppend;
    }

    public void setAppend(boolean append) {
        this.mAppend = append;
    }

    public boolean getEnablePerServiceConfig() {
        return this.mEnablePerServiceConfig;
    }

    public void setEnablePerServiceConfig(boolean enablePerServiceConfig) {
        this.mEnablePerServiceConfig = enablePerServiceConfig;
    }

    @Override
    public String getLogPath() {
        String path = super.getLogPath();
        if (path == null) {
            return this.mDirConfig.getLogDirectory();
        }
        return this.mDirConfig.translateRealPath(path);
    }

    @Override
    public boolean startup() {
        this.onInitialize();
        return true;
    }

    @Override
    public void shutdown() {
    }
}

