/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model.asm;

import aurora.application.sourcecode.SourceCodeUtil;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.source.gen.SourceGenManager;
import aurora.plugin.source.gen.SourceTemplateProvider;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.asm.ModelCreator;
import aurora.plugin.source.gen.screen.model.asm.PageGeneratorConfig;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class PageGenerator
extends AbstractEntry {
    private DatabaseServiceFactory svcFactory;
    private PageGeneratorConfig config = PageGeneratorConfig.getInstance();
    private CompositeMap context;
    String pageId;
    boolean saveUip = false;
    private IObjectRegistry registry;
    private File webHome;

    public PageGenerator(IObjectRegistry registry, DatabaseServiceFactory svcFactory) {
        this.registry = registry;
        this.svcFactory = svcFactory;
        this.webHome = SourceCodeUtil.getWebHome((IObjectRegistry)registry);
    }

    public CompositeMap gen() throws Exception {
        CompositeMap pageMap = this.getContext().getChild("parameter");
        if (pageMap != null) {
            ModelCreator creator = new ModelCreator(this.svcFactory, this.context);
            creator.setTemplateType(pageMap.getString((Object)"page_tpl"));
            ScreenBody model = (ScreenBody)creator.create(pageMap);
            Object2CompositeMap o2c = new Object2CompositeMap();
            pageMap.put((Object)"status", (Object)"GEN");
            String page_path = this.getPageFullPath(pageMap);
            pageMap.put((Object)"page_path", (Object)page_path);
            CompositeMap uipModel = o2c.createCompositeMap(model);
            if (this.isSaveUip()) {
                this.writeScreenFile(uipModel, page_path + ".uip");
            }
            this.createScreen(uipModel, page_path);
            this.updatePageMap(pageMap);
        }
        return pageMap;
    }

    private String getPageFullPath(CompositeMap pageMap) {
        return String.format("modules/%s/%s", this.config.pagePath, TextParser.parse((String)this.config.pageNamePattern, (CompositeMap)pageMap));
    }

    private void createScreen(CompositeMap modelMap, String page_path) throws Exception {
        SourceGenManager sgm = new SourceGenManager(this.registry);
        SourceTemplateProvider stp = new SourceTemplateProvider(this.registry);
        sgm.setTemplateProvider(stp);
        stp.initialize();
        stp.setTemplate("workflow");
        CompositeMap screen = sgm.buildScreen(modelMap);
        this.writeScreenFile(screen, page_path);
    }

    private void writeScreenFile(CompositeMap data, String page_path) throws Exception {
        File f = new File(this.webHome, page_path);
        f.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(data.toXML().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void updatePageMap(CompositeMap pageMap) throws Exception {
        BusinessModelService bms = this.svcFactory.getModelService(this.config.pageModel, this.getContext());
        bms.updateByPK((Map)pageMap);
    }

    public void setContext(CompositeMap context) {
        this.context = context;
    }

    public CompositeMap getContext() {
        return this.context;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public boolean isSaveUip() {
        return this.saveUip;
    }

    public void setSaveUip(boolean saveUip) {
        this.saveUip = saveUip;
    }

    public void run(ProcedureRunner runner) throws Exception {
        this.context = runner.getContext();
    }

    public static CompositeMap query(DatabaseServiceFactory svcFactory, CompositeMap context, String bm, CompositeMap para) throws Exception {
        BusinessModelService bms = svcFactory.getModelService(bm, context);
        return bms.queryAsMap((Map)para);
    }

    public static CompositeMap queryFirst(DatabaseServiceFactory svcFactory, CompositeMap context, String bm, CompositeMap para) throws Exception {
        CompositeMap res = PageGenerator.query(svcFactory, context, bm, para);
        if (res != null && res.getChilds() != null && res.getChilds().size() > 0) {
            return (CompositeMap)res.getChilds().get(0);
        }
        return null;
    }

    public CompositeMap getPageMap() throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"custom_page_id", (Object)this.pageId);
        return PageGenerator.queryFirst(this.svcFactory, this.context, this.config.pageModel, para);
    }
}

