/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;

public class StyledStringText
extends AuroraComponent {
    private static final String STYLED_STRING_TEXT = "styled_string_text";
    private static final String IS_BOLD = "is_bold";
    private static final String IS_ITALIC = "is_italic";
    private static final String IS_UNDERLINE = "is_underline";
    private static final String IS_STRIKEOUT = "is_strikeout";
    private static final String FOREGROUND = "foreground";
    private static final String BACKGROUND = "background";
    private static final String STRIKEOUT_COLOR = "strikeout_color";
    private static final String UNDERLINE_COLOR = "underline_color";
    private static final String UNDERLINE_STYLE = "underline_style";
    private String text;
    private String fontName;
    private int fontSize;
    public static final String UNAVAILABLE_RGB = "-1,-1,-1";

    public StyledStringText() {
        this.setComponentType(STYLED_STRING_TEXT);
        this.setUnderlineColor(UNAVAILABLE_RGB);
        this.setStrikeoutColor(UNAVAILABLE_RGB);
        this.setTextBackground(UNAVAILABLE_RGB);
        this.setTextForeground(UNAVAILABLE_RGB);
    }

    public boolean isUseless() {
        if (this.isBold()) {
            return false;
        }
        if (this.isItalic()) {
            return false;
        }
        if (this.isStrikeout()) {
            return false;
        }
        if (this.isUnderline()) {
            return false;
        }
        if (this.getUnderlineStyle() >= 0 && this.getUnderlineStyle() <= 4) {
            return false;
        }
        if (!this.getTextBackground().equals(UNAVAILABLE_RGB)) {
            return false;
        }
        if (!this.getTextForeground().equals(UNAVAILABLE_RGB)) {
            return false;
        }
        if (!this.getUnderlineColor().equals(UNAVAILABLE_RGB)) {
            return false;
        }
        return this.getStrikeoutColor().equals(UNAVAILABLE_RGB);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isBold() {
        return this.getBooleanPropertyValue(IS_BOLD);
    }

    public void setBold(boolean bold) {
        this.setPropertyValue(IS_BOLD, bold);
    }

    public boolean isItalic() {
        return this.getBooleanPropertyValue(IS_ITALIC);
    }

    public void setItalic(boolean italic) {
        this.setPropertyValue(IS_ITALIC, italic);
    }

    public boolean isUnderline() {
        return this.getBooleanPropertyValue(IS_UNDERLINE);
    }

    public void setUnderline(boolean underline) {
        this.setPropertyValue(IS_UNDERLINE, underline);
    }

    public boolean isStrikeout() {
        return this.getBooleanPropertyValue(IS_STRIKEOUT);
    }

    public void setStrikeout(boolean strikeout) {
        this.setPropertyValue(IS_STRIKEOUT, strikeout);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getTextForeground() {
        return this.getStringPropertyValue(FOREGROUND);
    }

    public void setTextForeground(String textForeground) {
        this.setPropertyValue(FOREGROUND, textForeground);
    }

    public String getTextBackground() {
        return this.getStringPropertyValue(BACKGROUND);
    }

    public void setTextBackground(String textBackground) {
        this.setPropertyValue(BACKGROUND, textBackground);
    }

    public String getStrikeoutColor() {
        return this.getStringPropertyValue(STRIKEOUT_COLOR);
    }

    public void setStrikeoutColor(String strikeoutColor) {
        this.setPropertyValue(STRIKEOUT_COLOR, strikeoutColor);
    }

    public String getUnderlineColor() {
        return this.getStringPropertyValue(UNDERLINE_COLOR);
    }

    public void setUnderlineColor(String underlineColor) {
        this.setPropertyValue(UNDERLINE_COLOR, underlineColor);
    }

    public int getUnderlineStyle() {
        return this.getIntegerPropertyValue(UNDERLINE_STYLE);
    }

    public void setUnderlineStyle(int underlineStyle) {
        this.setPropertyValue(UNDERLINE_STYLE, underlineStyle);
    }
}

