/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.Navbar;
import aurora.plugin.source.gen.screen.model.TabItem;
import aurora.plugin.source.gen.screen.model.Toolbar;
import aurora.plugin.source.gen.screen.model.ToolbarButton;
import java.util.ArrayList;
import java.util.List;

public class ScreenBody
extends Container {
    public static final int DLabelWidth = 80;
    private static Class<?>[] unsupported = new Class[]{ToolbarButton.class, Toolbar.class, Navbar.class, GridColumn.class, TabItem.class};
    private List<String> unBindModels = new ArrayList<String>();
    public static final String TYPE_UPDATE = "update";
    public static final String TYPE_DISPLAY = "display";
    public static final String TYPE_CREATE = "create";
    public static final String TYPE_SERACH = "serach";

    public ScreenBody() {
        this.setComponentType("screenBody");
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent component) {
        Class<?> cls = component.getClass();
        for (Class<?> c : unsupported) {
            if (!c.equals(cls)) continue;
            return false;
        }
        return super.isResponsibleChild(component);
    }

    public String getBindTemplate() {
        return this.getStringPropertyValue("diagram_bind_template");
    }

    public void setBindTemplate(String bindTemplate) {
        this.setPropertyValue("diagram_bind_template", bindTemplate);
    }

    public boolean isBindTemplate() {
        String bindTemplate = this.getBindTemplate();
        return bindTemplate != null && !"".equals(bindTemplate.trim());
    }

    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        List<Container> containers = this.getContainers(this);
        for (Container container : containers) {
            String model;
            String sectionType = container.getSectionType();
            if (!"SECTION_TYPE_QUERY".equals(sectionType) && !"SECTION_TYPE_RESULT".equals(sectionType) || null == (model = container.getDataset().getModel())) continue;
            models.add(model);
        }
        for (String m : this.unBindModels) {
            if (models.contains(m)) continue;
            models.add(m);
        }
        return models;
    }

    public List<Container> getSectionContainers(Container container, String[] types) {
        ArrayList<Container> containers = new ArrayList<Container>();
        List<AuroraComponent> children = container.getChildren();
        for (AuroraComponent ac : children) {
            if (!(ac instanceof Container)) continue;
            String sectionType = ((Container)ac).getSectionType();
            if (this.contains(types, sectionType)) {
                containers.add((Container)ac);
            }
            containers.addAll(this.getSectionContainers((Container)ac, types));
        }
        return containers;
    }

    private boolean contains(Object[] types, Object type) {
        for (Object string : types) {
            if (!string.equals(type)) continue;
            return true;
        }
        return false;
    }

    public List<Container> getContainers(Container container) {
        ArrayList<Container> containers = new ArrayList<Container>();
        List<AuroraComponent> children = container.getChildren();
        for (AuroraComponent ac : children) {
            if (!(ac instanceof Container)) continue;
            containers.add((Container)ac);
            containers.addAll(this.getContainers((Container)ac));
        }
        return containers;
    }

    public String getTemplateType() {
        return this.getStringPropertyValue("diagram_bind_template_type");
    }

    public void setTemplateType(String templateType) {
        this.setPropertyValue("diagram_bind_template_type", templateType);
    }

    public boolean isForDisplay() {
        return TYPE_DISPLAY.equals(this.getTemplateType());
    }

    public boolean isForCreate() {
        return TYPE_CREATE.equals(this.getTemplateType());
    }

    public boolean isForUpdate() {
        return TYPE_UPDATE.equals(this.getTemplateType());
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("inner_editor_un_bind_models".equals(propId)) {
            return this.getUnBindModels();
        }
        return super.getPropertyValue(propId);
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("inner_editor_un_bind_models".equals(propId) && val instanceof List) {
            this.unBindModels = (List)val;
            return;
        }
        super.setPropertyValue(propId, val);
    }

    public boolean isForSearch() {
        return TYPE_SERACH.equals(this.getTemplateType());
    }

    public List<String> getUnBindModels() {
        return this.unBindModels;
    }

    public void addUnBindModel(String model) {
        if (model == null || "".equals(model)) {
            return;
        }
        this.unBindModels.add(model);
        this.firePropertyChange("inner_editor_un_bind_models", "", model);
    }
}

