/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.JavascriptRhino;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.IDialogEditableObject;
import aurora.plugin.source.gen.screen.model.Parameter;
import java.util.ArrayList;
import java.util.List;

public class Renderer
extends AuroraComponent
implements IDialogEditableObject {
    public static final String NONE_RENDERER = "NONE_RENDERER";
    public static final String PAGE_REDIRECT = "PAGE_REDIRECT";
    public static final String INNER_FUNCTION = "INNER_FUNCTION";
    public static final String USER_FUNCTION = "USER_FUNCTION";
    public static final String[] RENDERER_TYPES = new String[]{"NONE_RENDERER", "PAGE_REDIRECT", "INNER_FUNCTION", "USER_FUNCTION"};
    private List<Parameter> paras = new ArrayList<Parameter>();
    public static final String[] INNER_FUNCTIONS = new String[]{"Aurora.formatDate", "Aurora.formatDateTime", "Aurora.formatNumber"};
    public static final String FUNCTION_MODEL = "function myRenderer(value,record,name){\n\treturn 'rendererText';\n}";
    private GridColumn column;

    public Renderer() {
        this.setComponentType("renderer");
        this.setRendererType(NONE_RENDERER);
    }

    public void setColumn(GridColumn col) {
        this.column = col;
    }

    public GridColumn getColumn() {
        return this.column;
    }

    @Override
    public String getDescripition() {
        if (PAGE_REDIRECT.equals(this.getRendererType())) {
            return this.getLabelText();
        }
        if (INNER_FUNCTION.equals(this.getRendererType())) {
            return this.getFunctionName();
        }
        if (USER_FUNCTION.equals(this.getRendererType())) {
            JavascriptRhino js = new JavascriptRhino(this.getFunction());
            return "[ " + js.getFirstFunctionName() + " ]";
        }
        return "function";
    }

    @Override
    public Object getContextInfo() {
        return this.column;
    }

    @Override
    public Renderer clone() {
        Renderer r = new Renderer();
        r.setOpenPath(this.getOpenPath());
        r.paras = new ArrayList<Parameter>();
        for (Parameter p : this.paras) {
            r.paras.add(p.clone());
        }
        r.column = this.column;
        r.setLabelText(this.getLabelText());
        r.setFunction(this.getFunction());
        r.setFunctionName(this.getFunctionName());
        r.setRendererType(this.getRendererType());
        return r;
    }

    public String getOpenPath() {
        return this.getStringPropertyValue("openpath");
    }

    public void setOpenPath(String openPath) {
        this.setPropertyValue("openpath", openPath);
    }

    public String getLabelText() {
        return this.getStringPropertyValue("renderer_labeltext");
    }

    public void setLabelText(String tmpLabelText) {
        this.setPropertyValue("renderer_labeltext", tmpLabelText);
    }

    public String getFunctionName() {
        return this.getStringPropertyValue("renderer_function_name");
    }

    public void setFunctionName(String functionName) {
        this.setPropertyValue("renderer_function_name", functionName);
    }

    public String getFunction() {
        return this.getStringPropertyValue("renderer_function");
    }

    public void setFunction(String function) {
        this.setPropertyValue("renderer_function", function);
    }

    public String getRendererType() {
        return this.getStringPropertyValue("renderer_type");
    }

    public void setRendererType(String rendererType) {
        this.setPropertyValue("renderer_type", rendererType);
    }

    public List<Parameter> getParameters() {
        return this.paras;
    }

    public void addParameter(Parameter para) {
        this.paras.add(para);
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("renderer_parameters".equals(propId)) {
            return this.paras;
        }
        Object propertyValue = super.getPropertyValue(propId);
        return propertyValue;
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("renderer_parameters".equals(propId) && val instanceof List) {
            this.paras = (List)val;
            return;
        }
        super.setPropertyValue(propId, val);
    }
}

