/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Dataset;
import aurora.plugin.source.gen.screen.model.IDatasetDelegate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class Container
extends AuroraComponent
implements IDatasetDelegate {
    public static final String SECTION_TYPE_QUERY = "SECTION_TYPE_QUERY";
    public static final String SECTION_TYPE_BUTTON = "SECTION_TYPE_BUTTON";
    public static final String SECTION_TYPE_RESULT = "SECTION_TYPE_RESULT";
    public static final String[] SECTION_TYPES = new String[]{"SECTION_TYPE_QUERY", "SECTION_TYPE_BUTTON", "SECTION_TYPE_RESULT"};
    private Dataset dataset;
    protected List<AuroraComponent> children = new ArrayList<AuroraComponent>();

    public Container() {
        this.setSize(600, 80);
        this.setPrompt("");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("container_section_type".equals(evt.getPropertyName())) {
                    if (Container.SECTION_TYPE_QUERY.equals(evt.getNewValue())) {
                        Container.this.dataset.setComponentType("querydataset");
                    }
                    if (Container.SECTION_TYPE_RESULT.equals(evt.getNewValue())) {
                        Container.this.dataset.setComponentType("resultdataset");
                    }
                    if (Container.SECTION_TYPE_BUTTON.equals(evt.getNewValue())) {
                        Container.this.dataset.setComponentType("dataset");
                    }
                }
            }
        });
    }

    public void addChild(AuroraComponent child) {
        this.addChild(child, this.children.size());
    }

    public void addChild(AuroraComponent child, int index) {
        if (!this.isResponsibleChild(child)) {
            return;
        }
        this.children.add(index, child);
        child.setParent(this);
        this.fireStructureChange("component_children", child);
    }

    public List<AuroraComponent> getChildren() {
        return this.children;
    }

    public void removeChild(AuroraComponent child) {
        this.children.remove(child);
        this.fireStructureChange("component_children", child);
    }

    public void removeChild(int idx) {
        AuroraComponent ac = this.children.remove(idx);
        this.fireStructureChange("component_children", ac);
    }

    public boolean isResponsibleChild(AuroraComponent component) {
        return true;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        PropertyChangeListener[] propertyChangeListeners;
        for (PropertyChangeListener l : propertyChangeListeners = this.getPropertyChangeListeners()) {
            if (this.dataset != null) {
                this.dataset.removePropertyChangeListener(l);
            }
            dataset.addPropertyChangeListener(l);
        }
        this.dataset = dataset;
        this.dataset.setOwner(this);
    }

    public AuroraComponent getFirstChild(Class clazz) {
        List<AuroraComponent> children = this.getChildren();
        for (AuroraComponent auroraComponent : children) {
            if (!auroraComponent.getClass().equals(clazz)) continue;
            return auroraComponent;
        }
        return null;
    }

    public String getSectionType() {
        return this.getStringPropertyValue("container_section_type");
    }

    public void setSectionType(String sectionType) {
        this.setPropertyValue("container_section_type", sectionType);
    }

    public String toDisplayString() {
        return this.getComponentType() + "[" + this.getName() + "-" + this.getPrompt() + "]";
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("i_dataset_delegate".equals(propId)) {
            return this.dataset;
        }
        if ("component_children".equals(propId)) {
            return this.getChildren();
        }
        Object propertyValue = super.getPropertyValue(propId);
        return propertyValue;
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("i_dataset_delegate".equals(propId) && val instanceof Dataset) {
            this.setDataset((Dataset)val);
            return;
        }
        if ("component_children".equals(propId) && val instanceof List) {
            this.children = new ArrayList<AuroraComponent>();
            for (AuroraComponent c : (List)val) {
                this.addChild(c);
            }
            return;
        }
        super.setPropertyValue(propId, val);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (this.dataset != null) {
            this.dataset.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        if (this.dataset != null) {
            this.dataset.removePropertyChangeListener(l);
        }
    }
}

