/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.builders;

import aurora.plugin.source.gen.BuilderSession;
import aurora.plugin.source.gen.ButtonScriptGenerator;
import aurora.plugin.source.gen.ModelMapParser;
import aurora.plugin.source.gen.RendererScriptGenerator;
import aurora.plugin.source.gen.builders.DefaultSourceBuilder;
import aurora.plugin.source.gen.builders.JSBeautifier;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.XMLOutputter;

public class ScriptBuilder
extends DefaultSourceBuilder {
    @Override
    public void buildContext(BuilderSession session) {
    }

    @Override
    public void actionEvent(String event, BuilderSession session) {
        if ("javascript".equals(event)) {
            this.genScripts(session);
        }
    }

    public void genScripts(BuilderSession session) {
        CompositeMap currentModel = session.getCurrentModel();
        ModelMapParser mmp = session.createModelMapParser(currentModel);
        StringBuilder scripts = new StringBuilder();
        List<CompositeMap> buttons = mmp.getComponents("button");
        ButtonScriptGenerator bsg = new ButtonScriptGenerator(session);
        for (CompositeMap button : buttons) {
            String s;
            String s2;
            CompositeMap child;
            CompositeMap clicker = button.getChild("inner_buttonclicker");
            String functionName = session.getIDGenerator().genID("functionName", 0);
            button.put((Object)"click", (Object)functionName);
            String datasetID = mmp.getButtonTargetDatasetID(button);
            if (clicker == null) continue;
            String id = clicker.getString((Object)"button_click_actionid", "");
            if ("custom".equalsIgnoreCase(id) && (child = clicker.getChildByAttrib((Object)"propertye_id", (Object)"button_click_function")) != null) {
                s2 = child.getText();
                functionName = mmp.getFunctionName(s2);
                button.put((Object)"click", (Object)functionName);
                scripts.append(s2);
            }
            if ("query".equalsIgnoreCase(id)) {
                s = bsg.searchScript(functionName, datasetID);
                scripts.append(s);
            }
            if ("save".equalsIgnoreCase(id)) {
                s = bsg.saveScript(functionName, datasetID);
                scripts.append(s);
            }
            if ("reset".equalsIgnoreCase(id)) {
                s = bsg.resetScript(functionName, datasetID);
                scripts.append(s);
            }
            if ("open".equalsIgnoreCase(id)) {
                String link_id = clicker.getString((Object)"link_id", "");
                s2 = bsg.openScript(functionName, link_id);
                scripts.append(s2);
            }
            if (!"close".equalsIgnoreCase(id)) continue;
            String windowID = clicker.getString((Object)"closeWindowID", "");
            s2 = bsg.closeScript(functionName, windowID);
            scripts.append(s2);
        }
        List<CompositeMap> renderers = mmp.getComponents("renderer");
        for (CompositeMap renderer : renderers) {
            String type = renderer.getString((Object)"renderer_type", "");
            if ("INNER_FUNCTION".equals(type)) {
                renderer.getParent().put((Object)"renderer", (Object)renderer.getString((Object)"renderer_function_name", ""));
            }
            if ("PAGE_REDIRECT".equals(type)) {
                String functionName = session.getIDGenerator().genID("functionName", 0);
                renderer.getParent().put((Object)"renderer", (Object)functionName);
                String linkId = renderer.getString((Object)"link_id", "");
                String openFunctionName = session.getIDGenerator().genID("functionName", 0);
                RendererScriptGenerator rsg = new RendererScriptGenerator(session);
                CompositeMap inner_paramerter = renderer.getChildByAttrib((Object)"propertye_id", (Object)"renderer_parameters").getChildByAttrib((Object)"component_type", (Object)"inner_paramerter");
                String para_value = inner_paramerter.getString((Object)"parameter_value", "");
                String para_name = inner_paramerter.getString((Object)"parameter_name", "");
                String s1 = rsg.openScript(openFunctionName, linkId, para_name);
                String s = rsg.hrefScript(functionName, renderer.getString((Object)"renderer_labeltext", ""), openFunctionName, para_value);
                scripts.append(s);
                scripts.append(s1);
            }
            if (!"USER_FUNCTION".equals(type)) continue;
            String s = renderer.getChild("function").getText();
            String functionName = mmp.getFunctionName(s);
            renderer.getParent().put((Object)"renderer", (Object)functionName);
            scripts.append(s);
        }
        List<CompositeMap> footrenderers = mmp.getComponents("footrenderer");
        for (CompositeMap footrenderer : footrenderers) {
            CompositeMap child = footrenderer.getChild("cdataNode");
            if (child == null) continue;
            String s = child.getText();
            String functionName = mmp.getFunctionName(s);
            footrenderer.getParent().put((Object)"footerRenderer", (Object)functionName);
            scripts.append(s);
        }
        String string = scripts.toString();
        session.appendResultln(this.format(string));
    }

    private String format(String s) {
        JSBeautifier bf = new JSBeautifier();
        String prefix = "        ";
        String indent = "    " + prefix;
        String jsCodeNew = (XMLOutputter.LINE_SEPARATOR + bf.beautify(s, bf.opts)).replaceAll("\n", XMLOutputter.LINE_SEPARATOR + indent) + XMLOutputter.LINE_SEPARATOR + prefix;
        return jsCodeNew;
    }
}

