/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.builders;

import aurora.plugin.source.gen.builders.BeautifierFlags;
import aurora.plugin.source.gen.builders.BeautifierOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSBeautifier {
    public BeautifierOptions opts = new BeautifierOptions();
    public BeautifierFlags flags = new BeautifierFlags("BLOCK");
    public List flag_store = new LinkedList();
    boolean wanted_newline = false;
    boolean just_added_newline = false;
    boolean do_block_just_closed = false;
    String indent_string = "    ";
    String last_word = "";
    String last_type = "TK_START_EXPR";
    String last_text = "";
    String last_last_text = "";
    String input = null;
    StringBuffer output = new StringBuffer();
    String[] whitespace = new String[]{"\n", "\r", "\t", " "};
    String wordchar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$";
    String digits = "0123456789";
    String[] punct = "+ - * / % & ++ -- = += -= *= /= %= == === != !== > < >= <= >> << >>> >>>= >>= <<= && &= | || ! !! , : ? ^ ^= |= ::".split(" ");
    String[] line_starters = "continue,try,throw,return,var,if,switch,case,default,for,while,break,function".split(",");
    int parser_pos = 0;
    int n_newlines = 0;

    public JSBeautifier() {
        this.blank_state();
    }

    public JSBeautifier(BeautifierOptions opts) {
        this.opts = opts;
        this.blank_state();
    }

    public void blank_state() {
        this.set_mode("BLOCK");
    }

    public BeautifierOptions default_options() {
        return new BeautifierOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String beautify_file(String file_name, BeautifierOptions opts) {
        File file = new File(file_name);
        BufferedReader br = null;
        StringBuffer content = new StringBuffer();
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                content.append(line).append("\r\n");
            }
        }
        catch (Throwable e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return this.beautify(content.toString(), opts);
    }

    public void usage() {
        System.out.println("Javascript beautifier (http://jsbeautifier.org/)Usage: jsbeautifier.py [options] <infile>    <infile> can be '-', which means stdin.Input options: -i,  --stdin                      read input from stdinOutput options: -s,  --indent-size=NUMBER         indentation size. (default 4). -c,  --indent-char=CHAR           character to indent with. (default space). -d,  --disable-preserve-newlines  do not preserve existing line breaks. -j,  --jslint-happy               more jslint-compatible output -b,  --brace-style=collapse       brace style (collapse, expand, end-expand) -k,  --keep-array-indentation     keep array indentation.Rarely needed options: -l,  --indent-level=NUMBER        initial indentation level. (default 0). -h,  --help, --usage              prints this help statement.");
    }

    public String beautify(String s, BeautifierOptions opts) {
        if (opts != null) {
            this.opts = opts;
        }
        if (!this.isIn(opts.brace_style, new String[]{"expand", "collapse", "end-expand"})) {
            throw new RuntimeException("opts.brace_style must be 'expand', 'collapse' or 'end-expand'.");
        }
        this.blank_state();
        this.input = s;
        this.parser_pos = 0;
        while (true) {
            String[] token = this.get_next_token();
            String token_text = token[0];
            String token_type = token[1];
            if ("TK_EOF".equals(token_type)) break;
            if ("TK_START_EXPR".equals(token_type)) {
                this.handle_start_expr(token_text);
            } else if ("TK_END_EXPR".equals(token_type)) {
                this.handle_end_expr(token_text);
            } else if ("TK_START_BLOCK".equals(token_type)) {
                this.handle_start_block(token_text);
            } else if ("TK_END_BLOCK".equals(token_type)) {
                this.handle_end_block(token_text);
            } else if ("TK_WORD".equals(token_type)) {
                this.handle_word(token_text);
            } else if ("TK_SEMICOLON".equals(token_type)) {
                this.handle_semicolon(token_text);
            } else if ("TK_STRING".equals(token_type)) {
                this.handle_string(token_text);
            } else if ("TK_EQUALS".equals(token_type)) {
                this.handle_equals(token_text);
            } else if ("TK_OPERATOR".equals(token_type)) {
                this.handle_operator(token_text);
            } else if ("TK_BLOCK_COMMENT".equals(token_type)) {
                this.handle_block_comment(token_text);
            } else if ("TK_INLINE_COMMENT".equals(token_type)) {
                this.handle_inline_comment(token_text);
            } else if ("TK_COMMENT".equals(token_type)) {
                this.handle_comment(token_text);
            } else if ("TK_UNKNOWN".equals(token_type)) {
                this.handle_unknown(token_text);
            }
            this.last_last_text = this.last_text;
            this.last_type = token_type;
            this.last_text = token_text;
        }
        String str = this.output.toString().replaceAll("[\n ]+$", "");
        return str;
    }

    public void trim_output(boolean eat_newlines) {
        while (this.output != null && this.output.length() > 0 && (" ".equals(this.output.substring(this.output.length() - 1)) || this.indent_string.equals(this.output.substring(this.output.length() - 1)) || eat_newlines && this.isEq(this.output.substring(this.output.length() - 1), " ") || this.isEq(this.output.substring(this.output.length() - 1), this.indent_string) || eat_newlines && this.isIn(this.output.substring(this.output.length() - 1), new String[]{"\n", "\r"}))) {
            this.output.deleteCharAt(this.output.length() - 1);
        }
    }

    public boolean is_array(String mode) {
        return "[EXPRESSION]".equals(mode) || "[INDENDED-EXPRESSION]".equals(mode);
    }

    public boolean is_expression(String mode) {
        return "[EXPRESSION]".equals(mode) || "[INDENDED-EXPRESSION]".equals(mode) || "EXPRESSION".equals(mode);
    }

    public void append_newline(boolean ignore_repeated) {
        this.flags.eat_next_space = false;
        if (this.opts.keep_array_indentation && this.is_array(this.flags.mode)) {
            return;
        }
        this.flags.if_line = false;
        this.trim_output(false);
        if (this.output.length() == 0) {
            return;
        }
        if (!this.isEq(this.output.substring(this.output.length() - 1), "\n") || !ignore_repeated) {
            this.just_added_newline = true;
            this.output.append('\n');
        }
        for (int i = 0; i < this.flags.indentation_level; ++i) {
            this.output.append(this.indent_string);
        }
        if (this.flags.var_line && this.flags.var_line_reindented) {
            if (" ".equals(this.opts.indent_char)) {
                this.output.append("    ");
            } else {
                this.output.append(this.indent_string);
            }
        }
    }

    public void append(String s) {
        if (" ".equals(s)) {
            if (this.flags.eat_next_space) {
                this.flags.eat_next_space = false;
            } else if (!(this.output == null || this.output.toString().endsWith(" ") || this.output.toString().endsWith("\n") || this.output.toString().endsWith(this.indent_string))) {
                this.output.append(" ");
            }
        } else {
            this.just_added_newline = false;
            this.flags.eat_next_space = false;
            this.output.append(s);
        }
    }

    public void indent() {
        ++this.flags.indentation_level;
    }

    public void remove_indent() {
        if (this.output != null && this.output.toString().endsWith(this.indent_string)) {
            this.output.deleteCharAt(this.output.length() - 1);
        }
    }

    public void set_mode(String mode) {
        BeautifierFlags prev = new BeautifierFlags("BLOCK");
        if (this.flags != null) {
            this.flag_store.add(this.flags);
            prev = this.flags;
        }
        this.flags = new BeautifierFlags(mode);
        if (this.flag_store.size() == 1) {
            this.flags.indentation_level = this.opts.indent_level;
        } else {
            this.flags.indentation_level = prev.indentation_level;
            if (prev.var_line && prev.var_line_reindented) {
                ++this.flags.indentation_level;
            }
        }
        this.flags.previous_mode = prev.mode;
    }

    public void restore_mode() {
        this.do_block_just_closed = "DO_BLOCK".equals(this.flags.mode);
        if (this.flag_store.size() > 0) {
            this.flags = (BeautifierFlags)this.flag_store.remove(this.flag_store.size() - 1);
        }
    }

    public String[] get_next_token() {
        boolean keep_whitespace;
        this.n_newlines = 0;
        if (this.parser_pos >= this.input.length()) {
            return new String[]{"", "TK_EOF"};
        }
        this.wanted_newline = false;
        String c = this.input.substring(this.parser_pos, this.parser_pos + 1);
        ++this.parser_pos;
        boolean bl = keep_whitespace = this.opts.keep_array_indentation && this.is_array(this.flags.mode);
        if (keep_whitespace) {
            int whitespace_count = 0;
            while (this.isIn(c, this.whitespace)) {
                if ("\n".equals(c)) {
                    this.trim_output(false);
                    this.output.append("\n");
                    this.just_added_newline = true;
                    whitespace_count = 0;
                } else if ("\t".equals(c)) {
                    whitespace_count += 4;
                } else if (!"\r".equals(c)) {
                    ++whitespace_count;
                }
                if (this.parser_pos >= this.input.length()) {
                    return new String[]{"", "TK_EOF"};
                }
                c = this.input.substring(this.parser_pos, this.parser_pos + 1);
                ++this.parser_pos;
            }
            if (this.flags.indentation_baseline == -1) {
                this.flags.indentation_baseline = whitespace_count;
            }
            if (this.just_added_newline) {
                int i;
                for (i = 0; i < this.flags.indentation_level + 1; ++i) {
                    this.output.append(this.indent_string);
                }
                if (this.flags.indentation_baseline != -1) {
                    for (i = 0; i < whitespace_count - this.flags.indentation_baseline; ++i) {
                        this.output.append(" ");
                    }
                }
            }
        } else {
            while (this.isIn(c, this.whitespace)) {
                if ("\n".equals(c) && (this.opts.max_preserve_newlines == 0 || this.opts.max_preserve_newlines > this.n_newlines)) {
                    ++this.n_newlines;
                }
                if (this.parser_pos >= this.input.length()) {
                    return new String[]{"", "TK_EOF"};
                }
                c = this.input.substring(this.parser_pos, this.parser_pos + 1);
                ++this.parser_pos;
            }
            if (this.opts.preserve_newlines && this.n_newlines > 1) {
                for (int i = 0; i < this.n_newlines; ++i) {
                    this.append_newline(i == 0);
                    this.just_added_newline = true;
                }
            }
            boolean bl2 = this.wanted_newline = this.n_newlines > 0;
        }
        if (this.wordchar.indexOf(c) != -1) {
            if ("$".equals(c) && this.parser_pos < this.input.length() && "{".equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                c = c + "{";
                ++this.parser_pos;
                if (this.parser_pos < this.input.length()) {
                    while ((this.wordchar + "@/}").indexOf(this.input.substring(this.parser_pos, this.parser_pos + 1)) != -1) {
                        c = c + this.input.substring(this.parser_pos, this.parser_pos + 1);
                        ++this.parser_pos;
                        if (this.parser_pos != this.input.length() && !"}".equals(this.input.substring(this.parser_pos - 1, this.parser_pos))) continue;
                    }
                }
                return new String[]{c, "TK_WORD"};
            }
            if (this.parser_pos < this.input.length()) {
                while (this.wordchar.indexOf(this.input.substring(this.parser_pos, this.parser_pos + 1)) != -1) {
                    c = c + this.input.substring(this.parser_pos, this.parser_pos + 1);
                    ++this.parser_pos;
                    if (this.parser_pos != this.input.length()) continue;
                }
            }
            Pattern p = Pattern.compile("^[0-9]+[Ee]$");
            Matcher m = p.matcher(c);
            if (this.parser_pos != this.input.length() && "+-".indexOf(this.input.substring(this.parser_pos, this.parser_pos + 1)) != -1 && m.find()) {
                String sign = this.input.substring(this.parser_pos, this.parser_pos + 1);
                ++this.parser_pos;
                String[] t = this.get_next_token();
                c = c + sign + t[0];
                return new String[]{c, "TK_WORD"};
            }
            if ("in".equals(c)) {
                return new String[]{c, "TK_OPERATOR"};
            }
            if (!(!this.wanted_newline || "TK_OPERATOR".equals(this.last_type) || "TK_EQUALS".equals(this.last_type) || this.flags.if_line || !this.opts.preserve_newlines && "var".equals(this.last_text))) {
                this.append_newline(true);
            }
            return new String[]{c, "TK_WORD"};
        }
        if ("([".indexOf(c) != -1) {
            return new String[]{c, "TK_START_EXPR"};
        }
        if (")]".indexOf(c) != -1) {
            return new String[]{c, "TK_END_EXPR"};
        }
        if ("{".equals(c)) {
            return new String[]{c, "TK_START_BLOCK"};
        }
        if ("}".equals(c)) {
            return new String[]{c, "TK_END_BLOCK"};
        }
        if (";".equals(c)) {
            return new String[]{c, "TK_SEMICOLON"};
        }
        if ("/".equals(c)) {
            String comment = "";
            String comment_mode = "TK_INLINE_COMMENT";
            if ("*".equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                ++this.parser_pos;
                if (this.parser_pos < this.input.length()) {
                    while (!("*".equals(this.input.substring(this.parser_pos, this.parser_pos + 1)) && this.parser_pos + 1 < this.input.length() && "/".equals(this.input.substring(this.parser_pos + 1, this.parser_pos + 2)) || this.parser_pos >= this.input.length())) {
                        c = this.input.substring(this.parser_pos, this.parser_pos + 1);
                        comment = comment + c;
                        if ("\r\n".indexOf(c) != -1) {
                            comment_mode = "TK_BLOCK_COMMENT";
                        }
                        ++this.parser_pos;
                        if (this.parser_pos < this.input.length()) continue;
                    }
                }
                this.parser_pos += 2;
                return new String[]{"/*" + comment + "*/", comment_mode};
            }
            if ("/".equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                comment = c;
                while ("\r\n".indexOf(this.input.substring(this.parser_pos, this.parser_pos + 1)) == -1) {
                    comment = comment + this.input.substring(this.parser_pos, this.parser_pos + 1);
                    ++this.parser_pos;
                    if (this.parser_pos < this.input.length()) continue;
                }
                ++this.parser_pos;
                if (this.wanted_newline) {
                    this.append_newline(true);
                }
                return new String[]{comment, "TK_COMMENT"};
            }
        }
        if ("'".equals(c) || "\"".equals(c) || "/".equals(c) && (this.isEq(this.last_type, "TK_WORD") && this.isIn(this.last_text, new String[]{"return", "do"}) || this.isIn(this.last_type, new String[]{"TK_COMMENT", "TK_START_EXPR", "TK_START_BLOCK", "TK_END_BLOCK", "TK_OPERATOR", "TK_EQUALS", "TK_EOF", "TK_SEMICOLON"}))) {
            String sep = c;
            boolean esc = false;
            String resulting_string = c;
            boolean in_char_class = false;
            if (this.parser_pos < this.input.length()) {
                if ("/".equals(sep)) {
                    in_char_class = false;
                    while (esc || in_char_class || !this.isEq(this.input.substring(this.parser_pos, this.parser_pos + 1), sep)) {
                        resulting_string = resulting_string + this.input.substring(this.parser_pos, this.parser_pos + 1);
                        if (!esc) {
                            esc = "\\".equals(this.input.substring(this.parser_pos, this.parser_pos + 1));
                            if ("[".equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                                in_char_class = true;
                            } else if ("]".equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                                in_char_class = false;
                            }
                        } else {
                            esc = false;
                        }
                        ++this.parser_pos;
                        if (this.parser_pos < this.input.length()) continue;
                        return new String[]{resulting_string, "TK_STRING"};
                    }
                } else {
                    while (esc || !sep.equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                        resulting_string = resulting_string + this.input.substring(this.parser_pos, this.parser_pos + 1);
                        esc = !esc ? "\\".equals(this.input.substring(this.parser_pos, this.parser_pos + 1)) : false;
                        ++this.parser_pos;
                        if (this.parser_pos < this.input.length()) continue;
                        return new String[]{resulting_string, "TK_STRING"};
                    }
                }
            }
            ++this.parser_pos;
            resulting_string = resulting_string + sep;
            if ("/".equals(sep)) {
                while (this.parser_pos < this.input.length() && this.wordchar.indexOf(this.input.substring(this.parser_pos, this.parser_pos + 1)) != -1) {
                    resulting_string = resulting_string + this.input.substring(this.parser_pos, this.parser_pos + 1);
                    ++this.parser_pos;
                }
            }
            return new String[]{resulting_string, "TK_STRING"};
        }
        if ("#".equals(c)) {
            if (this.output.length() == 0 && this.input.length() > 1 && "!".equals(this.input.substring(this.parser_pos, this.parser_pos + 1))) {
                String resulting_string = c;
                while (this.parser_pos < this.input.length() && !"\n".equals(c)) {
                    c = this.input.substring(this.parser_pos, this.parser_pos + 1);
                    resulting_string = resulting_string + c;
                    ++this.parser_pos;
                }
                this.output.append(resulting_string.trim() + "\n");
                this.append_newline(true);
                return this.get_next_token();
            }
            String sharp = "#";
            if (this.parser_pos < this.input.length() && this.digits.indexOf(this.input.substring(this.parser_pos, this.parser_pos + 1)) != -1) {
                do {
                    c = this.input.substring(this.parser_pos, this.parser_pos + 1);
                    sharp = sharp + c;
                    ++this.parser_pos;
                } while (this.parser_pos < this.input.length() && !this.isEq(c, "#") && !this.isEq(c, "="));
            }
            if (!this.isEq(c, "#") && this.parser_pos < this.input.length()) {
                if (this.isEq(this.input.substring(this.parser_pos, this.parser_pos + 1), "[") && this.isEq(this.input.substring(this.parser_pos + 1, this.parser_pos + 2), "]")) {
                    sharp = sharp + "[]";
                    this.parser_pos += 2;
                } else if (this.isEq(this.input.substring(this.parser_pos, this.parser_pos + 1), "{") && this.isEq(this.input.substring(this.parser_pos + 1, this.parser_pos + 2), "}")) {
                    sharp = sharp + "{}";
                    this.parser_pos += 2;
                }
            }
            return new String[]{sharp, "TK_WORD"};
        }
        if (this.isEq(c, "<") && "<!--".equals(this.input.substring(this.parser_pos - 1, this.parser_pos + 3))) {
            this.parser_pos += 3;
            this.flags.in_html_comment = true;
            return new String[]{"<!--", "TK_COMMENT"};
        }
        if (this.isEq(c, "-") && this.flags.in_html_comment && "-->".equals(this.input.substring(this.parser_pos - 1, this.parser_pos + 3))) {
            this.flags.in_html_comment = false;
            this.parser_pos += 2;
            if (this.wanted_newline) {
                this.append_newline(true);
            }
            return new String[]{"-->", "TK_COMMENT"};
        }
        if (this.isIn(c, this.punct)) {
            while (this.parser_pos < this.input.length() && this.isIn(c + this.input.substring(this.parser_pos, this.parser_pos + 1), this.punct)) {
                c = c + this.input.substring(this.parser_pos, this.parser_pos + 1);
                ++this.parser_pos;
                if (this.parser_pos < this.input.length()) continue;
            }
            if (this.isEq(c, "=")) {
                return new String[]{c, "TK_EQUALS"};
            }
            return new String[]{c, "TK_OPERATOR"};
        }
        return new String[]{c, "TK_UNKNOWN"};
    }

    public boolean isIn(String str, String[] strs) {
        if (strs == null || str == null) {
            return false;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isEq(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public void handle_start_expr(String token_text) {
        if ("[".equals(token_text)) {
            if ("TK_WORD".equals(this.last_type) || ")".equals(this.last_text)) {
                if (this.isIn(this.last_text, this.line_starters)) {
                    this.append(" ");
                }
                this.set_mode("(EXPRESSION)");
                this.append(token_text);
                return;
            }
            if (this.isIn(this.flags.mode, new String[]{"[EXPRESSION]", "[INDENTED-EXPRESSION]"})) {
                if (this.isEq(this.last_last_text, "]") && this.isEq(this.last_text, ",")) {
                    if (this.isEq(this.flags.mode, "[EXPRESSION]")) {
                        this.flags.mode = "[INDENTED-EXPRESSION]";
                        if (!this.opts.keep_array_indentation) {
                            this.indent();
                        }
                    }
                    this.set_mode("[EXPRESSION]");
                    if (!this.opts.keep_array_indentation) {
                        this.append_newline(true);
                    }
                } else if (this.isEq(this.last_text, "[")) {
                    if (this.isEq(this.flags.mode, "[EXPRESSION]")) {
                        this.flags.mode = "[INDENTED-EXPRESSION]";
                        if (!this.opts.keep_array_indentation) {
                            this.indent();
                        }
                    }
                    this.set_mode("[EXPRESSION]");
                    if (!this.opts.keep_array_indentation) {
                        this.append_newline(true);
                    }
                } else {
                    this.set_mode("[EXPRESSION]");
                }
            } else {
                this.set_mode("[EXPRESSION]");
            }
        } else {
            this.set_mode("(EXPRESSION)");
        }
        if (this.isEq(this.last_text, ";") || this.isEq(this.last_type, "TK_START_BLOCK")) {
            this.append_newline(true);
        } else if (!this.isIn(this.last_type, new String[]{"TK_END_EXPR", "TK_START_EXPR", "TK_END_BLOCK"}) && !this.isEq(this.last_text, ".")) {
            if (!this.isIn(this.last_type, new String[]{"TK_WORD", "TK_OPERATOR"})) {
                this.append(" ");
            } else if (this.isEq(this.last_word, "function") || this.isEq(this.last_word, "typeof")) {
                if (this.opts.jslint_happy) {
                    this.append(" ");
                }
            } else if (this.isIn(this.last_text, this.line_starters) || this.isEq(this.last_text, "catch")) {
                this.append(" ");
            }
        }
        this.append(token_text);
    }

    public void handle_end_expr(String token_text) {
        if (this.isEq(token_text, "]")) {
            if (this.opts.keep_array_indentation) {
                if (this.isEq(this.last_text, "}")) {
                    this.remove_indent();
                    this.append(token_text);
                    this.restore_mode();
                    return;
                }
            } else if (this.isEq(this.flags.mode, "[INDENTED-EXPRESSION]") && this.isEq(this.last_text, "]")) {
                this.restore_mode();
                this.append_newline(true);
                this.append(token_text);
                return;
            }
        }
        this.restore_mode();
        this.append(token_text);
    }

    public void handle_start_block(String token_text) {
        if (this.isEq(this.last_word, "do")) {
            this.set_mode("DO_BLOCK");
        } else {
            this.set_mode("BLOCK");
        }
        if (this.isEq(this.opts.brace_style, "expand")) {
            if (!this.isEq(this.last_type, "TK_OPERATOR")) {
                if (this.isIn(this.last_text, new String[]{"return", "="})) {
                    this.append(" ");
                } else {
                    this.append_newline(true);
                }
            }
            this.append(token_text);
            this.indent();
        } else {
            if (!this.isIn(this.last_type, new String[]{"TK_OPERATOR", "TK_START_EXPR"})) {
                if (this.isEq(this.last_type, "TK_START_BLOCK")) {
                    this.append_newline(true);
                } else {
                    this.append(" ");
                }
            } else if (this.is_array(this.flags.previous_mode) && this.isEq(this.last_text, ",")) {
                if (this.isEq(this.last_last_text, "}")) {
                    this.append(" ");
                } else {
                    this.append_newline(true);
                }
            }
            this.indent();
            this.append(token_text);
        }
    }

    public void handle_end_block(String token_text) {
        this.restore_mode();
        if (this.isEq(this.opts.brace_style, "expand")) {
            if (!this.isEq(this.last_text, "{")) {
                this.append_newline(true);
            }
        } else {
            if (this.isEq(this.last_type, "TK_START_BLOCK")) {
                if (this.just_added_newline) {
                    this.remove_indent();
                } else {
                    this.trim_output(false);
                }
            } else if (this.is_array(this.flags.mode) && this.opts.keep_array_indentation) {
                this.opts.keep_array_indentation = false;
                this.append_newline(true);
                this.opts.keep_array_indentation = true;
            } else {
                this.append_newline(true);
            }
            this.append(token_text);
        }
    }

    public void handle_word(String token_text) {
        if (this.do_block_just_closed) {
            this.append(" ");
            this.append(token_text);
            this.append(" ");
            this.do_block_just_closed = false;
            return;
        }
        if (this.isEq(token_text, "function")) {
            if (this.flags.var_line) {
                this.flags.var_line_reindented = true;
            }
            if ((this.just_added_newline || this.isEq(this.last_text, ";")) && !this.isEq(this.last_text, "{")) {
                int have_newlines = this.n_newlines;
                if (!this.just_added_newline) {
                    have_newlines = 0;
                }
                if (!this.opts.preserve_newlines) {
                    have_newlines = 1;
                }
                for (int i = 0; i < 2 - have_newlines; ++i) {
                    this.append_newline(false);
                }
            }
        }
        if (this.isIn(token_text, new String[]{"case", "default"})) {
            if (this.isEq(this.last_text, ":")) {
                this.remove_indent();
            } else {
                --this.flags.indentation_level;
                this.append_newline(true);
                ++this.flags.indentation_level;
            }
            this.append(token_text);
            this.flags.in_case = true;
            return;
        }
        String prefix = "NONE";
        if (this.isEq(this.last_type, "TK_END_BLOCK")) {
            if (!this.isIn(token_text, new String[]{"else", "catch", "finally"})) {
                prefix = "NEWLINE";
            } else if (this.isIn(this.opts.brace_style, new String[]{"expand", "end-expand"})) {
                prefix = "NEWLINE";
            } else {
                prefix = "SPACE";
                this.append(" ");
            }
        } else if (this.isEq(this.last_type, "TK_SEMICOLON") && this.isIn(this.flags.mode, new String[]{"BLOCK", "DO_BLOCK"})) {
            prefix = "NEWLINE";
        } else if (this.isEq(this.last_type, "TK_SEMICOLON") && this.is_expression(this.flags.mode)) {
            prefix = "SPACE";
        } else if (this.isEq(this.last_type, "TK_STRING")) {
            prefix = "NEWLINE";
        } else if (this.isEq(this.last_type, "TK_WORD")) {
            if (this.isEq(this.last_text, "else")) {
                this.trim_output(true);
            }
            prefix = "SPACE";
        } else if (this.isEq(this.last_type, "TK_START_BLOCK")) {
            prefix = "NEWLINE";
        } else if (this.isEq(this.last_type, "TK_END_EXPR")) {
            this.append(" ");
            prefix = "NEWLINE";
        }
        if (this.flags.if_line && this.isEq(this.last_type, "TK_END_EXPR")) {
            this.flags.if_line = false;
        }
        if (this.isIn(token_text, this.line_starters)) {
            prefix = this.isEq(this.last_text, "else") ? "SPACE" : "NEWLINE";
        }
        if (this.isIn(token_text, new String[]{"else", "catch", "finally"})) {
            if (!this.isEq(this.last_type, "TK_END_BLOCK") || this.isEq(this.opts.brace_style, "expand") || this.isEq(this.opts.brace_style, "end-expand")) {
                this.append_newline(true);
            } else {
                this.trim_output(true);
                this.append(" ");
            }
        } else if (this.isEq(prefix, "NEWLINE")) {
            if (!this.isEq(token_text, "function") || !this.isEq(this.last_type, "TK_START_EXPR") && !this.isIn(this.last_text, new String[]{"=", ","})) {
                if (this.isEq(token_text, "function") && this.isEq(this.last_text, "new")) {
                    this.append(" ");
                } else if (this.isIn(this.last_text, new String[]{"return", "throw"})) {
                    this.append(" ");
                } else if (!this.isEq(this.last_type, "TK_END_EXPR")) {
                    if (!(this.isEq(this.last_type, "TK_START_EXPR") && this.isEq(token_text, "var") || this.isEq(this.last_text, ":"))) {
                        if (this.isEq(token_text, "if") && this.isEq(this.last_word, "else") && !this.isEq(this.last_text, "{")) {
                            this.append(" ");
                        } else {
                            this.flags.var_line = false;
                            this.flags.var_line_reindented = false;
                            this.append_newline(true);
                        }
                    }
                } else if (this.isIn(token_text, this.line_starters) && !this.isEq(this.last_text, ")")) {
                    this.flags.var_line = false;
                    this.flags.var_line_reindented = false;
                    this.append_newline(true);
                }
            }
        } else if (this.is_array(this.flags.mode) && this.isEq(this.last_text, ",") && this.isEq(this.last_last_text, "}")) {
            this.append_newline(true);
        } else if (this.isEq(prefix, "SPACE")) {
            this.append(" ");
        }
        this.append(token_text);
        this.last_word = token_text;
        if (this.isEq(token_text, "var")) {
            this.flags.var_line = true;
            this.flags.var_line_reindented = false;
            this.flags.var_line_tainted = false;
        }
        if (this.isEq(token_text, "if")) {
            this.flags.if_line = true;
        }
        if (this.isEq(token_text, "else")) {
            this.flags.if_line = false;
        }
    }

    public void handle_semicolon(String token_text) {
        this.append(token_text);
        this.flags.var_line = false;
        this.flags.var_line_reindented = false;
        if (this.isEq(this.flags.mode, "OBJECT")) {
            this.flags.mode = "BLOCK";
        }
    }

    public void handle_string(String token_text) {
        if (this.isIn(this.last_type, new String[]{"TK_START_BLOCK", "TK_END_BLOCK", "TK_SEMICOLON"})) {
            this.append_newline(true);
        } else if (this.isEq(this.last_type, "TK_WORD")) {
            this.append(" ");
        }
        this.append(token_text);
    }

    public void handle_equals(String token_text) {
        if (this.flags.var_line) {
            this.flags.var_line_tainted = true;
        }
        this.append(" ");
        this.append(token_text);
        this.append(" ");
    }

    public void handle_operator(String token_text) {
        boolean space_before = true;
        boolean space_after = true;
        if (this.flags.var_line && this.isEq(token_text, ",") && this.is_expression(this.flags.mode)) {
            this.flags.var_line_tainted = false;
        }
        if (this.flags.var_line && this.isEq(token_text, ",")) {
            if (this.flags.var_line_tainted) {
                this.append(token_text);
                this.flags.var_line_reindented = true;
                this.flags.var_line_tainted = false;
                this.append_newline(true);
                return;
            }
            this.flags.var_line_tainted = false;
        }
        if (this.isIn(this.last_text, new String[]{"return", "throw"})) {
            this.append(" ");
            this.append(token_text);
            return;
        }
        if (this.isEq(token_text, ":") && this.flags.in_case) {
            this.append(token_text);
            this.append_newline(true);
            this.flags.in_case = false;
            return;
        }
        if (this.isEq(token_text, "::")) {
            this.append(token_text);
            return;
        }
        if (this.isEq(token_text, ",")) {
            if (this.flags.var_line) {
                if (this.flags.var_line_tainted) {
                    this.append(token_text);
                    this.append_newline(true);
                    this.flags.var_line_tainted = false;
                } else {
                    this.append(token_text);
                    this.append(" ");
                }
            } else if (this.isEq(this.last_type, "TK_END_BLOCK") && !this.isEq(this.flags.mode, "(EXPRESSION)")) {
                this.append(token_text);
                if (this.isEq(this.flags.mode, "OBJECT") && this.isEq(this.last_text, "}")) {
                    this.append_newline(true);
                } else {
                    this.append(" ");
                }
            } else if (this.isEq(this.flags.mode, "OBJECT")) {
                this.append(token_text);
                this.append_newline(true);
            } else {
                this.append(token_text);
                this.append(" ");
            }
            return;
        }
        if (this.isIn(token_text, new String[]{"--", "++", "!"}) || this.isIn(token_text, new String[]{"+", "-"}) && this.isIn(this.last_type, new String[]{"TK_START_BLOCK", "TK_START_EXPR", "TK_EQUALS", "TK_OPERATOR"}) || this.isIn(this.last_text, this.line_starters)) {
            space_before = false;
            space_after = false;
            if (this.isEq(this.last_text, ";") && this.is_expression(this.flags.mode)) {
                space_before = true;
            }
            if (this.isEq(this.last_type, "TK_WORD") && this.isIn(this.last_text, this.line_starters)) {
                space_before = true;
            }
            if (this.isEq(this.flags.mode, "BLOCK") && this.isIn(this.last_text, new String[]{"{", ";"})) {
                this.append_newline(true);
            }
        } else if (this.isEq(token_text, ".")) {
            space_before = false;
        } else if (this.isEq(token_text, ":")) {
            if (this.flags.ternary_depth == 0) {
                this.flags.mode = "OBJECT";
                space_before = false;
            } else {
                --this.flags.ternary_depth;
            }
        } else if (this.isEq(token_text, "?")) {
            ++this.flags.ternary_depth;
        }
        if (space_before) {
            this.append(" ");
        }
        this.append(token_text);
        if (space_after) {
            this.append(" ");
        }
    }

    public void handle_block_comment(String token_text) {
        String[] lines = token_text.replaceAll("\r", "").split("\n");
        if (this.isEq(token_text.substring(0, 3), "/**") || this.isEq(token_text.substring(0, 2), "/*")) {
            this.append_newline(true);
            this.append(lines[0]);
            for (int i = 1; i < lines.length; ++i) {
                this.append_newline(true);
                this.append(" " + lines[i].trim());
            }
        } else {
            if (lines.length > 1) {
                this.append_newline(true);
                this.trim_output(false);
            } else {
                this.append(" ");
            }
            for (int i = 0; i < lines.length; ++i) {
                this.append(lines[i]);
                this.append("\n");
            }
            this.append_newline(true);
        }
    }

    public void handle_inline_comment(String token_text) {
        this.append(" ");
        this.append(token_text);
        if (this.is_expression(this.flags.mode)) {
            this.append(" ");
        } else {
            this.append_newline(true);
        }
    }

    public void handle_comment(String token_text) {
        if (this.wanted_newline) {
            this.append_newline(true);
        } else {
            this.append(" ");
        }
        this.append(token_text);
        this.append_newline(true);
    }

    public void handle_unknown(String token_text) {
        if (this.isIn(this.last_text, new String[]{"return", "throw"})) {
            this.append(" ");
        }
        this.append(token_text);
    }

    public static void main(String[] args) {
        String file_name = "test.js";
        JSBeautifier bf = new JSBeautifier();
        String js = bf.beautify_file(file_name, bf.opts);
        System.out.println(js);
    }
}

